/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.acl;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.acl.SrAclTableModel;
import com.sanrad.nms.client.data.acl.SrWorkbenchAclTableColumns;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.event.MainTreeEvent;
import com.sanrad.nms.client.event.acl.PolicyManagerEvent;
import com.sanrad.nms.client.gui.acl.AclTableHeader;
import com.sanrad.nms.server.logic.acl.Permission;
import java.util.ArrayList;
import java.util.List;

public class SrWorkbenchAclTableModel
extends SrAclTableModel {
    protected int[] m_origPermissions;
    protected Object[] m_originalData;
    private static SrLogger theLogger = SrLogger.getLogger();

    public SrWorkbenchAclTableModel(TargetNode targetNode) {
        super(targetNode, new SrWorkbenchAclTableColumns());
        this.m_originalData = new ArrayList(this.m_data).toArray();
        this.saveOriginalPermissions();
    }

    @Override
    public void refresh() {
        super.refresh();
    }

    private void saveOriginalPermissions() {
        int size = this.getRowCount();
        int permissionCol = this.getColumnIndex(AclTableHeader.ACCESS.getColumnName());
        this.m_origPermissions = new int[size];
        for (int i = 0; i < size; ++i) {
            this.m_origPermissions[i] = ((Permission)this.getValueAt(i, permissionCol)).intValue();
        }
    }

    public List<List<Object>> getAcl() {
        if (this.isDataChanged()) {
            int totalSize = this.getRowCount();
            ArrayList<List<Object>> data = new ArrayList<List<Object>>();
            int identCol = this.getColumnIndex(AclTableHeader.ALIAS.getColumnName());
            int accessCol = this.getColumnIndex(AclTableHeader.ACCESS.getColumnName());
            for (int i = totalSize - 1; i >= 0; --i) {
                List<Object> rowData = this.getRow(i);
                ArrayList<Object> entryData = new ArrayList<Object>();
                AliasObject combinedEntry = (AliasObject)rowData.get(identCol);
                IdentityNode identity = (IdentityNode)combinedEntry.getValue();
                Object aclEntry = combinedEntry.getAdditionalValue();
                entryData.add(identity.getIdentifier());
                entryData.add(rowData.get(accessCol));
                entryData.add(((SrTreeNode)aclEntry).getIdentifier());
                theLogger.trace(SrLogCategories.LEGACY, "add to data : ", identity.getAlias());
                data.add(entryData);
            }
            return data;
        }
        return null;
    }

    protected boolean isDataChanged() {
        boolean isChanged;
        boolean bl = isChanged = this.m_originalData.length != this.getRowCount();
        if (!isChanged) {
            for (int i = 0; i < this.m_originalData.length; ++i) {
                if (this.isRowEqual((List)this.m_originalData[i], i)) continue;
                return true;
            }
        }
        return isChanged;
    }

    private boolean isPermissionEqual(int permission, int row) {
        int origPermission = this.m_origPermissions[row];
        return permission == origPermission;
    }

    private boolean isRowEqual(List m_originalData, int row) {
        List<Object> changedRow = this.getRow(row);
        for (int i = 0; i < m_originalData.size(); ++i) {
            if (m_originalData.get(i).equals(changedRow.get(i))) continue;
            theLogger.trace(SrLogCategories.LEGACY, "ROW IS CHANGED in the workbench table.");
            return false;
        }
        int col = this.getColumnIndex(AclTableHeader.ACCESS.getColumnName());
        Permission p = (Permission)changedRow.get(col);
        if (!this.isPermissionEqual(p.intValue(), row)) {
            theLogger.trace(SrLogCategories.LEGACY, "Permission changed in workbench table.");
            return false;
        }
        return true;
    }

    @Override
    public void showTargetView(MainTreeEvent e) {
    }

    @Override
    public void aclEntryCreated(PolicyManagerEvent e) {
    }

    @Override
    public void aclEntryRemoved(PolicyManagerEvent e) {
    }
}

