/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.acl;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.acl.AclEntryNode;
import com.sanrad.nms.client.data.acl.AclNode;
import com.sanrad.nms.client.data.acl.PolicyManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.event.MainTreeEvent;
import com.sanrad.nms.client.event.MainTreeListener;
import com.sanrad.nms.client.event.acl.PolicyManagerEvent;
import com.sanrad.nms.client.event.acl.PolicyManagerListener;
import com.sanrad.nms.client.event.target.TargetAdapter;
import com.sanrad.nms.client.event.target.TargetEvent;
import com.sanrad.nms.client.event.target.TargetListener;
import com.sanrad.nms.client.gui.acl.AclTableHeader;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.swing.SrKeyObjectSelectionTableModel;
import com.sanrad.swing.SrTableColumns;
import com.sanrad.swing.TableHeader;
import java.util.Vector;

public class SrAclTableModel
extends SrKeyObjectSelectionTableModel
implements MainTreeListener,
PolicyManagerListener {
    protected static SrLogger theLogger = SrLogger.getLogger();
    protected TargetNode m_target;
    protected AclEntryNode DEF_ALL_ENTRY;
    private TargetListener m_targetListener;

    public SrAclTableModel(TargetNode targetNode, SrTableColumns cols) {
        super(cols);
        this.m_target = targetNode;
        this.initModel();
        this.m_targetListener = new TargetAdapter(){

            @Override
            public void targetRemove(TargetEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException("Null event");
                }
                if (e.getStub() == null) {
                    throw new IllegalArgumentException("Null event stub");
                }
                if (SrAclTableModel.this.m_target == null) {
                    return;
                }
                if (e.getStub().equals(SrAclTableModel.this.m_target.getStub())) {
                    SrAclTableModel.this.clear();
                }
            }
        };
    }

    @Override
    public void addListeners() {
        TargetManager.getInstance().addTargetListener(this.m_targetListener);
        if (this.m_target != null) {
            ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(this.m_target);
            PolicyManager policyMgr = clusterNode.getPolicyManager();
            policyMgr.addPolicyManagerListener(this);
        }
    }

    @Override
    public void removeListeners() {
        TargetManager.getInstance().removeTargetListener(this.m_targetListener);
        if (this.m_target != null) {
            ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(this.m_target);
            PolicyManager policyMgr = clusterNode.getPolicyManager();
            policyMgr.removePolicyManagerListener(this);
        }
    }

    protected String addAscendingMark(String str, int column) {
        return str;
    }

    public int getColumnIndex(TableHeader columnName) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            String colName = this.getColumnName(i);
            if (!columnName.equals(colName)) continue;
            return i;
        }
        return -1;
    }

    protected void initModel() {
        this.removeAllRows();
        if (this.m_target != null) {
            ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(this.m_target);
            if (clusterNode == null) {
                return;
            }
            PolicyManager policyMgr = clusterNode.getPolicyManager();
            AclNode aclNode = policyMgr.getAcl(this.m_target);
            if (aclNode != null) {
                Vector<AclEntryNode> entries = aclNode.getAclEntries();
                int size = entries.size();
                for (int i = 0; i < size; ++i) {
                    AclEntryNode entry = entries.get(i);
                    if (entry.getIdentity().getAlias().equals("DEF_ALL")) {
                        this.DEF_ALL_ENTRY = entry;
                        continue;
                    }
                    if (entry.getIdentity().isDisplayed()) {
                        this.addEntryNode(entry);
                    }
                    theLogger.trace(SrLogCategories.LEGACY, "initModel: addEntry- ", entry);
                }
            }
            this.fireTableRowsInserted(0, this.getLastRowIndex());
        }
    }

    public void refresh() {
        this.initModel();
    }

    protected void addEntryNode(AclEntryNode entry) {
        AliasObject combinedEntry = new AliasObject(entry.getIdentity(), entry);
        this.addRow(combinedEntry, entry.getPermission());
    }

    protected void addRow(AliasObject combinedEntry, Permission permission) {
        Vector rowData = this.prepareRow(combinedEntry, permission);
        this.addRowQuetly(rowData.toArray(), 0);
    }

    protected void addRowToEnd(AliasObject combinedEntry, Permission permission) {
        Vector rowData = this.prepareRow(combinedEntry, permission);
        this.addRowQuetly(rowData.toArray(), -1);
    }

    private Vector prepareRow(AliasObject combinedEntry, Permission permission) {
        Vector<Object> rowData = new Vector<Object>(this.getColumnCount());
        IdentityNode identityNode = (IdentityNode)combinedEntry.getValue();
        rowData.addElement(combinedEntry);
        rowData.addElement(identityNode.getDescription());
        rowData.addElement(permission);
        return rowData;
    }

    public void addEntries(IdentityNode[] identities) {
        int currentRow = this.getRowCount();
        for (int i = 0; i < identities.length; ++i) {
            this.addRowToEnd(new AliasObject(identities[i], identities[i]), Permission.N_A);
        }
        int newRowIndx = this.getLastRowIndex();
        if (currentRow <= newRowIndx) {
            if (currentRow == -1) {
                --currentRow;
            }
            this.fireTableRowsInserted(currentRow, this.getLastRowIndex());
        }
    }

    public void removeEntries(int[] rows) {
        if (rows != null && rows.length > 0) {
            for (int i = rows.length - 1; i >= 0; --i) {
                this.removeRowQuetly(rows[i]);
            }
            this.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
        }
    }

    public Vector<IdentityNode> getSelectedIdentities(int[] rows) {
        Vector<IdentityNode> identities = new Vector<IdentityNode>();
        if (rows != null && rows.length > 0) {
            int col = this.getColumnIndex(AclTableHeader.ALIAS.getColumnName());
            for (int i = 0; i < rows.length; ++i) {
                AliasObject aliasObject = (AliasObject)this.getValueAt(rows[i], col);
                identities.addElement((IdentityNode)aliasObject.getValue());
            }
        }
        return identities;
    }

    protected void removeEntry(AclEntryNode entryNode) {
        int rowsCount = this.getRowCount();
        int aliasCol = this.getColumnIndex(AclTableHeader.ALIAS.getColumnName());
        for (int i = 0; i < rowsCount; ++i) {
            AliasObject value = (AliasObject)this.getValueAt(i, aliasCol);
            AclEntryNode node = (AclEntryNode)value.getAdditionalValue();
            if (!node.equals(entryNode)) continue;
            this.removeRow(i);
            break;
        }
    }

    private Vector getCurrentRowData(int rowIndex) {
        int colCount = this.getColumnCount();
        Vector<Object> rowData = new Vector<Object>(colCount);
        for (int i = 0; i < colCount; ++i) {
            rowData.addElement(this.getValueAt(rowIndex, i));
        }
        return rowData;
    }

    public void moveSelectedEntry(int rowIndex, int offset) {
        if (rowIndex != -1) {
            Vector rowData = null;
            try {
                rowData = this.getCurrentRowData(rowIndex);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                theLogger.trace(SrLogCategories.LEGACY, ex);
                return;
            }
            try {
                int index = rowIndex + offset;
                if (index >= 0 && index < this.getRowCount()) {
                    this.removeRow(rowIndex);
                    this.addRow(rowData.toArray(), index);
                }
            }
            catch (Exception e) {
                theLogger.warn(SrLogCategories.LEGACY, e);
                this.addRow(rowData.toArray(), rowIndex);
                return;
            }
        }
    }

    private boolean isEntryBelongToTheModel(AclEntryNode entryNode) {
        TargetNode parentNode;
        return entryNode.getAclNodeParent() != null && (parentNode = entryNode.getAclNodeParent().getTargetParentNode()).equals(this.m_target);
    }

    @Override
    public void aclMapRefreshed(PolicyManagerEvent e) {
    }

    @Override
    public void aclEntryCreated(PolicyManagerEvent e) {
        AclEntryNode entryNode = e.getAclEntryNode();
        if (this.isEntryBelongToTheModel(entryNode)) {
            this.initModel();
        }
    }

    @Override
    public void aclEntryChanged(PolicyManagerEvent e) {
        AclEntryNode node = e.getAclEntryNode();
        int rows = this.getRowCount();
        int aliasCol = this.getColumnIndex(AclTableHeader.ALIAS.getColumnName());
        int accessCol = this.getColumnIndex(AclTableHeader.ACCESS.getColumnName());
        for (int i = 0; i < rows; ++i) {
            AliasObject value = (AliasObject)this.getValueAt(i, aliasCol);
            if (!value.getAdditionalValue().equals(node)) continue;
            this.setValueAt(node.getPermission(), i, accessCol);
            break;
        }
    }

    @Override
    public void aclEntryRemoved(PolicyManagerEvent e) {
        AclEntryNode entryNode = e.getAclEntryNode();
        if (this.isEntryBelongToTheModel(entryNode)) {
            this.initModel();
        }
    }

    @Override
    public void showTargetView(MainTreeEvent e) {
        TargetNode tgt = e.getTargetNode();
        this.removeListeners();
        this.m_target = tgt;
        this.initModel();
        this.addListeners();
    }

    @Override
    public void showRootView(MainTreeEvent e) {
    }

    @Override
    public void showClusterView(MainTreeEvent e) {
    }

    @Override
    public void showExposedVolumesView(MainTreeEvent e) {
    }

    @Override
    public void showUnExposedVolumesView(MainTreeEvent e) {
    }

    @Override
    public void showStorageMgmtView(MainTreeEvent e) {
    }

    @Override
    public void showIdentitiesView(MainTreeEvent e) {
    }

    @Override
    public void showVSwitchView(MainTreeEvent e) {
    }

    @Override
    public void newClusterHasBeenSelected(MainTreeEvent e) {
    }

    @Override
    public void showConsistencyGroupsView(MainTreeEvent e) {
    }

    @Override
    public void showJournalsView(MainTreeEvent e) {
    }

    @Override
    public void showPairDetailsView(MainTreeEvent e) {
    }

    @Override
    public void showSiteView(MainTreeEvent e) {
    }

    @Override
    public void showNexsanMgmtView(MainTreeEvent e) {
    }

    public void clear() {
        this.DEF_ALL_ENTRY = null;
        this.m_target = null;
        this.removeAllRows();
    }
}

