/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.acl;

import com.sanrad.nms.client.data.acl.AclEntryNode;
import com.sanrad.nms.client.data.acl.AclMap;
import com.sanrad.nms.client.data.acl.AclNode;
import com.sanrad.nms.client.data.acl.PolicyManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.gui.acl.AclGlobalTableHeader;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class SrAclGlobalTableModel
extends SrTableModel {
    public SrAclGlobalTableModel(ClusterNode aCluster) {
        super(new SrDefaultTableColumns(AclGlobalTableHeader.getColumnNames()));
        this.initModel(aCluster);
    }

    protected void initModel(ClusterNode aClusterNode) {
        if (aClusterNode != null) {
            PolicyManager policyMgr = aClusterNode.getPolicyManager();
            AclMap aclMap = policyMgr.getAllAcl();
            Enumeration keys = aclMap.keys();
            while (keys.hasMoreElements()) {
                TargetNode targetNode = (TargetNode)keys.nextElement();
                AclNode acl = (AclNode)aclMap.get(targetNode);
                Vector<AclEntryNode> entries = acl.getAclEntries();
                this.addRows(targetNode, entries);
            }
            this.fireTableRowsInserted(0, this.getLastRowIndex());
        } else {
            this.removeAllRows();
        }
    }

    protected void addRows(TargetNode targetNode, Vector aclEntries) {
        int totalEntries = aclEntries.size();
        for (int i = 0; i < totalEntries; ++i) {
            AclEntryNode entry = (AclEntryNode)aclEntries.get(i);
            this.addRow(targetNode, entry.getIdentity(), entry.getPermission());
        }
    }

    protected void addRow(TargetNode targetNode, IdentityNode identityNode, Permission permission) {
        if (identityNode.isDisplayed()) {
            Vector<Serializable> rowData = new Vector<Serializable>(3);
            rowData.addElement(targetNode);
            rowData.addElement(identityNode);
            rowData.addElement(permission);
            this.addRowQuetly(rowData.toArray(), -1);
        }
    }

    @Override
    public void removeListeners() {
    }

    @Override
    public void addListeners() {
    }
}

