/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.acl;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.Communication;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.acl.AclEntryNode;
import com.sanrad.nms.client.data.acl.AclMap;
import com.sanrad.nms.client.data.acl.AclNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.identity.IdentityManager;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.event.acl.PolicyManagerEvent;
import com.sanrad.nms.client.event.acl.PolicyManagerListener;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.acl.Acl;
import com.sanrad.nms.server.logic.acl.AclEntry;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.target.ISCSITarget;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class PolicyManager
extends ElementManager {
    private static SrLogger theLogger = SrLogger.getLogger();
    private AclMap aclMap = new AclMap();
    private Hashtable identTargetMap = new Hashtable();
    private com.sanrad.nms.server.logic.acl.PolicyManager policyMgrStub = null;
    private ClusterNode clusterNode;
    SrEventListenerManager.Informer aclMapRefreshedInformer = new SrEventListenerManager.Informer<PolicyManagerListener, PolicyManagerEvent>(){

        @Override
        public void inform(PolicyManagerListener listener, PolicyManagerEvent event) {
            listener.aclMapRefreshed(event);
        }
    };
    SrEventListenerManager.Informer aclEntryCreatedInformer = new SrEventListenerManager.Informer<PolicyManagerListener, PolicyManagerEvent>(){

        @Override
        public void inform(PolicyManagerListener listener, PolicyManagerEvent event) {
            listener.aclEntryCreated(event);
        }
    };
    SrEventListenerManager.Informer aclEntryChangedInformer = new SrEventListenerManager.Informer<PolicyManagerListener, PolicyManagerEvent>(){

        @Override
        public void inform(PolicyManagerListener listener, PolicyManagerEvent event) {
            listener.aclEntryChanged(event);
        }
    };
    SrEventListenerManager.Informer aclEntryRemovedInformer = new SrEventListenerManager.Informer<PolicyManagerListener, PolicyManagerEvent>(){

        @Override
        public void inform(PolicyManagerListener listener, PolicyManagerEvent event) {
            listener.aclEntryRemoved(event);
        }
    };

    public PolicyManager(ClusterNode clusterNode) {
        this.clusterNode = clusterNode;
        this.policyMgrStub = Communication.getInstance().getPolicyManager(clusterNode.getStub());
        this.readAllAclMapFromServer(false);
    }

    public void addPolicyManagerListener(PolicyManagerListener l) {
        this.m_listeners.add(l);
    }

    public void removePolicyManagerListener(PolicyManagerListener l) {
        this.m_listeners.remove(l);
    }

    public void clear() {
        this.aclMap.clear();
        this.identTargetMap.clear();
        IdentityManager.getInstance().clearIdentities(this.clusterNode);
    }

    public void clusterRemoved() {
        this.clusterNode = null;
    }

    public SrFuture<Void> editDefaultAclEntry(TargetNode targetNode, Permission permission) {
        Vector<AclEntryNode> aclEntries = this.getAcl(targetNode).getAclEntries();
        if (!aclEntries.isEmpty()) {
            AclEntryNode entry = aclEntries.get(0);
            HashMap<ClientParameterCode, Permission> params = new HashMap<ClientParameterCode, Permission>();
            params.put(ClientParameterCode.ACL_ENTRY_ACCESS, permission);
            theLogger.trace(SrLogCategories.LEGACY, "PolicyManager : trying to edit acl entry: ", entry);
            return ClientAOImpl.getInstance().changeElements(Collections.singleton(entry.getIdentifier()), params);
        }
        return new CompleteFuture<Void>("PolicyManager.editDefaultAclEntry");
    }

    public BigInteger calculateTotalStorageAccess(IdentityNode identityNode, Permission permission) {
        BigInteger total = new BigInteger("0");
        Object targets = this.identTargetMap.get(identityNode);
        if (targets != null) {
            List targetsVector = (List)targets;
            for (int i = 0; i < targetsVector.size(); ++i) {
                Object target = targetsVector.get(i);
                AclNode aclNode = (AclNode)this.aclMap.get(target);
                if (target instanceof Target) {
                    target = (TargetNode)SystemRootNode.getInstance().getRefByStub((Target)target);
                    if (target != null && aclNode == null) {
                        aclNode = (AclNode)this.aclMap.get(target);
                    }
                } else if (aclNode == null) {
                    aclNode = (AclNode)this.aclMap.get(((TargetNode)target).getStub());
                }
                if (aclNode == null || !aclNode.isEntryExist(identityNode, permission)) continue;
                BigInteger targetAccess = TargetManager.getInstance().calculateTotalStorageAccess((TargetNode)target);
                total = total.add(targetAccess);
            }
        }
        return total;
    }

    public boolean isReadOnlyTarget(TargetNode tgt) {
        Vector<AclEntryNode> entries;
        AclNode aclNode = (AclNode)this.aclMap.get(tgt);
        if (aclNode == null) {
            aclNode = (AclNode)this.aclMap.get(tgt.getStub());
        }
        if ((entries = aclNode.getAclEntries()) != null) {
            for (int i = 0; i < entries.size(); ++i) {
                AclEntryNode entry = entries.get(i);
                Permission permission = entry.getPermission();
                if (permission == null || !permission.equals(Permission.READ_WRITE)) continue;
                return false;
            }
        }
        return true;
    }

    public SrFuture<Void> updateAcl(TargetNode targetNode, List<List<Object>> newAclTable) {
        AclNode aclNode = this.getAcl(targetNode);
        return ClientAOImpl.getInstance().updateAcl((String)aclNode.getIdentifier(), new Vector<List<Object>>(newAclTable));
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    public void readAllAclMapFromServer(boolean broadcast) {
        try {
            if (broadcast) {
                IdentityManager.getInstance().getAllIdentities(this.clusterNode);
            }
            Hashtable map = this.policyMgrStub.getAllAcl();
            Set keys = map.keySet();
            for (Target targetStub : keys) {
                TargetNode targetNode = (TargetNode)SystemRootNode.getInstance().getRefByStub(targetStub);
                Acl acl = (Acl)map.get(targetStub);
                AclNode aclNode = this.createAclNode(acl, targetNode);
                List entries = acl.getEntries();
                for (Object curObj : entries) {
                    AclEntry aclEntry = (AclEntry)curObj;
                    if (aclEntry.isEntryForDRIdentityAll()) continue;
                    AclEntryNode entry = this.createAclEntryNode(aclEntry, null);
                    aclNode.addAclEntry(entry);
                    this.addToTargetIdentityMap(targetStub, entry);
                }
                if (targetNode == null) {
                    targetNode = TargetManager.getInstance().discoverTarget((ISCSITarget)targetStub);
                }
                this.aclMap.put(targetNode, aclNode);
                SystemRootNode.getInstance().putRefAndStub(acl, aclNode);
            }
            if (broadcast) {
                this.fireAclMapRefreshed();
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, "Could not read the ACl from the server...");
            PolicyManager.onConnectionError();
        }
    }

    private AclNode createAclNode(Acl acl, TargetNode targetParent) throws RemoteException {
        Target targetParentStub = acl.getTargetParent();
        theLogger.logAndAssert(SrLogCategories.ERROR, ((Target)targetParent.getStub()).equals(targetParentStub), new Object[]{"Wrong target was passed: ", targetParent.getAlias()});
        AclNode aclNode = new AclNode(acl, targetParent, targetParentStub);
        SystemRootNode.getInstance().putRefAndStub(acl, aclNode);
        return aclNode;
    }

    private void removeFromTargetIdentityMap(AclEntryNode aclEntryNode) {
        IdentityNode identity = aclEntryNode.getIdentity();
        AclNode acl = aclEntryNode.getAclNodeParent();
        Object targets = this.identTargetMap.get(identity);
        if (targets == null) {
            theLogger.trace(SrLogCategories.LEGACY, "failed to remove identity from [identity][target] map.....");
            return;
        }
        if (acl != null && !acl.isEntryExistMoreThanOnce(identity)) {
            TargetNode target = acl.getTargetParentNode();
            ((List)targets).remove(target);
        }
    }

    private void addToTargetIdentityMap(Target targetStub, AclEntryNode aclEntry) {
        TargetNode targetNode = (TargetNode)SystemRootNode.getInstance().getRefByStub(targetStub);
        if (targetNode == null) {
            this.addToTargetIdentityMapWORK_AROUND(targetStub, aclEntry);
        } else {
            this.addToTargetIdentityMapWORK_AROUND(targetNode, aclEntry);
        }
    }

    private void addToTargetIdentityMapWORK_AROUND(Object target, AclEntryNode aclEntry) {
        IdentityNode identity = aclEntry.getIdentity();
        Object targets = this.identTargetMap.get(identity);
        if (targets == null) {
            Vector<Object> targetsVec = new Vector<Object>();
            targetsVec.addElement(target);
            this.identTargetMap.put(identity, targetsVec);
        } else if (!((List)targets).contains(target)) {
            ((List)targets).add(target);
        }
    }

    private void addToTargetIdentityMap(TargetNode targetNode, AclEntryNode aclEntry) {
        theLogger.trace(SrLogCategories.LEGACY, "Adding to Target-Identity Map: ", targetNode.getAlias(), ", ", aclEntry);
        this.addToTargetIdentityMapWORK_AROUND(targetNode, aclEntry);
    }

    public List getTargetsForIdentity(IdentityNode identityNode) {
        if (this.identTargetMap.containsKey(identityNode)) {
            return (List)this.identTargetMap.get(identityNode);
        }
        return new ArrayList();
    }

    private AclEntryNode createAclEntryNode(AclEntry aclEntry, HashMap params) throws RemoteException {
        Identity identityStub = (Identity)this.getObjectForParam(params, "Missing code - ClientParameterCode.ACL_ENTRY_IDENTITY", true);
        Object permissionObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.ACL_ENTRY_PERMISSION", true);
        Object positionObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.ACL_ENTRY_POSITION", true);
        Object aclParentStubObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.ACL_ENTRY_PARENT_STUB", true);
        if (identityStub == null) {
            identityStub = aclEntry.getIdentity();
        }
        if (permissionObj == null) {
            permissionObj = aclEntry.getPermission();
        }
        if (positionObj == null) {
            positionObj = aclEntry.getPosition();
        }
        if (aclParentStubObj == null) {
            aclParentStubObj = aclEntry.getAclParent();
        }
        IdentityNode identity = (IdentityNode)SystemRootNode.getInstance().getRefByStub(identityStub);
        Permission permission = (Permission)permissionObj;
        Integer position = (Integer)positionObj;
        Acl aclParentStub = (Acl)aclParentStubObj;
        theLogger.trace(SrLogCategories.LEGACY, "creating a new Acl entry node: []");
        AclEntryNode aclEntryNode = new AclEntryNode(aclEntry, identity, permission, position, aclParentStub);
        SystemRootNode.getInstance().putRefAndStub(aclEntry, aclEntryNode);
        return aclEntryNode;
    }

    public AclMap getAllAcl() {
        return this.aclMap;
    }

    public AclNode getAcl(TargetNode target) {
        Object aclNode = this.aclMap.get(target);
        if (aclNode == null) {
            theLogger.warn(SrLogCategories.LEGACY, "ACL NODE is NULL !!!!!! for target- ", target);
            aclNode = this.aclMap.get(target.getStub());
            if (aclNode == null) {
                theLogger.error(SrLogCategories.LEGACY, "ACL NODE is NULL !!!!!! for target stub- ", target);
                try {
                    Acl aclStub = ((Target)target.getStub()).getAclForTarget();
                    if (aclStub == null) {
                        theLogger.error(SrLogCategories.LEGACY, "ACL NODE is NULL !!!!!! for target stub- ", target, " the ACL doesn't exist in the server");
                    } else {
                        theLogger.warn(SrLogCategories.LEGACY, "ACL NODE is NULL !!!!!! for target stub- ", target, " the ACL exist only in the server");
                    }
                    return (AclNode)SystemRootNode.getInstance().getRefByStub(aclStub);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            theLogger.trace(SrLogCategories.LEGACY, "ACL NODE is OK !!!!!! for target stub ", target);
            this.aclMap.remove(target.getStub());
            this.aclMap.put(target, aclNode);
        }
        return (AclNode)aclNode;
    }

    public void removeAclForTarget(TargetNode targetNode) {
        AclNode acl = this.getAcl(targetNode);
        if (acl != null) {
            Vector<AclEntryNode> entries = acl.getAclEntries();
            Enumeration<AclEntryNode> en = entries.elements();
            while (en.hasMoreElements()) {
                AclEntry stub = (AclEntry)en.nextElement().getStub();
                SystemRootNode.getInstance().removeRefAndIdByStub(stub);
            }
            SystemRootNode.getInstance().removeRefAndIdByStub((RemoteObject)acl.getStub());
        }
        this.aclMap.remove(targetNode);
        this.removeFromIdentityTargetMap(targetNode);
    }

    private void removeFromIdentityTargetMap(TargetNode targetNode) {
        Enumeration values = this.identTargetMap.elements();
        while (values.hasMoreElements()) {
            List targets = (List)values.nextElement();
            targets.remove(targetNode);
        }
    }

    public Vector<IdentityNode> getAvailableIdentitiesForTarget(TargetNode targetNode) {
        Object acl = this.aclMap.get(targetNode);
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(targetNode);
        Vector<IdentityNode> allIdentities = IdentityManager.getInstance().getAllIdentities(clusterNode);
        if (acl == null) {
            return allIdentities;
        }
        Vector<IdentityNode> available = new Vector<IdentityNode>(allIdentities);
        Vector<AclEntryNode> entries = ((AclNode)acl).getAclEntries();
        for (AclEntryNode entry : entries) {
            available.remove(entry.getIdentity());
        }
        return available;
    }

    private void removeFromAcl(AclEntryNode entryNode) {
        AclNode aclNode = entryNode.getAclNodeParent();
        if (aclNode != null) {
            aclNode.removeAclEntry(entryNode);
        }
    }

    private void addToAcl(AclEntryNode entryNode) {
        if (entryNode.getAclNodeParent() != null) {
            entryNode.getAclNodeParent().addAclEntry(entryNode);
        }
    }

    private void fireAclMapRefreshed() {
        PolicyManagerEvent event = new PolicyManagerEvent(this, null);
        this.m_listeners.fireEvent(PolicyManagerListener.class, event, this.aclMapRefreshedInformer);
    }

    private void fireAclEntryNodeCreatedEvent(AclEntryNode aclEntryNode) {
        PolicyManagerEvent event = new PolicyManagerEvent(this, aclEntryNode);
        this.m_listeners.fireEvent(PolicyManagerListener.class, event, this.aclEntryCreatedInformer);
    }

    private void fireAclEntryChanged(AclEntryNode aclEntryNode) {
        PolicyManagerEvent event = new PolicyManagerEvent(this, aclEntryNode);
        this.m_listeners.fireEvent(PolicyManagerListener.class, event, this.aclEntryChangedInformer);
    }

    private void fireAclEntryNodeRemovedEvent(AclEntryNode aclEntryNode) {
        PolicyManagerEvent event = new PolicyManagerEvent(this, aclEntryNode);
        this.m_listeners.fireEvent(PolicyManagerListener.class, event, this.aclEntryRemovedInformer);
    }

    public void createACLForTarget(TargetNode targetNode) throws RemoteException {
        Hashtable map = this.policyMgrStub.getAllAcl();
        Acl acl = (Acl)map.get(targetNode.getStub());
        if (acl == null) {
            theLogger.error(SrLogCategories.LEGACY, "Failed to get ACL stub from server for Target ", targetNode.getName());
            return;
        }
        AclNode aclNode = this.createAclNode(acl, targetNode);
        this.aclMap.put(targetNode, aclNode);
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        try {
            AclEntry aclEntry = (AclEntry)element;
            if (aclEntry.isEntryForDRIdentityAll()) {
                return;
            }
            Cluster clusterStub = SystemRootNode.getCluster(aclEntry);
            if (clusterStub.equals(this.clusterNode.getStub())) {
                if (this.alreadyExist(element)) {
                    return;
                }
                theLogger.trace(SrLogCategories.LEGACY, "PolicyManager: Acl entry created");
                HashMap params = this.getParameterList(e);
                AclEntryNode aclEntryNode = this.createAclEntryNode(aclEntry, params);
                if (aclEntryNode.getAclNodeParent() != null) {
                    TargetNode targetParent = aclEntryNode.getAclNodeParent().getTargetParentNode();
                    this.addToAcl(aclEntryNode);
                    this.addToTargetIdentityMap(targetParent, aclEntryNode);
                    theLogger.trace(SrLogCategories.LEGACY, "PolicyManager:  Acl entry created- ", aclEntryNode.getPermission());
                } else {
                    theLogger.warn(SrLogCategories.LEGACY, "ACL node parent of ", aclEntryNode, " is null");
                }
                this.fireAclEntryNodeCreatedEvent(aclEntryNode);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            PolicyManager.onConnectionError(re.getMessage());
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        try {
            AclEntry aclEntry = (AclEntry)element;
            if (aclEntry.isEntryForDRIdentityAll()) {
                return;
            }
            Cluster clusterStub = SystemRootNode.getCluster(aclEntry);
            if (clusterStub.equals(this.clusterNode.getStub())) {
                theLogger.trace(SrLogCategories.LEGACY, "PolicyManager: Acl entry removed");
                SrTreeNode node = SystemRootNode.getInstance().getRefByStub(element);
                if (node != null) {
                    AclEntryNode entryNode = (AclEntryNode)node;
                    theLogger.trace(SrLogCategories.LEGACY, "PolicyManager: Acl entry removed- ", ((AclEntryNode)node).getPermission());
                    this.removeFromTargetIdentityMap(entryNode);
                    this.removeFromAcl(entryNode);
                    this.fireAclEntryNodeRemovedEvent((AclEntryNode)node);
                    SystemRootNode.getInstance().removeRefAndIdByStub(element);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            PolicyManager.onConnectionError(re.getMessage());
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        try {
            SrTreeNode entry;
            AclEntry aclEntry = (AclEntry)element;
            if (aclEntry.isEntryForDRIdentityAll()) {
                return;
            }
            Cluster clusterStub = SystemRootNode.getCluster(aclEntry);
            if (clusterStub.equals(this.clusterNode.getStub()) && (entry = SystemRootNode.getInstance().getRefByStub(element)) != null) {
                AclEntryNode aclEntryNode = (AclEntryNode)entry;
                HashMap parameters = this.getParameterList(e);
                Object access = this.getObjectForParam(parameters, ClientParameterCode.ACL_ENTRY_ACCESS, false);
                if (access != null) {
                    Integer val = (Integer)access;
                    Permission permit = Permission.getPermission(val);
                    theLogger.trace(SrLogCategories.LEGACY, "PolicyManager: acl entry changed: access-right");
                    aclEntryNode.setPermission(permit);
                }
                this.fireAclEntryChanged(aclEntryNode);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            PolicyManager.onConnectionError(re.getMessage());
        }
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
        RemoteObject element = e.getStub();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
    }
}

