/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.acl;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.acl.AclEntryNode;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.server.logic.acl.Acl;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.target.Target;
import java.rmi.RemoteException;
import java.util.Vector;

public class AclNode
extends SrTreeNode<Acl, String> {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private Vector<AclEntryNode> aclEntries;
    private TargetNode targetParentNode;
    private Target targetParentStub;

    public AclNode(Acl stub, TargetNode targetParent, Target targetParentStub) throws RemoteException {
        super(stub, stub.hashKey());
        this.targetParentNode = targetParent;
        if (this.targetParentNode == null) {
            this.targetParentStub = targetParentStub;
            theLogger.logAndAssert(SrLogCategories.ERROR, "ACL appears before a target!");
        }
        this.aclEntries = new Vector();
    }

    public TargetNode getTargetParentNode() {
        if (this.targetParentNode == null) {
            this.targetParentNode = (TargetNode)SystemRootNode.getInstance().getRefByStub(this.targetParentStub);
            if (this.targetParentNode != null) {
                this.targetParentStub = null;
            }
        }
        return this.targetParentNode;
    }

    public Vector<AclEntryNode> getAclEntries() {
        return this.aclEntries;
    }

    public void addAclEntry(AclEntryNode entry) {
        this.aclEntries.addElement(entry);
    }

    public void removeAclEntry(AclEntryNode entry) {
        this.aclEntries.remove(entry);
    }

    public boolean containsIdentity(IdentityNode identity) {
        for (AclEntryNode entry : this.aclEntries) {
            if (!((Identity)entry.getIdentity().getStub()).equals(identity.getStub())) continue;
            return true;
        }
        return false;
    }

    public boolean isEntryExist(IdentityNode identity, Permission permission) {
        for (AclEntryNode entry : this.aclEntries) {
            if (!((Identity)entry.getIdentity().getStub()).equals(identity.getStub()) || !entry.getPermission().equals(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean isEntryExistMoreThanOnce(IdentityNode identity) {
        int counter = 0;
        for (AclEntryNode entry : this.aclEntries) {
            if (!((Identity)entry.getIdentity().getStub()).equals(identity.getStub())) continue;
            ++counter;
        }
        return counter > 1;
    }

    @Override
    public String type() {
        return "Acl";
    }

    @Override
    public String toString() {
        TargetNode targetParentNode = this.getTargetParentNode();
        return this.type() + ": targetParent - " + (targetParentNode == null ? null : targetParentNode.getAlias());
    }
}

