/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.acl;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.acl.AclNode;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.server.logic.acl.Acl;
import com.sanrad.nms.server.logic.acl.AclEntry;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.rmi.RemoteException;

public class AclEntryNode
extends SrTreeNode<AclEntry, CommKeyClassId> {
    private int position;
    private Permission permission;
    private IdentityNode identity;
    private AclNode aclNodeParent;
    private Acl aclParentStub;

    public AclEntryNode(AclEntry stub, IdentityNode identity, Permission permission, int position, Acl aclParentStub) throws RemoteException {
        super(stub, stub.getCommKeyClassId());
        this.position = position;
        this.permission = permission;
        this.identity = identity;
        this.aclParentStub = aclParentStub;
        this.setAclNodeParent();
    }

    private void setAclNodeParent() {
        this.aclNodeParent = (AclNode)SystemRootNode.getInstance().getRefByStub(this.aclParentStub);
    }

    public AclNode getAclNodeParent() {
        if (this.aclNodeParent == null) {
            this.setAclNodeParent();
        }
        return this.aclNodeParent;
    }

    public IdentityNode getIdentity() {
        return this.identity;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public String type() {
        return "Acl Entry";
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.type());
        sb.append(": pos-");
        sb.append(this.position);
        sb.append(", permit- ");
        sb.append(this.permission.toString());
        sb.append(", ident-");
        if (this.identity != null) {
            sb.append(this.identity.getAlias());
        }
        return sb.toString();
    }
}

