/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.comm.Communication;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.StubToReference;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.site.SiteManager;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.SystemRoot;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.dr.DRRoot;
import com.sanrad.nms.server.logic.storage.Storage;
import com.sanrad.nms.server.util.FileInterface;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import com.sanrad.util.SrEventListenerManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.tree.TreeNode;

public class SystemRootNode
extends SiteNode {
    private static SystemRootNode theInstance;
    private static FileInterface m_fileInterfaceStub;
    private static WeakHashMap<Object, ClusterNode> theStubToClusterNode;
    private static SrLogger theLogger;
    private DRRoot drRootStub = null;
    private Hashtable clusterStubRefMap = null;
    private StubToReference nonLogicObjectStubToReference = new StubToReference();
    private StubToReference systemRootStubToReference = new StubToReference();
    private ClusterNode currentClusterNode = null;
    private Hashtable m_stubToClusterRef = new Hashtable();
    private SrEventListenerManager myCurrentClusterListeners = new SrEventListenerManager();
    private final View<ClusterNode> myClusterView = new ClusterNodeView();

    private SystemRootNode() throws RemoteException {
        super(Communication.getInstance().getSystemRootStub(), Communication.getInstance().getSystemRootStub().getAlias(), Communication.getInstance().getSystemRootStub().getVSwitchGroupId());
        this.systemRootStubToReference.put((RemoteObject)this.getStub(), this);
        this.initClusterStubRefMap();
        this.setNodeIcon(ClientImageObject.SYSTEM_ROOT);
    }

    public static synchronized SystemRootNode getInstance() {
        if (theInstance == null) {
            try {
                theInstance = new SystemRootNode();
            }
            catch (RemoteException e) {
                theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
            }
        }
        return theInstance;
    }

    private void initClusterStubRefMap() {
        this.clusterStubRefMap = new Hashtable();
        try {
            ArrayList clusterStubs = Communication.getInstance().getClusterStubs();
            int size = clusterStubs.size();
            for (int i = 0; i < size; ++i) {
                Cluster cluster = (Cluster)clusterStubs.get(i);
                ClusterNode clusterNode = new ClusterNode(cluster, cluster.getAlias(), cluster.isSingleVSwitchMode(), cluster.getVSwitchGroupId());
                clusterNode.setAccessibleSpace(cluster.getAccessibleSpace());
                clusterNode.setFaultyInterval(cluster.getFaultyInterval());
                clusterNode.setKeepAlive(cluster.getKeepAlive());
                clusterNode.setSuspiciousInterval(cluster.getSuspiciousInterval());
                clusterNode.setTotalCapacity(cluster.getTotalCapacity());
                clusterNode.setFailoverEnable(cluster.isFailoverEnable());
                clusterNode.setTakeoverState(cluster.getTakeoverState());
                clusterNode.setCapablity(cluster.getCapability());
                clusterNode.setStatus(SiteManager.getSeverity(cluster.getPropagatedState()));
                this.addCluster(clusterNode);
            }
            AlarmSeverity alarmSeverity = ((SystemRoot)this.getStub()).getPropagatedState();
            this.setStatus(SiteManager.getSeverity(alarmSeverity));
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
        }
    }

    public ClusterNode getClusterNodeOfSource(SrTreeNode source) {
        if (source != null) {
            ClusterNode cluster = (ClusterNode)source.getAncestorOfType(ClusterNode.class);
            if (cluster != null) {
                return cluster;
            }
            return this.getClusterNodeOfStub((RemoteObject)source.getStub());
        }
        return null;
    }

    public ClusterNode getClusterNodeOfStub(RemoteObject stub) {
        if (stub == null) {
            return null;
        }
        try {
            ClusterNode clusterNode = theStubToClusterNode.get(stub);
            if (clusterNode != null) {
                return clusterNode;
            }
            if (stub instanceof Storage) {
                Cluster clusterStub = ((Storage)stub).getCluster();
                if (clusterStub != null) {
                    clusterNode = this.getClusterNode(clusterStub);
                }
            } else {
                if (stub instanceof Site) {
                    return null;
                }
                if (!(stub instanceof LogicObject)) {
                    ClusterNode retVal = this.getCurrentClusterNode();
                    return retVal;
                }
                Object obj = this.m_stubToClusterRef.get(stub);
                if (obj != null) {
                    clusterNode = (ClusterNode)obj;
                } else {
                    Cluster clusterStub = SystemRootNode.getCluster((LogicObject)stub);
                    clusterNode = this.getClusterNode(clusterStub);
                }
            }
            if (clusterNode != null) {
                theStubToClusterNode.put(stub, clusterNode);
            }
            return clusterNode;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            return null;
        }
    }

    public Vector<ClusterNode> getClusterNodes() {
        Vector<ClusterNode> clusterNodes = new Vector<ClusterNode>(this.clusterStubRefMap.size());
        Enumeration e = this.clusterStubRefMap.keys();
        while (e.hasMoreElements()) {
            Object clusterNode = this.clusterStubRefMap.get(e.nextElement());
            clusterNodes.addElement((ClusterNode)clusterNode);
        }
        return clusterNodes;
    }

    @Override
    public ClusterNode[] getSiteClusters() {
        ArrayList<ClusterNode> systemRootClustersChild = new ArrayList<ClusterNode>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            TreeNode child = this.getChildAt(i);
            if (!(child instanceof ClusterNode)) continue;
            systemRootClustersChild.add((ClusterNode)child);
        }
        ClusterNode[] children = new ClusterNode[systemRootClustersChild.size()];
        return systemRootClustersChild.toArray(children);
    }

    @Override
    public String type() {
        return "Root";
    }

    @Override
    public String toString() {
        return ClientLoader.PRODUCT_NAME;
    }

    public void addCluster(ClusterNode clusterNode) {
        try {
            Cluster clusterStub = (Cluster)clusterNode.getStub();
            this.clusterStubRefMap.put(clusterStub.getVSwitchGroupId(), clusterNode);
            theLogger.logAndAssert(SrLogCategories.ERROR, clusterStub.equals(Manager.getStubByRef(clusterNode)), new Object[]{"Stub is not in the map, reference=", clusterNode});
            clusterNode.setStatus(Manager.getSeverity(clusterStub.getPropagatedState()));
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
        }
    }

    public void removeCluster(ClusterNode aClusterNode) {
        aClusterNode.getStubToReference().clear();
        this.clusterStubRefMap.remove(aClusterNode.getVSwitchGroupId());
        if (aClusterNode.getStub() != null) {
            theStubToClusterNode.remove(aClusterNode.getStub());
        } else {
            for (Map.Entry<Object, ClusterNode> entry : theStubToClusterNode.entrySet()) {
                Object clusterStub = entry.getKey();
                ClusterNode clusterNode = entry.getValue();
                if (!clusterNode.equals(aClusterNode)) continue;
                theStubToClusterNode.remove(clusterStub);
                break;
            }
        }
        if (this.clusterStubRefMap.isEmpty()) {
            this.setCurrentClusterNode(null);
        }
        Object[] stubs = this.m_stubToClusterRef.keySet().toArray();
        for (int i = 0; i < stubs.length; ++i) {
            ClusterNode clusterNode = (ClusterNode)this.m_stubToClusterRef.get(stubs[i]);
            if (!clusterNode.equals(aClusterNode)) continue;
            this.m_stubToClusterRef.remove(stubs[i]);
        }
    }

    private StubToReference getStubToReferenceOfStub(Object stub) {
        StubToReference map;
        block10: {
            if (stub == null) {
                return null;
            }
            map = null;
            if (stub instanceof LogicObject) {
                if (!(stub instanceof Site)) {
                    try {
                        Cluster clusterStub = SystemRootNode.getCluster((LogicObject)stub);
                        if (clusterStub != null) {
                            map = this.getStubToReference(clusterStub);
                            ClusterNode currClusterNode = this.getClusterNode(clusterStub);
                            if (currClusterNode != null) {
                                map = currClusterNode.getStubToReference();
                            } else {
                                theLogger.logAndAssert(SrLogCategories.ERROR, "ClusterNode of ", clusterStub, " is null.");
                            }
                            break block10;
                        }
                        theLogger.error(SrLogCategories.ERROR, "ClusterStub of ", stub, " is null.");
                    }
                    catch (RemoteException re) {
                        Manager.onConnectionError();
                        theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                    }
                } else {
                    map = this.systemRootStubToReference;
                }
            } else {
                map = this.nonLogicObjectStubToReference;
            }
        }
        return map;
    }

    public SrTreeNode getRefByStub(RemoteObject stub) {
        if (!(stub instanceof Cluster)) {
            StubToReference map = this.getStubToReferenceOfStub(stub);
            if (map != null) {
                SrTreeNode retVal = map.get(stub);
                if (retVal == null) {
                    theLogger.error(SrLogCategories.ERROR, "Reference of ", stub, "; ID: ", StubToReference.getID(stub), " is null. map: ");
                }
                return retVal;
            }
        } else {
            return this.getClusterNode((Cluster)stub);
        }
        theLogger.error(SrLogCategories.ERROR, "StubToReference of ", stub, "; ID: ", StubToReference.getID(stub), " was NOT found, because stubToRef map is null.");
        theLogger.error(SrLogCategories.INFORMATIVE, "Trying to get ", stub, " from StubToReference map - map is null");
        return null;
    }

    public void putRefAndStub(RemoteObject stub, SrTreeNode ref) {
        StubToReference map = this.getStubToReferenceOfStub(stub);
        if (map != null && stub != null) {
            map.put(stub, ref);
            theLogger.logAndAssert(SrLogCategories.ERROR, stub.equals(Manager.getStubByRef(ref)), new Object[]{"Stub is not in the map, reference=", ref});
        } else if (map == null) {
            theLogger.error(SrLogCategories.INFORMATIVE, "Trying to add ", ref, " to StubToReference map - map is null");
        } else {
            theLogger.error(SrLogCategories.INFORMATIVE, "Trying to add ", ref, " to StubToReference map - stub is null");
        }
    }

    public Object removeRefAndIdByStub(RemoteObject stub) {
        StubToReference map = this.getStubToReferenceOfStub(stub);
        if (map != null) {
            this.m_stubToClusterRef.remove(stub);
            SrTreeNode ref = map.remove(stub);
            return ref;
        }
        theLogger.error(SrLogCategories.INFORMATIVE, "Trying to remove ", stub, "; ID: ", StubToReference.getID(stub), " from StubToReference map - map is null");
        return null;
    }

    private ClusterNode getClusterNode(Cluster clusterStub) {
        if (clusterStub == null) {
            theLogger.error(SrLogCategories.INFORMATIVE, "Argument clusterStub is null");
            return null;
        }
        try {
            ClusterNode clusterNode = theStubToClusterNode.get(clusterStub);
            if (clusterNode != null) {
                return clusterNode;
            }
            return (ClusterNode)this.clusterStubRefMap.get(clusterStub.getVSwitchGroupId());
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            return null;
        }
    }

    private StubToReference getStubToReference(Cluster clusterStub) {
        ClusterNode cluster = this.getClusterNode(clusterStub);
        return cluster == null ? null : cluster.getStubToReference();
    }

    public ClusterNode setCurrentClusterNode(SrTreeNode node) {
        ClusterNode previousClusterNode = this.getCurrentClusterNode();
        this.currentClusterNode = this.getClusterNodeOfSource(node);
        if (this.currentClusterNode != previousClusterNode) {
            this.myCurrentClusterListeners.fireEvent(CurrentClusterListener.class, null, new SrEventListenerManager.Informer<CurrentClusterListener, EventObject>(){

                @Override
                public void inform(CurrentClusterListener l, EventObject e) {
                    l.currentClusterChanged();
                }
            });
        }
        return previousClusterNode;
    }

    public void addCurrentClusterListener(CurrentClusterListener l) {
        this.myCurrentClusterListeners.add(l);
    }

    public ClusterNode getCurrentClusterNode() {
        return this.currentClusterNode;
    }

    public SiteNode getCurrentSiteNode() {
        ClusterNode clusterNode = this.getCurrentClusterNode();
        if (clusterNode != null) {
            return (SiteNode)clusterNode.getParent();
        }
        return this;
    }

    public void initAllPolicyManagers() {
        Enumeration<ClusterNode> e = this.getClusterNodes().elements();
        while (e.hasMoreElements()) {
            ClusterNode clusterNode = e.nextElement();
            clusterNode.initPolicyManager();
        }
    }

    public String getClusterTitle(String oldTitle, ClusterNode clusterNode) {
        if (clusterNode == null) {
            throw new IllegalArgumentException("ClusterNode shouldn't be null");
        }
        String clusterName = clusterNode.getAlias();
        String cluster = clusterName != null ? clusterName : "<none>";
        theLogger.logAndAssert(SrLogCategories.ERROR, clusterName != null, new Object[]{"check and document here why cluster name is null"});
        String prefix = clusterNode.isSingleVSwitchMode() ? ClientLoader.STORAGE_RESOURCE_GROUP_DISPLAY_STRING : ClientLoader.CLUSTER_DISPLAY_STRING;
        return prefix + " " + cluster + " - " + oldTitle;
    }

    public String getSiteTitle(String oldTitle, String siteName) {
        if (siteName != null) {
            return new StringBuffer("Site ").append(siteName).append(" - ").append(oldTitle).toString();
        }
        return oldTitle;
    }

    public boolean isLastCluster(ClusterNode node) {
        return this.clusterStubRefMap.size() == 1 && this.clusterStubRefMap.contains(node);
    }

    public SiteNode getSiteNode(SrTreeNode node) {
        ClusterNode cluster = this.getClusterNodeOfSource(node);
        if (cluster != null) {
            return (SiteNode)cluster.getParent();
        }
        return null;
    }

    public SiteNode getSiteNodeOfStub(LogicObject logicObject) {
        ClusterNode cluster = this.getClusterNodeOfStub(logicObject);
        if (cluster != null) {
            return (SiteNode)cluster.getParent();
        }
        return null;
    }

    public SiteNode getSiteNode(String alias) {
        return this.findSiteNode(this, alias);
    }

    private SiteNode findSiteNode(SiteNode parent, String alias) {
        if (String.valueOf(parent.getAlias()).equals(alias)) {
            return parent;
        }
        Enumeration<TreeNode> e = parent.children();
        while (e.hasMoreElements()) {
            SiteNode siteNode;
            TreeNode node = e.nextElement();
            if (!(node instanceof SiteNode) || (siteNode = this.findSiteNode((SiteNode)node, alias)) == null) continue;
            return siteNode;
        }
        return null;
    }

    public SiteNode[] getSiteNodes() {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            TreeNode node = e.nextElement();
            if (!(node instanceof SiteNode)) continue;
            nodes.add(node);
        }
        SiteNode[] sitesNodes = new SiteNode[nodes.size()];
        return nodes.toArray(sitesNodes);
    }

    public DRRoot getDRRootStub() {
        if (this.drRootStub == null) {
            try {
                this.drRootStub = ((SystemRoot)this.getStub()).getDRRoot();
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            }
        }
        return this.drRootStub;
    }

    public FileInterface getFileInterfaceStub() {
        if (m_fileInterfaceStub == null) {
            try {
                m_fileInterfaceStub = ((SystemRoot)this.getStub()).getFileInterface();
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            }
        }
        return m_fileInterfaceStub;
    }

    @Override
    public boolean containsVSwitches() {
        if (super.containsVSwitches()) {
            return true;
        }
        for (SiteNode siteNode : this.getSiteNodes()) {
            if (!siteNode.containsVSwitches()) continue;
            return true;
        }
        return false;
    }

    public static Cluster getCluster(GeneralLogicObject aStub) throws RemoteException {
        ClusterNode savedNode = theStubToClusterNode.get(aStub);
        if (savedNode == null) {
            return aStub.getCluster();
        }
        return (Cluster)savedNode.getStub();
    }

    public static ClusterNode getCluster(String aStorageHashKey) {
        for (ClusterNode cluster : theStubToClusterNode.values()) {
            if (!cluster.getStorageID().equals(aStorageHashKey)) continue;
            return cluster;
        }
        return null;
    }

    public View<ClusterNode> getClusterView() {
        return this.myClusterView;
    }

    static {
        m_fileInterfaceStub = null;
        theStubToClusterNode = new WeakHashMap();
        theLogger = SrLogger.getLogger();
    }

    private class ClusterNodeView
    implements View<ClusterNode>,
    CurrentClusterListener {
        private SrEventListenerManager myListeners = new SrEventListenerManager();

        public ClusterNodeView() {
            SystemRootNode.this.addCurrentClusterListener(this);
        }

        @Override
        public Collection<ClusterNode> getValue() {
            ArrayList<ClusterNode> retVal = new ArrayList<ClusterNode>(1);
            if (SystemRootNode.this.currentClusterNode != null) {
                retVal.add(SystemRootNode.this.currentClusterNode);
            }
            return retVal;
        }

        @Override
        public void addListener(SrAction<ClusterNode, ?> action) {
            this.myListeners.add(action);
        }

        @Override
        public void removeListener(SrAction<ClusterNode, ?> action) {
            this.myListeners.remove(action);
        }

        @Override
        public void currentClusterChanged() {
            this.myListeners.fireEvent(SrAction.class, null, SrAction.theUpdateInformer);
        }
    }

    public static interface CurrentClusterListener
    extends EventListener {
        public void currentClusterChanged();
    }
}

