/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.server.RemoteObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class StubToReference {
    private static SrLogger theLogger = SrLogger.getLogger();
    private HashMap<String, SrTreeNode> myKeyToRefMap = new HashMap();

    public void put(RemoteObject stub, SrTreeNode reference) {
        String key = StubToReference.getID(stub);
        this.myKeyToRefMap.put(key, reference);
        theLogger.logAndAssert(SrLogCategories.ERROR, stub.equals(Manager.getStubByRef(reference)), new Object[]{"Stub is not in the map, reference=", reference});
    }

    public static String getID(RemoteObject stub) {
        if (stub != null) {
            try {
                return stub.hashKey();
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.EXCEPTION, re, "stub: ", stub);
                return null;
            }
        }
        theLogger.warn(SrLogCategories.ERROR, "stub is null.");
        return null;
    }

    public SrTreeNode remove(RemoteObject key) {
        return this.remove(StubToReference.getID(key));
    }

    public SrTreeNode remove(String aHashKey) {
        return this.myKeyToRefMap.remove(aHashKey);
    }

    public SrTreeNode get(RemoteObject stub) {
        String key = StubToReference.getID(stub);
        if (key == null) {
            theLogger.error(SrLogCategories.ERROR, "ID of ", stub, " is null.");
            return null;
        }
        return this.myKeyToRefMap.get(key);
    }

    public void clear() {
        this.myKeyToRefMap.clear();
    }

    public void clearAllButVSwitches() {
        Set<String> coll = this.myKeyToRefMap.keySet();
        Object[] arr = coll.toArray();
        for (int j = 0; j < arr.length; ++j) {
            Object key = null;
            try {
                key = arr[j];
            }
            catch (Exception e) {
                theLogger.warn(SrLogCategories.LEGACY, e);
                continue;
            }
            SrTreeNode val = this.myKeyToRefMap.get(key);
            if (!(val instanceof VSwitchNode) && val instanceof ClusterNode) continue;
        }
    }

    public List<VSwitchNode> getAvailableVSwitches() {
        ArrayList<VSwitchNode> v = new ArrayList<VSwitchNode>();
        Set<String> coll = this.myKeyToRefMap.keySet();
        String[] arr = new String[coll.size()];
        coll.toArray(arr);
        for (int j = 0; j < arr.length; ++j) {
            SrTreeNode val = this.myKeyToRefMap.get(arr[j]);
            if (!(val instanceof VSwitchNode)) continue;
            v.add((VSwitchNode)val);
        }
        return v;
    }

    public void printAll() {
        for (String key : this.myKeyToRefMap.keySet()) {
            SrTreeNode val = this.myKeyToRefMap.get(key);
            if (!(val instanceof TargetNode)) continue;
            theLogger.info(SrLogCategories.LEGACY, "KEY: ", key);
            theLogger.info(SrLogCategories.LEGACY, "VALUE: ", val.getClass(), val);
        }
    }

    public void printAll(Object stub) {
    }

    public void printAllType(RemoteObject stub) {
        for (String key : this.myKeyToRefMap.keySet()) {
            SrTreeNode val = this.myKeyToRefMap.get(key);
            if (!(val instanceof IdentityNode)) continue;
            theLogger.info(SrLogCategories.LEGACY, "KEY: ", key);
            theLogger.info(SrLogCategories.LEGACY, "VALUE: ", val.getClass(), val);
        }
        theLogger.error(SrLogCategories.LEGACY, "STUB: ", StubToReference.getID(stub));
    }

    public String toString() {
        return "StubToReference[" + this.myKeyToRefMap + "]";
    }
}

