/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.ObjectStatus;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.license.LicenseManager;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.swing.tree.SrRootTreeNode;
import com.sanrad.util.MultiHashMap;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class SrTreeNode<T extends RemoteObject, I>
extends SrRootTreeNode
implements Comparable {
    private static SrLogger theLogger = SrLogger.getLogger();
    protected Icon alarmIcon;
    protected ImageIcon nodeIcon;
    protected ObjectStatus status;
    protected String newAlias = "";
    private HashMap<Class<? extends Window>, Window> m_dialogsMap = new HashMap();
    private boolean enabled = true;
    private ArrayList m_maxLicensedChildrenList = new ArrayList();
    private int myHashCode;
    protected MultiHashMap<SrTreeNode, String> myGraphicalIndications = new MultiHashMap();

    protected SrTreeNode() {
    }

    protected SrTreeNode(T stub, I id) {
        this(stub, id, -1);
    }

    protected SrTreeNode(T stub, I id, int hashCode) {
        if (id == null) {
            throw new IllegalArgumentException("Identifier may not be null");
        }
        if (hashCode > -1) {
            this.myHashCode = hashCode;
        }
        if (stub != null) {
            Manager.putRefToMapping(this, id, stub);
        }
    }

    public T getStub() {
        return (T)Manager.getStubByRef(this);
    }

    public Icon getAlarmIcon() {
        return this.alarmIcon;
    }

    protected void setAlarmIcon(Icon icon) {
        this.alarmIcon = icon;
    }

    protected void setNodeIcon(ClientImageObject icon) {
        if (icon != null) {
            this.nodeIcon = icon.getImageIcon();
        }
    }

    public ImageIcon getNodeIcon() {
        return this.nodeIcon;
    }

    public void setStatus(ObjectStatus status) {
        this.status = status;
        if (status.equals(ObjectStatus.OK)) {
            this.setAlarmIcon(ClientImageObject.OK_ALARM.getImageIcon());
        } else if (status.equals(ObjectStatus.INFO)) {
            this.setAlarmIcon(ClientImageObject.INFO_ALARM.getImageIcon());
        } else if (status.equals(ObjectStatus.WARNING)) {
            this.setAlarmIcon(ClientImageObject.WARNING_ALARM.getImageIcon());
        } else if (status.equals(ObjectStatus.ERROR)) {
            this.setAlarmIcon(ClientImageObject.ERROR_ALARM.getImageIcon());
        } else if (status.equals(ObjectStatus.FATAL)) {
            this.setAlarmIcon(ClientImageObject.FATAL_ALARM.getImageIcon());
        }
    }

    public ObjectStatus getStatus() {
        return this.status;
    }

    public abstract String type();

    public int hashCode() {
        return this.myHashCode > -1 ? this.myHashCode : super.hashCode();
    }

    public void setNewAlias(String newAlias) {
        this.newAlias = newAlias;
    }

    public String getNewAlias() {
        return this.newAlias;
    }

    public ClientParameterCode getMyAliasParamCode() {
        return null;
    }

    public int compareTo(Object obj) {
        if (this.toString() != null && obj != null && obj.toString() != null) {
            return this.toString().compareToIgnoreCase(obj.toString());
        }
        return -1;
    }

    public TreePath getTreePath() {
        return new TreePath(this.getPath());
    }

    public TreeNode getAncestorOfType(Class c) {
        TreeNode[] path = this.getPath();
        int i = path.length;
        while (i-- > 0) {
            if (!c.isAssignableFrom(path[i].getClass())) continue;
            return path[i];
        }
        return null;
    }

    public TreeNode findNodeInSubTree(Class c) {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            TreeNode grandSon;
            TreeNode child = e.nextElement();
            if (c.isAssignableFrom(child.getClass())) {
                return child;
            }
            if (!(child instanceof SrTreeNode) || (grandSon = ((SrTreeNode)child).findNodeInSubTree(c)) == null) continue;
            return grandSon;
        }
        return null;
    }

    public <N extends TreeNode> List<N> findAllInSubTree(Class<? extends N> c) {
        return this.getAllFromSubTree(this, c);
    }

    private <N extends TreeNode> List<N> getAllFromSubTree(TreeNode parent, Class<? extends N> c) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        Enumeration<? extends TreeNode> e = parent.children();
        while (e.hasMoreElements()) {
            TreeNode child = e.nextElement();
            if (c.isAssignableFrom(child.getClass())) {
                list.add(child);
            }
            if (!(child instanceof SrTreeNode)) continue;
            list.addAll(this.getAllFromSubTree(child, c));
        }
        return list;
    }

    public <N extends TreeNode> List<N> getChildrenOfType(Class<? extends N> c) {
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            TreeNode child = e.nextElement();
            if (!c.isAssignableFrom(child.getClass())) continue;
            children.add(child);
        }
        return children;
    }

    @Override
    public final void insert(MutableTreeNode node, int index) {
        if (node != null) {
            if (node instanceof SrTreeNode) {
                this.insert((SrTreeNode)node, index);
            } else {
                super.insert(node, index);
                this.addToMaxLicenseList(index, node);
            }
        } else {
            theLogger.warn(SrLogCategories.LEGACY, "Trying to insert a null node to index ", index);
        }
    }

    public SrLicenseTreePath getLicensePath() {
        return SrLicenseTreePath.GENERAL_PATH;
    }

    public String getToolTipText() {
        return null;
    }

    public void addDialog(Window dialog) {
        Object existsDialog = this.getDialog(dialog.getClass());
        if (existsDialog != null) {
            if (!existsDialog.equals(dialog)) {
                ((Window)existsDialog).dispose();
                this.removeDialog(dialog.getClass());
            } else {
                return;
            }
        }
        this.m_dialogsMap.put(dialog.getClass(), dialog);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SrTreeNode.this.removeDialog(e.getSource().getClass());
            }

            @Override
            public void windowClosing(WindowEvent e) {
                SrTreeNode.this.removeDialog(e.getSource().getClass());
            }
        });
    }

    public <A extends Window> A getDialog(Class key) {
        return (A)this.m_dialogsMap.get(key);
    }

    public Window removeDialog(Class key) {
        return this.m_dialogsMap.remove(key);
    }

    public Window[] removeAllDialogs() {
        ArrayList<Window> windows = new ArrayList<Window>(this.m_dialogsMap.values());
        this.m_dialogsMap.clear();
        return windows.toArray(new Window[windows.size()]);
    }

    public int getVswitchesCount() {
        ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(this);
        if (cluster != null) {
            int potential = AlarmsManager.getInstance().isAlarmExist(this, AlarmType.OBJ_NOT_REDUNDANT.toString()) ? 1 : 2;
            return Math.min(potential, cluster.getVSwitches().length);
        }
        return -1;
    }

    public boolean isAssociatedToDisconnectedVs() {
        VSwitchNode[] clusterVs;
        ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(this);
        if (cluster != null && (clusterVs = cluster.getVSwitches()) != null) {
            for (VSwitchNode curVs : clusterVs) {
                if (curVs.isConnected()) continue;
                return true;
            }
        }
        return false;
    }

    public final void insert(SrTreeNode node, int index) {
        if (node != null) {
            ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(this);
            if (LicenseManager.getInstance().isVisible(node.getLicensePath(), cluster != null ? cluster.getCapability() : null)) {
                super.insert(node, index);
            }
            node.setEnabled(LicenseManager.getInstance().isEnabled(node.getLicensePath(), cluster != null ? cluster.getCapability() : null));
            this.addToMaxLicenseList(index, node);
        } else {
            theLogger.warn(SrLogCategories.LEGACY, "Trying to insert a null node to index ", index);
        }
    }

    @Override
    public void add(MutableTreeNode newChild) {
        this.addToMaxLicenseList(this.m_maxLicensedChildrenList.size(), newChild);
        super.add(newChild);
    }

    @Override
    public void remove(int childIndex) {
        MutableTreeNode child = (MutableTreeNode)this.getChildAt(childIndex);
        this.m_maxLicensedChildrenList.remove(child);
        super.remove(childIndex);
    }

    public void notifyLicenseChanged(SrBITSConstant newVswitchCapability) {
        this.checkLicenseAvailability(this, newVswitchCapability);
        for (int i = 0; i < this.m_maxLicensedChildrenList.size(); ++i) {
            MutableTreeNode candidate;
            List childrenList = this.getChildren();
            if (childrenList.indexOf(candidate = (MutableTreeNode)this.m_maxLicensedChildrenList.get(i)) >= 0) continue;
            int index = 0;
            int j = i;
            while (j-- > 0) {
                MutableTreeNode nodeAbove = (MutableTreeNode)this.m_maxLicensedChildrenList.get(j);
                int indexOfAboveNode = childrenList.indexOf(nodeAbove);
                if (indexOfAboveNode < 0) continue;
                index = indexOfAboveNode + 1;
                break;
            }
            this.insert(candidate, index);
        }
    }

    private void checkLicenseAvailability(TreeNode parent, SrBITSConstant vswitchCapability) {
        if (parent instanceof SrTreeNode) {
            SrTreeNode srNode = (SrTreeNode)parent;
            srNode.setEnabled(LicenseManager.getInstance().isEnabled(srNode.getLicensePath(), vswitchCapability));
        }
        Enumeration<? extends TreeNode> e = parent.children();
        while (e.hasMoreElements()) {
            this.checkLicenseAvailability(e.nextElement(), vswitchCapability);
        }
    }

    public List getChildren() {
        ArrayList<TreeNode> childrenList = new ArrayList<TreeNode>();
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            childrenList.add(e.nextElement());
        }
        return childrenList;
    }

    private void addToMaxLicenseList(int index, Object node) {
        if (!this.m_maxLicensedChildrenList.contains(node)) {
            this.m_maxLicensedChildrenList.add(index, node);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getProblemOnDeletion() {
        if (this.isAssociatedToDisconnectedVs()) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_CANNOT_BE_DELETED_DISCONNECTED_SWITCH);
        }
        return null;
    }

    public I getIdentifier() {
        return (I)Manager.getIdByRef(this);
    }

    public String getGraphicalIndicationString() {
        StringBuffer retVal = new StringBuffer();
        for (Set values : this.myGraphicalIndications.values()) {
            for (String value : values) {
                if (retVal.length() == 0) {
                    retVal.append(" ");
                } else {
                    retVal.append(", ");
                }
                retVal.append("(" + value + "...)");
            }
        }
        return retVal.toString();
    }

    public void addGraphicalIndication(SrTreeNode key, String value) {
        this.myGraphicalIndications.put((Object)key, (Object)value);
    }

    public boolean removeGraphicalIndication(SrTreeNode key, String value) {
        Set allMyIndications = (Set)this.myGraphicalIndications.get(key);
        boolean retVal = false;
        if (allMyIndications != null) {
            retVal = allMyIndications.remove(value);
            if (allMyIndications.isEmpty()) {
                this.myGraphicalIndications.remove(key);
            }
        }
        return retVal;
    }
}

