/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.IdentitiesNode;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.ConsistencyGroupRootNode;
import com.sanrad.nms.client.data.dr.DRJournalRootNode;
import com.sanrad.nms.client.data.dr.DRRootTreeNode;
import com.sanrad.nms.client.data.raid.RaidManager;
import com.sanrad.nms.client.data.raid.RaidNode;
import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.data.site.SiteManager;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.storage.StorageNode;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.volume.VolumeRootNode;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.cluster.ClusterEvent;
import com.sanrad.nms.client.event.cluster.ClusterListener;
import com.sanrad.nms.client.event.raid.RaidEvent;
import com.sanrad.nms.client.event.raid.RaidManagerListener;
import com.sanrad.nms.client.event.site.SiteEvent;
import com.sanrad.nms.client.event.site.SiteListener;
import com.sanrad.nms.client.event.target.TargetEvent;
import com.sanrad.nms.client.event.target.TargetListener;
import com.sanrad.nms.client.event.vswitch.VSwitchEvent;
import com.sanrad.nms.client.event.vswitch.VSwitchListener;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.swing.SrTreeModel;
import com.sanrad.swing.StatusPanel;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SrMainTreeModel
extends SrTreeModel
implements TargetListener,
VSwitchListener,
ClusterListener,
SiteListener,
RaidManagerListener {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static SrMainTreeModel theInstance = null;
    private DRRootTreeNode m_drRootNode;

    private SrMainTreeModel(SystemRootNode root) {
        super(root);
        TargetManager.getInstance().addTargetListener(this);
        VSwitchManager.getInstance().addVSwitchListener(this);
        ClusterManager.getInstance().addClusterListener(this);
        SiteManager.getInstance().addSiteListener(this);
        RaidManager.getInstance().addListener(this);
        try {
            this.initTree(root);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
            Manager.onConnectionError();
        }
    }

    public void buildTree() throws RemoteException {
        SystemRootNode root = (SystemRootNode)this.getRoot();
        root.removeAllChildren();
        this.initTree(root);
    }

    public void refreshCluster(ClusterNode clusterNode) {
        clusterNode.removeAllChildren();
        clusterNode.addChildrenNodes(true);
        this.fireTreeStructureChanged(this, this.getPathToRoot(clusterNode), null, null);
    }

    public DRRootTreeNode getDRRootNode() {
        return this.m_drRootNode;
    }

    private void initDRSubTree() {
        this.m_drRootNode = new DRRootTreeNode();
        ConsistencyGroupRootNode cgNode = new ConsistencyGroupRootNode();
        DRJournalRootNode journalsNode = new DRJournalRootNode();
        this.m_drRootNode.add(cgNode);
        this.m_drRootNode.add(journalsNode);
        SystemRootNode root = (SystemRootNode)this.getRoot();
        root.add(this.m_drRootNode);
        this.fireTreeStructureChanged(this, this.getPathToRoot(root), null, null);
    }

    private void initSiteNodesAndClusters() {
        SiteNode[] sysSites = SiteManager.getInstance().discoverSystemSites();
        SiteNode[] sites = new SiteNode[sysSites.length + 1];
        sites[0] = (SiteNode)this.root;
        System.arraycopy(sysSites, 0, sites, 1, sysSites.length);
        int i = sites.length;
        while (i-- > 0) {
            if (sites[i] != this.root) {
                this.insertSiteInPosition(sites[i]);
            }
            try {
                ArrayList clusterStubs = ((Site)sites[i].getStub()).getClusters();
                int j = clusterStubs.size();
                while (j-- > 0) {
                    ClusterNode clusterNode = ((SystemRootNode)this.root).getClusterNodeOfStub((RemoteObject)clusterStubs.get(j));
                    this.insertClusterInPosition(sites[i], clusterNode, true, false);
                }
            }
            catch (RemoteException e) {
                theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
            }
        }
    }

    private void initTree(SystemRootNode root) throws RemoteException {
        this.initDRSubTree();
        this.initSiteNodesAndClusters();
        Vector clusterNodes = ClusterManager.getInstance().getClusterNodes();
        theLogger.trace(SrLogCategories.LEGACY, "total: ", clusterNodes.size(), " clusters read.");
        for (ClusterNode clusterNode : clusterNodes) {
            clusterNode.readRadiusServers(false);
            clusterNode.readISNSServers(false);
        }
    }

    public IdentitiesNode getIdentitiesNode() {
        return this.getCurrentClusterNode().getIdentitiesNode();
    }

    private ClusterNode getCurrentClusterNode() {
        return SystemRootNode.getInstance().getCurrentClusterNode();
    }

    public StorageNode getStorageNode(ClusterNode clusterNode) {
        return clusterNode.getStorageNode();
    }

    public boolean hasVSwitch() {
        ClusterNode clusterNode = this.getCurrentClusterNode();
        if (clusterNode != null) {
            Enumeration<TreeNode> children = clusterNode.children();
            while (children.hasMoreElements()) {
                TreeNode obj = children.nextElement();
                if (!(obj instanceof VSwitchNode)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isOneVSwitchAvailable() {
        return SrMainTreeModel.isOneVSwitchAvailable(this.getCurrentClusterNode());
    }

    public static boolean isOneVSwitchAvailable(ClusterNode clusterNode) {
        Enumeration<TreeNode> children = clusterNode.children();
        while (children.hasMoreElements()) {
            TreeNode obj = children.nextElement();
            if (!(obj instanceof VSwitchNode) || !((VSwitchNode)obj).isConnected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resetVSwitchStarted(VSwitchEvent event) {
    }

    @Override
    public void discoverStarted(ClusterEvent e) {
    }

    @Override
    public void refreshCluster(ClusterEvent event) {
    }

    @Override
    public void clusterStatusChanged(ClusterEvent e) {
        ClusterNode clusterNode = (ClusterNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        this.nodeChanged(clusterNode);
    }

    @Override
    public void sitePropertiesChanged(SiteEvent e) {
        this.nodeChanged(e.getSiteNode());
    }

    @Override
    public void siteStatusChanged(SiteEvent event) {
    }

    @Override
    public void discoverCompleted(ClusterEvent event) {
    }

    public static synchronized SrMainTreeModel getInstance() {
        if (theInstance == null) {
            theInstance = new SrMainTreeModel(SystemRootNode.getInstance());
        }
        return theInstance;
    }

    public void clear(ClusterNode clusterNode) {
        VolumeRootNode volumesNode = clusterNode.getExposedVolumesNode();
        int[] childIndices = new int[volumesNode.getChildCount()];
        Object[] removedChildren = new Object[volumesNode.getChildCount()];
        for (int i = 0; i < volumesNode.getChildCount(); ++i) {
            childIndices[i] = i;
            removedChildren[i] = volumesNode.getChildAt(i);
        }
        VolumeRootNode node = volumesNode;
        volumesNode.removeAllChildren();
        Enumeration<TreeNode> vSwitches = clusterNode.children();
        this.nodesWereRemoved(node, childIndices, removedChildren);
    }

    private List<TargetNode> getAllTargets() {
        return SystemRootNode.getInstance().findAllInSubTree(TargetNode.class);
    }

    @Override
    public void newTargetCreate(TargetEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "MainTreeModel: Trying to insert new target to Tree.");
        TargetNode newTarget = (TargetNode)e.getValue();
        VolumeRootNode volumesRootNode = SystemRootNode.getInstance().getClusterNodeOfSource(newTarget).getExposedVolumesNode();
        this.insertTargetInPosition(volumesRootNode, (TargetNode)e.getValue());
    }

    private void insertTargetInPosition(VolumeRootNode parent, TargetNode newNode) {
        Enumeration<TreeNode> children = parent.children();
        if (parent.getChildCount() == 0) {
            this.insertNodeInto(newNode, parent, parent.getChildCount());
            return;
        }
        if (parent.getChildCount() > 0) {
            TargetNode node = (TargetNode)children.nextElement();
            if (node.compareTo(newNode) > 0) {
                this.insertNodeInto(newNode, parent, 0);
                return;
            }
            children = parent.children();
        }
        int i = 0;
        TargetNode node2 = null;
        TargetNode node1 = null;
        while (children.hasMoreElements()) {
            node1 = node2 != null ? node2 : (TargetNode)children.nextElement();
            ++i;
            if (children.hasMoreElements()) {
                node2 = (TargetNode)children.nextElement();
            }
            if (node1.compareTo(newNode) < 0 && node2 != null && node2.compareTo(newNode) > 0) {
                this.insertNodeInto(newNode, parent, i);
                break;
            }
            if (node1.compareTo(newNode) < 0 && node2 == null) {
                this.insertNodeInto(newNode, parent, parent.getChildCount());
                break;
            }
            if (node1.compareTo(newNode) >= 0 || node2 == null || node2.compareTo(newNode) >= 0 || children.hasMoreElements()) continue;
            this.insertNodeInto(newNode, parent, parent.getChildCount());
        }
    }

    @Override
    public void targetStatusCanged(TargetEvent e) {
        RemoteObject stub = e.getStub();
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(stub);
        if (node != null) {
            theLogger.trace(SrLogCategories.LEGACY, "MainTreeModel: targetStatus changed.", ((TargetNode)node).getAlias());
            this.nodeChanged((TargetNode)node);
        }
    }

    @Override
    public void targetUserNameChanged(TargetEvent e) {
    }

    @Override
    public void targetRemove(TargetEvent e) {
        RemoteObject stub = e.getStub();
        for (TargetNode target : this.getAllTargets()) {
            if (!((Target)target.getStub()).equals(stub)) continue;
            theLogger.trace(SrLogCategories.LEGACY, "MainTreeModel: trying to remove target from tree: ", target.getAlias());
            this.removeNodeFromParent(target);
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "Could not find target to remove");
    }

    @Override
    public void targetVSwitchNameChanged(TargetEvent e) {
    }

    public void notifyNodeChanged(SrTreeNode node) {
        Object[] path = this.getPathToRoot(node);
        if (path != null) {
            this.fireTreeNodesChanged(this, path, null, null);
        }
    }

    @Override
    public void targetAliasChanged(TargetEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "MainTreeModel: trying to change the target alias in the main tree.");
        SrTreeNode targetNode = SystemRootNode.getInstance().getRefByStub(e.getStub());
        if (targetNode != null) {
            ((TargetNode)targetNode).setAlias(e.getAlias());
            Object[] path = this.getPathToRoot((TargetNode)targetNode);
            if (path != null) {
                this.fireTreeNodesChanged(this, path, null, null);
            }
        }
    }

    @Override
    public void vSwitchCreated(VSwitchEvent e) {
        RemoteObject stub = e.getStub();
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(stub);
        if (node != null) {
            VSwitchNode vswitchNode = (VSwitchNode)node;
            theLogger.trace(SrLogCategories.LEGACY, "MainTreeModel: vswitch created, trying to insert it to tree: ", vswitchNode.getName());
            ClusterNode clusterNode = e.getClusterNode();
            theLogger.logAndAssert(SrLogCategories.ERROR, this.getChildCount(clusterNode) > 0, new Object[]{"child count shouldn't be 0 (or less) because targets/storages/host groups nodes should exist already"});
            this.insertNodeInto(vswitchNode, clusterNode, this.getChildCount(clusterNode));
            this.fireTreeStructureChanged(this, this.getPathToRoot(clusterNode), null, null);
        }
    }

    @Override
    public void clusterCreated(ClusterEvent e) {
        RemoteObject stub = e.getStub();
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(stub);
        if (node != null) {
            ClusterNode clusterNode = (ClusterNode)node;
            theLogger.trace(SrLogCategories.LEGACY, "MainTreeModel: cluster created, trying to insert it to tree: ", clusterNode.getAlias());
            try {
                Site site = ((Cluster)stub).getParentSite();
                SiteNode siteNode = (SiteNode)((SystemRootNode)this.root).getRefByStub(site);
                this.insertClusterInPosition(siteNode, clusterNode, true, true);
            }
            catch (RemoteException e1) {
                theLogger.error(SrLogCategories.LEGACY, e1, new Object[0]);
            }
        }
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
    }

    @Override
    public void siteCreated(SiteEvent event) {
        SiteNode siteNode = event.getSiteNode();
        this.insertSiteInPosition(siteNode);
    }

    @Override
    public void siteRemoved(SiteEvent event) {
        theLogger.trace(SrLogCategories.LEGACY, "MainTreeModel : site removed,  trying to remove ", event.getSiteNode());
        this.removeNodeFromParent(event.getSiteNode());
        this.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode)this.getRoot()), null, null);
    }

    public void insertDefaultSiteClusterInPosition(ClusterNode clusterNode) {
        SystemRootNode root = (SystemRootNode)this.getRoot();
        int numOfChilds = root.getChildCount();
        SrTreeNode currentNode = null;
        if (numOfChilds == 1) {
            this.insertNodeInto(clusterNode, root, numOfChilds);
            return;
        }
        for (int i = 1; i < numOfChilds; ++i) {
            currentNode = (SrTreeNode)root.getChildAt(i);
            if (currentNode instanceof SiteNode) {
                this.insertNodeInto(clusterNode, root, i);
                return;
            }
            if (clusterNode.compareTo(currentNode) > 0) continue;
            this.insertNodeInto(clusterNode, root, i);
            return;
        }
        this.insertNodeInto(clusterNode, root, numOfChilds);
    }

    private void insertClusterInPosition(SiteNode parentSite, ClusterNode clusterNode, boolean isNewCluster, boolean isClusterCreateEvent) {
        ClusterNode currentNode;
        TreeNode node;
        int numOfChilds = parentSite.getChildCount();
        int i = 0;
        for (i = 0; i < numOfChilds && !((node = parentSite.getChildAt(i)) instanceof ClusterNode ? clusterNode.compareTo(currentNode = (ClusterNode)node) <= 0 : node instanceof SiteNode); ++i) {
        }
        if (isNewCluster) {
            clusterNode.addChildrenNodes(!isClusterCreateEvent);
        }
        this.insertNodeInto(clusterNode, parentSite, i);
    }

    private void insertSiteInPosition(SiteNode siteNode) {
        TreeNode node;
        SystemRootNode root = (SystemRootNode)this.getRoot();
        int childs = root.getChildCount();
        int i = 0;
        for (i = 0; !(i >= childs || (node = root.getChildAt(i)) instanceof SiteNode && siteNode.compareTo(node) < 0); ++i) {
        }
        this.insertNodeInto(siteNode, root, i);
    }

    @Override
    public void vSwitchRemoved(VSwitchEvent e) {
        Object[] path;
        RemoteObject stub = e.getStub();
        VSwitchNode node = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(stub);
        theLogger.trace(SrLogCategories.LEGACY, "MainTreeModel : vswitch removed,  trying to remove it from tree: ", node.getName());
        ClusterNode cluster = (ClusterNode)node.getParent();
        if (cluster != null) {
            this.removeNodeFromParent(node);
            this.fireTreeNodesChanged(this, this.getPathToRoot(cluster), null, null);
        }
        if ((path = this.getPathToRoot(node)) != null) {
            this.fireTreeNodesRemoved(this, path, null, null);
        }
    }

    @Override
    public void clusterRemoved(ClusterEvent e) {
        RemoteObject stub = e.getStub();
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(stub);
        this.removeNodeFromParent((ClusterNode)node);
    }

    @Override
    public void clusterPropertiesChanged(ClusterEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "MainTreeModel: Cluster properties changed in tree.");
        ClusterNode cluster = e.getClusterNode();
        SiteNode prevSite = (SiteNode)cluster.getParent();
        SiteNode nextSite = null;
        try {
            Site site = ((Cluster)e.getStub()).getParentSite();
            nextSite = (SiteNode)((SystemRootNode)this.root).getRefByStub(site);
        }
        catch (RemoteException ex) {
            theLogger.error(SrLogCategories.LEGACY, ex, new Object[0]);
        }
        if (!prevSite.equals(nextSite)) {
            this.removeNodeFromParent(cluster);
            this.insertClusterInPosition(nextSite, cluster, false, false);
        }
        cluster.notifyLicenseChanged(cluster.getCapability());
        this.nodeChanged(cluster);
    }

    @Override
    public void vSwitchRediscovered(VSwitchEvent e) {
    }

    @Override
    public void vSwitchPropertiesChanged(VSwitchEvent e) {
    }

    public Vector<VSwitchNode> getOtherVSwitches(VSwitchNode vswitchNode) {
        ClusterNode clusterNode = (ClusterNode)vswitchNode.getParent();
        Enumeration<TreeNode> children = clusterNode.children();
        Vector<VSwitchNode> result = new Vector<VSwitchNode>();
        while (children.hasMoreElements()) {
            TreeNode child = children.nextElement();
            if (!(child instanceof VSwitchNode) || ((VSwitch)((VSwitchNode)child).getStub()).equals(vswitchNode.getStub())) continue;
            result.addElement((VSwitchNode)child);
        }
        return result;
    }

    public int getVswitchCountCurrentCluster() {
        return this.getNumberOfVswitches(this.getCurrentClusterNode());
    }

    public int getNumberOfVswitches(ClusterNode clusterNode) {
        if (clusterNode != null) {
            Enumeration<TreeNode> children = clusterNode.children();
            Vector<TreeNode> result = new Vector<TreeNode>();
            while (children.hasMoreElements()) {
                TreeNode child = children.nextElement();
                if (!(child instanceof VSwitchNode)) continue;
                result.addElement(child);
            }
            return result.size();
        }
        theLogger.info(SrLogCategories.INFORMATIVE, "The cluster node is null");
        return 0;
    }

    @Override
    public void targetNameChanged(TargetEvent e) {
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        String newAlias = newValue.toString();
        theLogger.trace(SrLogCategories.LEGACY, "MainTreeModel - valueForPathChanged() ! new alias- ", newAlias);
        theLogger.trace(SrLogCategories.LEGACY, "======================================================");
        SrTreeNode node = (SrTreeNode)path.getLastPathComponent();
        node.setNewAlias(newAlias);
        if (node instanceof ClusterNode) {
            if (newAlias.trim().equals("") || newAlias.equals(((ClusterNode)node).getAlias())) {
                this.nodeChanged(node);
                return;
            }
            SrClientAction.blockActions(Collections.singleton(ClusterManager.getInstance().setAlias((ClusterNode)node, newAlias)), StatusPanel.getInstance());
        } else if (node instanceof SiteNode) {
            if (newAlias.trim().equals("") || newAlias.equals(((SiteNode)node).getAlias())) {
                this.nodeChanged(node);
                return;
            }
            SrClientAction.blockActions(Collections.singleton(SiteManager.getInstance().setAlias((SiteNode)node, newAlias)), StatusPanel.getInstance());
        }
        this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
    }

    @Override
    public void RaidChanged(RaidEvent raidEvent) {
        RaidNode raidNode = raidEvent.getNode();
        ClusterNode cluster = raidEvent.getCluster();
        switch (raidEvent.getCause()) {
            case RAID_NODE_ADDED: {
                StorageNode storageNode;
                if (cluster == null || raidNode == null || (storageNode = cluster.getStorageNode()) == null) break;
                this.insertOrderedByName(storageNode, raidNode);
                break;
            }
            case RAID_NODE_REMOVED: {
                if (raidNode == null) break;
                this.removeNodeFromParent(raidNode);
                break;
            }
            case DISK_STATUS_CHANGED: 
            case RAID_STATUS_CHANGED: 
            case RAID_NAME_CHANGED: {
                RaidSystem raidSys = raidEvent.getRaid();
                if (raidSys == null) break;
                for (ClusterNode curCluster : raidSys.getClusters()) {
                    RaidNode changedRaidNode = raidSys.getRaidNode(curCluster);
                    if (changedRaidNode == null) continue;
                    this.notifyNodeChanged(changedRaidNode);
                }
                break;
            }
            case CLUSTER_DISCOVERY: {
                this.removeNodeFromParent(raidNode);
            }
        }
    }

    @Override
    public void RaidCreated(RaidEvent raidEvent) {
    }

    @Override
    public void RaidRemoved(RaidEvent raidEvent) {
    }

    @Override
    public void RaidAttached(RaidEvent raidEvent) {
    }

    @Override
    public void RaidDetached(RaidEvent raidEvent) {
    }
}

