/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data;

import java.util.ArrayList;
import java.util.List;

public abstract class SrConfigurationDiscoverer<T> {
    public static SrConfigurationDiscoverer<Void> DUMMY_DISCOVERER = new SrConfigurationDiscoverer<Void>(){

        @Override
        protected List<Void> findConfiguredElements() {
            return DUMMY_RESULT;
        }
    };
    private static List<Void> DUMMY_RESULT = new ArrayList<Void>();
    public static final int RETRIES_NOT_LIMITED = -1;
    private int myNumberOfRetries;
    private ArrayList<T> myLastSearchResult = new ArrayList();

    public SrConfigurationDiscoverer() {
        this(-1);
    }

    public SrConfigurationDiscoverer(int aNumberOfRetries) {
        if (aNumberOfRetries < -1 || aNumberOfRetries == 0) {
            throw new IllegalArgumentException("The number of retries must be non-zero and positive, or RETRIES_NOT_LIMITED");
        }
        this.myNumberOfRetries = aNumberOfRetries;
    }

    public final List<T> discoverConfiguration() {
        if (!this.hasMoreRetries()) {
            throw new IllegalArgumentException("There are no more retries");
        }
        if (this.myNumberOfRetries != -1 && this.myNumberOfRetries > 0) {
            --this.myNumberOfRetries;
        }
        this.myLastSearchResult.clear();
        List<T> result = this.findConfiguredElements();
        if (result != null) {
            this.myLastSearchResult.addAll(result);
        }
        return this.myLastSearchResult;
    }

    public final boolean hasMoreRetries() {
        return this.myNumberOfRetries > 0 || this.myNumberOfRetries == -1;
    }

    public final boolean isFound() {
        return this.myLastSearchResult.size() > 0;
    }

    public final List<T> getLastSearchResult() {
        return new ArrayList<T>(this.myLastSearchResult);
    }

    public String getConfigurationDescription() {
        return "No description";
    }

    protected abstract List<T> findConfiguredElements();

    static {
        DUMMY_RESULT.add(null);
    }
}

