/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.vswitch.PortalTableRow;
import com.sanrad.nms.client.data.vswitch.SrTargetPortalTableRow;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.PortalEvent;
import com.sanrad.nms.client.event.PortalListener;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.types.constants.IscsiPortalRolesConstant;
import com.sanrad.util.SrEventListenerManager;
import java.rmi.RemoteException;
import java.util.HashMap;

public class PortalManager
extends ElementManager {
    private static PortalManager instance = null;
    SrEventListenerManager.Informer portalTableRowCreatedInformer = new SrEventListenerManager.Informer<PortalListener, PortalEvent>(){

        @Override
        public void inform(PortalListener listener, PortalEvent event) {
            listener.portalTableRowCreated(event);
        }
    };
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer portalTableRowRemovedInformer = new SrEventListenerManager.Informer<PortalListener, PortalEvent>(){

        @Override
        public void inform(PortalListener listener, PortalEvent event) {
            listener.portalTableRowRemoved(event);
        }
    };

    private PortalManager() {
    }

    public static synchronized PortalManager getInstance() {
        if (instance == null) {
            instance = new PortalManager();
        }
        return instance;
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        try {
            theLogger.trace(SrLogCategories.LEGACY, "Portal Table row created .");
            com.sanrad.nms.server.logic.vswitch.PortalTableRow rowStub = (com.sanrad.nms.server.logic.vswitch.PortalTableRow)element;
            HashMap params = this.getParameterList(e);
            Object ipAddressObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.PORTAL_IP_ADDRESS", true);
            Object portObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.PORTAL_PORT", true);
            Object tagObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.PORTAL_TAG", true);
            Object roleObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.PORTAL_ROLE", true);
            VSwitch parent = (VSwitch)this.getObjectForParam(params, "Missing code - ClientParameterCode.PORTAL_PARENT_VSWITCH", true);
            if (ipAddressObj == null) {
                ipAddressObj = rowStub.getIPAddress();
            }
            if (portObj == null) {
                portObj = rowStub.getPort();
            }
            if (tagObj == null) {
                tagObj = rowStub.getTag();
            }
            if (roleObj == null) {
                roleObj = rowStub.getRole();
            }
            if (parent == null) {
                parent = rowStub.getParentVSwitch();
            }
            String ipAddress = (String)ipAddressObj;
            Integer port = (Integer)portObj;
            Integer tag = (Integer)tagObj;
            IscsiPortalRolesConstant role = (IscsiPortalRolesConstant)roleObj;
            PortalTableRow row = role.equals(IscsiPortalRolesConstant.TARGET) || role.equals(IscsiPortalRolesConstant.TARGET_AND_INITIATOR) ? new SrTargetPortalTableRow(rowStub, parent, ipAddress, port, tag, role) : new PortalTableRow(rowStub, parent, ipAddress, tag, role);
            SystemRootNode.getInstance().putRefAndStub(rowStub, row);
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(parent);
            if (node != null) {
                VSwitchNode vswitchNode = (VSwitchNode)node;
                vswitchNode.getPortalTable().addElement(row);
            }
            this.firePortalTableRowCreated(row);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            PortalManager.onConnectionError("Failed to create a Portal.");
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "Portal Table row removed .");
        com.sanrad.nms.server.logic.vswitch.PortalTableRow rowStub = (com.sanrad.nms.server.logic.vswitch.PortalTableRow)element;
        SrTreeNode row = SystemRootNode.getInstance().getRefByStub(rowStub);
        if (row != null) {
            VSwitch vswitch = ((PortalTableRow)row).getParentStub();
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(vswitch);
            if (node != null) {
                ((VSwitchNode)node).getPortalTable().remove(row);
                this.firePortalTableRowRemoved((PortalTableRow)row);
            }
            SystemRootNode.getInstance().removeRefAndIdByStub(element);
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
    }

    public void addPortalListener(PortalListener listener) {
        this.m_listeners.add(listener);
    }

    public void removePortalListener(PortalListener listener) {
        this.m_listeners.remove(listener);
    }

    private void firePortalTableRowCreated(PortalTableRow row) {
        PortalEvent event = new PortalEvent((Object)this, (RemoteObject)row.getStub(), row.getParentStub());
        theLogger.trace(SrLogCategories.LEGACY, "fire event: Portal Table row created .");
        this.m_listeners.fireEvent(PortalListener.class, event, this.portalTableRowCreatedInformer);
    }

    private void firePortalTableRowRemoved(PortalTableRow row) {
        PortalEvent event = new PortalEvent((Object)this, (RemoteObject)row.getStub(), row.getParentStub());
        theLogger.trace(SrLogCategories.LEGACY, "fire event: Portal Table row removed .");
        this.m_listeners.fireEvent(PortalListener.class, event, this.portalTableRowRemovedInformer);
    }
}

