/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.event.ElementEvent;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.swing.SrTableModel;
import java.util.HashMap;
import java.util.Map;

public abstract class ModelCollection<M> {
    private Map<ClusterNode, M> models = new HashMap<ClusterNode, M>();

    protected ModelCollection() {
    }

    protected void addModel(ClusterNode cluster, M model) {
        this.models.put(cluster, model);
        if (model instanceof SrTableModel) {
            ((SrTableModel)model).addListeners();
        }
    }

    protected M getModel(ElementEvent event) {
        return this.getModel(event.getStub());
    }

    public M getModel(RemoteObject stub) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfStub(stub);
        return this.getModel(clusterNode);
    }

    public boolean hasModelInCurrentCluster() {
        ClusterNode cluster = SystemRootNode.getInstance().getCurrentClusterNode();
        if (cluster != null) {
            M model = this.models.get(cluster);
            return model != null;
        }
        return false;
    }

    public M getModel(ClusterNode cluster) {
        M model = null;
        ClusterNode curCluster = null;
        curCluster = cluster == null ? SystemRootNode.getInstance().getCurrentClusterNode() : cluster;
        model = this.models.get(curCluster);
        if (model == null) {
            model = this.creatNewModel(curCluster);
            this.addModel(curCluster, model);
        }
        return model;
    }

    public M getCurrentModel() {
        ClusterNode current = SystemRootNode.getInstance().getCurrentClusterNode();
        return this.getModel(current);
    }

    public void clearModelOf(ClusterNode clusterNode) {
        M model = this.getModel(clusterNode);
        this.clearModel(model);
    }

    public void removeModel(ClusterNode cluster) {
        M model = this.models.remove(cluster);
        if (model != null) {
            this.clearModel(model);
            if (model instanceof SrTableModel) {
                ((SrTableModel)model).removeListeners();
            }
        }
    }

    protected abstract M creatNewModel(ClusterNode var1);

    protected abstract void clearModel(M var1);
}

