/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.IPRouteTableManager;
import com.sanrad.nms.client.data.IPTableManager;
import com.sanrad.nms.client.data.InterfaceManager;
import com.sanrad.nms.client.data.LUManager;
import com.sanrad.nms.client.data.PortalManager;
import com.sanrad.nms.client.data.cluster.ClusterManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.dr.DRConsistencyGroupManager;
import com.sanrad.nms.client.data.dr.DRSyncPairManager;
import com.sanrad.nms.client.data.dr.pit.DRPiTManager;
import com.sanrad.nms.client.data.hardware.HardwareManager;
import com.sanrad.nms.client.data.identity.IdentityManager;
import com.sanrad.nms.client.data.identity.IdentityNameManager;
import com.sanrad.nms.client.data.identity.auth.CredentialsManager;
import com.sanrad.nms.client.data.initiator.SrInitiatorManager;
import com.sanrad.nms.client.data.initiator.SrSCSIInitiatorPortsManager;
import com.sanrad.nms.client.data.iscsi.connection.ISCSIConnectionsManager;
import com.sanrad.nms.client.data.iscsi.instance.ISCSIInstancesManager;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.show.ISCSIRemoteInitiatorsManager;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics.ISCSIRemoteInitiatorsStatisticsManager;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalsManager;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetPortalsManager;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetsManager;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionsManager;
import com.sanrad.nms.client.data.iscsi.session.statistics.ISCSISessionsStatisticsManager;
import com.sanrad.nms.client.data.login.UsersManager;
import com.sanrad.nms.client.data.raid.AttachedRaidManager;
import com.sanrad.nms.client.data.site.SiteManager;
import com.sanrad.nms.client.data.srv.isns.ISNSServerManager;
import com.sanrad.nms.client.data.srv.radius.RadiusServerManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.traps.StorageNotificationManager;
import com.sanrad.nms.client.data.target.SCSITargetsPortsManager;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.target.qos.TargetQosGroupsManager;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotSchedulerManager;
import com.sanrad.nms.client.data.vswitch.NeighborManager;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.statistics.ethernet.EthernetStatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.icmp.ICMPStatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.InterfacesStatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.ip.IPStatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.tcp.TCPConnectionsManager;
import com.sanrad.nms.client.data.vswitch.statistics.tcp.TCPStatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.udp.UDPListenerManager;
import com.sanrad.nms.client.data.vswitch.statistics.udp.UDPStatisticsManager;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.user.User;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;
import java.util.HashMap;

public class ManagersConfigurator {
    private static ManagersConfigurator m_instance;
    private static HashMap m_map;
    private static SrLogger theLogger;

    private ManagersConfigurator() {
        m_map = new HashMap();
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.CLUSTER), ClusterManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.GENERAL_VOLUME), VolumeManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.MIRROR_VOLUME), VolumeManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.SIMPLE_VOLUME), VolumeManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.CONCAT_VOLUME), VolumeManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.CUBE_VOLUME), VolumeManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.TRANSPARENT_VOLUME), VolumeManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.STRIPE_VOLUME), VolumeManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.SNAPSHOT_VOLUME), VolumeManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.JOURNAL_VOLUME), VolumeManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.ISCSI_TARGET), TargetManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.FC_TARGET), TargetManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.LUN), LUManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.SUB_DIRECT_ACCESS_DEVICE), SubDirectAccessDeviceManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.GENERAL_SCSI_DEVICE), DirectAccessDeviceManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.DIRECT_ACCESS_DEVICE), DirectAccessDeviceManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.SEQUENTIAL_ACCESS_DEVICE), DirectAccessDeviceManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.VSWITCH), VSwitchManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.INTERFACE), InterfaceManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.ETHERNET_INTERFACE), InterfaceManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.NETWORK_CONFIGURATION), IPTableManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.IP_ROUTE), IPRouteTableManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.PORTAL), PortalManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.NEIGHBORE), NeighborManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.IDENTITY_NAME), IdentityNameManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.SRP_CREDENTIALS), CredentialsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.CHAP_CREDENTIALS), CredentialsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.IDENTITY), IdentityManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.VOLUME_OPERATION), CopyOperManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.COPY_OPERATION), CopyOperManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.OFFLINE_COPY), CopyOperManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.MIRROR_SYNC), CopyOperManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.RADIUS_SERVER), RadiusServerManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.ISNS_SERVER), ISNSServerManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.FC_INTERFACE), InterfaceManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.PSCSI_INTERFACE), InterfaceManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.HARDWARE), HardwareManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.STATISTIC_UDP), UDPStatisticsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.STATISTIC_TCP), TCPStatisticsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.STATISTIC_IP), IPStatisticsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.STATISTIC_ICMP), ICMPStatisticsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.STATISTIC_ETHERNET), EthernetStatisticsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.STATISTIC_INTERFACE), InterfacesStatisticsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.STATISTIC_TCP_CONNECTION), TCPConnectionsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.STATISTIC_UDP_LISTENER), UDPListenerManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.ISCSI_INSTANCE), ISCSIInstancesManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.ISCSI_SESSION), ISCSISessionsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.ISCSI_CONNECTION), ISCSIConnectionsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.ISCSI_REMOTE_INITIATOR), ISCSIRemoteInitiatorsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.ISCSI_REMOTE_INITIATOR_STATISTICS), ISCSIRemoteInitiatorsStatisticsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.ISCSI_SESSION_STATISTICS), ISCSISessionsStatisticsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.SCSI_TARGET_PORT), SCSITargetsPortsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.ISCSI_INITIATOR), SrInitiatorManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.SCSI_INITIATOR_PORT), SrSCSIInitiatorPortsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.ISCSI_REMOTE_TARGET), SrISCSIRemoteTargetsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.ISCSI_REMOTE_TARGET_PORTAL), SrISCSIRemoteTargetPortalsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.SITE), SiteManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.DR_ASYNC_PAIR_PIT), DRPiTManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.DR_CONSISTENCY_GROUP_PIT), DRPiTManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.ASYNC_PAIR), DRASyncPairManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.SYNC_PAIR), DRSyncPairManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.CONSISTENCY_GROUP), DRConsistencyGroupManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.EXTENDED_PAIR), DRConsistencyGroupManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL), SrISCSIRemoteDiscoveryPortalsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.STORAGE_NOTIFICATION), StorageNotificationManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.ISCSI_TARGET_QOS_GROUP), TargetQosGroupsManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.ATTACHED_RAID), AttachedRaidManager.getInstance());
        this.addToManagerMapping(ManagersConfigurator.getIntegerForId(ClassID.SNAPSHOT_SCHEDULER), SnapshotSchedulerManager.getInstance());
    }

    private void addToManagerMapping(Integer intForClassID, Object manager) {
        if (m_map.containsKey(intForClassID)) {
            throw new IllegalArgumentException("Conflict in initializing the ManagerConfigurator - trying to insert twice the sam key");
        }
        m_map.put(intForClassID, manager);
    }

    public static synchronized ManagersConfigurator getInstance() {
        if (m_instance == null) {
            m_instance = new ManagersConfigurator();
        }
        return m_instance;
    }

    public ElementManager getManager(CommunicationEvent e) {
        ClassID classId = null;
        try {
            classId = ((GeneralLogicObject)e.getElement()).getClassId();
        }
        catch (ClassCastException exClass) {
            if (e.getElement() instanceof User) {
                return UsersManager.getInstance();
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, "ManagersConfigurator: Remote exception ,can't retrieve classId");
            return null;
        }
        if (classId == null) {
            theLogger.error(SrLogCategories.LEGACY, "ClassId of ", e.getElement().getClass(), " is null");
            return null;
        }
        ElementManager mgr = null;
        ClusterNode clusterNode = null;
        Integer intID = ManagersConfigurator.getIntegerForId(classId);
        if (m_map.containsKey(intID)) {
            mgr = (ElementManager)m_map.get(intID);
        } else {
            clusterNode = e.getClusterNode();
            mgr = clusterNode.getManager4ClassId(classId);
        }
        if (mgr == null) {
            theLogger.warn(SrLogCategories.ERROR, "ManagersConfigurator: Manager was not found for ClassID : ", classId, "; intID: ", intID);
        }
        return mgr;
    }

    public static Integer getIntegerForId(ClassID id) {
        return new Integer(id.getId());
    }

    static {
        theLogger = SrLogger.getLogger();
    }
}

