/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.ObjectStatus;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.event.ConnectionErrorEvent;
import com.sanrad.nms.client.event.ConnectionErrorListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.util.SrEventListenerManager;
import java.util.WeakHashMap;

public class Manager {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private static SrEventListenerManager theConnectionListeners = new SrEventListenerManager();
    private static boolean theIsConnected = false;
    protected SrEventListenerManager m_listeners = new SrEventListenerManager();
    public static final int MAX_VSWITCHES_NUMBER = 2;
    private static WeakHashMap<SrTreeNode, RemoteObject> myRefToStub = new WeakHashMap();
    private static WeakHashMap<SrTreeNode, Object> myRefToId = new WeakHashMap();
    private static final SrEventListenerManager.Informer onConnectionErrorInformer = new SrEventListenerManager.Informer<ConnectionErrorListener, ConnectionErrorEvent>(){

        @Override
        public void inform(ConnectionErrorListener listener, ConnectionErrorEvent event) {
            listener.onConnectionError(event);
        }
    };

    protected Manager() {
    }

    public static void addErrorConnectionListener(ConnectionErrorListener listener) {
        theConnectionListeners.add(listener);
    }

    public static void removeErrorConnectionListener(ConnectionErrorListener listener) {
        theConnectionListeners.remove(listener);
    }

    public static void onConnectionError(final String message) {
        if (!theIsConnected) {
            return;
        }
        theIsConnected = false;
        EventDispatcherTask.submit(new Runnable(){

            @Override
            public void run() {
                ConnectionErrorEvent event = new ConnectionErrorEvent(Manager.class, message == null ? "Failed to connect to Server." : message);
                theConnectionListeners.fireEvent(ConnectionErrorListener.class, event, onConnectionErrorInformer);
            }
        });
    }

    public static void onConnectionError() {
        Manager.onConnectionError(null);
    }

    public static boolean isConnected() {
        return theIsConnected;
    }

    public static void setConnected() {
        theIsConnected = true;
    }

    public static synchronized RemoteObject removeStubAndId(Object ref) {
        myRefToId.remove(ref);
        return myRefToStub.remove(ref);
    }

    public static synchronized RemoteObject removeStubAndId(RemoteObject element) {
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(element);
        return Manager.removeStubAndId(node);
    }

    public static synchronized RemoteObject getStubByRef(SrTreeNode ref) {
        RemoteObject stub = myRefToStub.get(ref);
        return stub;
    }

    private static boolean validateNoReplacement(SrTreeNode ref, WeakHashMap<SrTreeNode, ?> map) {
        return !map.containsKey(ref);
    }

    public static synchronized SrTreeNode getRefById(Object id) {
        for (SrTreeNode ref : myRefToId.keySet()) {
            if (!myRefToId.get(ref).equals(id)) continue;
            return ref;
        }
        return null;
    }

    public static synchronized Object getIdByRef(Object ref) {
        return myRefToId.get(ref);
    }

    public static synchronized void putRefToMapping(SrTreeNode ref, Object id, RemoteObject stub) {
        theLogger.logAndAssert(SrLogCategories.ERROR, Manager.validateNoReplacement(ref, myRefToId), new Object[]{"Tree node replaces other ID, ", ref});
        SrTreeNode prevRef = Manager.getRefById(id);
        if (prevRef != null) {
            theLogger.warn(SrLogCategories.DEBUG, "Suspicion to memory leak of ", prevRef.type(), " ", prevRef);
        }
        myRefToId.remove(prevRef);
        myRefToId.put(ref, id);
        theLogger.logAndAssert(SrLogCategories.ERROR, Manager.validateNoReplacement(ref, myRefToStub), new Object[]{"Tree node replaces other Stub, ", ref});
        myRefToStub.remove(prevRef);
        myRefToStub.put(ref, stub);
    }

    public static ObjectStatus getSeverity(AlarmSeverity severity) {
        if (severity != null) {
            if (severity.equals(AlarmSeverity.CRITICAL)) {
                return ObjectStatus.FATAL;
            }
            if (severity.equals(AlarmSeverity.MAJOR)) {
                return ObjectStatus.ERROR;
            }
            if (severity.equals(AlarmSeverity.MINOR)) {
                return ObjectStatus.WARNING;
            }
            if (severity.equals(AlarmSeverity.WARNING)) {
                return ObjectStatus.INFO;
            }
            if (severity.equals(AlarmSeverity.OK)) {
                return ObjectStatus.OK;
            }
            return ObjectStatus.OK;
        }
        return null;
    }
}

