/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.SCSILunStateConstant;
import com.sanrad.nms.server.util.types.constants.SCSILunStatusConstant;
import com.sanrad.util.BundleKeysInterface;
import java.rmi.RemoteException;
import java.util.List;

public class LUNode
extends SrTreeNode<LU, CommKeyClassId> {
    private Integer lun;
    private TargetNode targetParent;
    private VolumeTreeNode volumeChild;
    private String deviceRevisionID;
    private SCSILunStateConstant deviceState;
    private SCSILunStatusConstant deviceStatus;
    private String m_serialNumer;

    public LUNode(LU stub) throws RemoteException {
        super(stub, stub.getCommKeyClassId());
        this.setNodeIcon(ClientImageObject.LU);
    }

    public void setTargetParent(TargetNode targetParent) {
        this.targetParent = targetParent;
    }

    public TargetNode getTargetParent() {
        return this.targetParent;
    }

    public VolumeTreeNode getVolumeChild() {
        return this.volumeChild;
    }

    public void setVolumeChild(VolumeTreeNode child) {
        this.volumeChild = child;
    }

    public void setLUN(Integer lun) {
        this.lun = lun;
    }

    public Integer getLUN() {
        return this.lun;
    }

    @Override
    public String type() {
        return "LU";
    }

    @Override
    public String toString() {
        return this.targetParent.getAlias() + ", LUN- " + this.lun.toString();
    }

    public String getDeviceRevisionID() {
        return this.deviceRevisionID;
    }

    public void setDeviceRevisionID(String deviceRevisionID) {
        this.deviceRevisionID = deviceRevisionID;
    }

    public SCSILunStateConstant getDeviceState() {
        return this.deviceState;
    }

    public void setDeviceState(SCSILunStateConstant deviceState) {
        this.deviceState = deviceState;
    }

    public SCSILunStatusConstant getDeviceStatus() {
        return this.deviceStatus;
    }

    public void setDeviceStatus(SCSILunStatusConstant deviceStatus) {
        this.deviceStatus = deviceStatus;
    }

    public String getSerialNumber() {
        return this.m_serialNumer;
    }

    public void setSerialNumber(String sn) {
        this.m_serialNumer = sn;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof LUNode) {
            return this.lun.compareTo(((LUNode)o).lun);
        }
        return -1;
    }

    @Override
    public String getProblemOnDeletion() {
        DRPairNode drPair;
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(this.getVolumeChild());
        List<SnapshotVolumeNode> nodeSnapshots = VolumeManager.getInstance().getClusterSnapshotMap().getSnapshotsForSource(clusterNode, this.getVolumeChild());
        if (nodeSnapshots != null) {
            for (SnapshotVolumeNode snapshot : nodeSnapshots) {
                if (!snapshot.isExposed()) continue;
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.EXPOSED_VOLUME_VALIDAION_SOURCE_OF_EXPOSED_SNAPSHOT, snapshot.toString());
            }
        }
        if ((drPair = DRPairManager.getPairContainingVolume(this.getVolumeChild())) != null) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.EXPOSED_VOLUME_VALIDAION_USED_FOR_DR, drPair.toString());
        }
        if (this.getVolumeChild().getParent() instanceof VolumeTreeNode) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VOLUME_VALIDATION_CANNOT_BE_EXPOSED_CAUSE_THE_VOLUME_HAS_A_PARENT);
        }
        return super.getProblemOnDeletion();
    }
}

