/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.client.event.lu.LUEvent;
import com.sanrad.nms.client.event.lu.LUListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.util.types.constants.SCSILunStateConstant;
import com.sanrad.nms.server.util.types.constants.SCSILunStatusConstant;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.SrEventListenerManager;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;

public class LUManager
extends ElementManager {
    private static LUManager theInstance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer luStatusChangedInformer = new SrEventListenerManager.Informer<LUListener, LUEvent>(){

        @Override
        public void inform(LUListener listener, LUEvent event) {
            listener.luStatusChanged(event);
        }
    };
    SrEventListenerManager.Informer luCreatedInformer = new SrEventListenerManager.Informer<LUListener, LUEvent>(){

        @Override
        public void inform(LUListener listener, LUEvent event) {
            listener.luCreated(event);
        }
    };
    SrEventListenerManager.Informer luChangedInformer = new SrEventListenerManager.Informer<LUListener, LUEvent>(){

        @Override
        public void inform(LUListener listener, LUEvent event) {
            listener.luChanged(event);
        }
    };
    SrEventListenerManager.Informer luRemovedInformer = new SrEventListenerManager.Informer<LUListener, LUEvent>(){

        @Override
        public void inform(LUListener listener, LUEvent event) {
            listener.luRemoved(event);
        }
    };

    private LUManager() {
    }

    public static synchronized LUManager getInstance() {
        if (theInstance == null) {
            theInstance = new LUManager();
        }
        return theInstance;
    }

    public void addLUListener(LUListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeLUListener(LUListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        try {
            RemoteObject element = e.getElement();
            if (this.isClusterInDiscovery(element)) {
                return;
            }
            if (this.alreadyExist(element)) {
                return;
            }
            theLogger.trace(SrLogCategories.LEGACY, "LUManager: LU created");
            LU lu = (LU)element;
            HashMap params = this.getParameterList(e);
            LUNode lunode = this.createLU(lu, params);
            if (lunode != null) {
                theLogger.trace(SrLogCategories.LEGACY, "LUManager: LU created - ", lunode);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
            LUManager.onConnectionError();
        }
    }

    public void elementRemovedFromVSwitch(CommunicationEvent e) {
    }

    @Override
    public void alreadyKnownByVSwitch(CommunicationEvent e) {
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
        RemoteObject element = e.getStub();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (element instanceof LU) {
            if (SystemRootNode.getInstance().getRefByStub(element) == null) {
                theLogger.trace(SrLogCategories.LEGACY, "LUManager- propagatedStateChanged() on an unknown element !");
                return;
            }
            theLogger.trace(SrLogCategories.LEGACY, "LUManager: Propagated State Changed.");
            super.propagatedStateChanged(e);
            LU lu = (LU)element;
            LUNode luNode = (LUNode)SystemRootNode.getInstance().getRefByStub(lu);
            theLogger.trace(SrLogCategories.LEGACY, "LUManager: fire Lu status changed.");
            this.fireLUStatusChanged(luNode);
        }
    }

    private void setVolumeToLu(LUNode lunode, VolumeTreeNode volumeNode) {
        if (volumeNode != null) {
            lunode.setVolumeChild(volumeNode);
            volumeNode.removeFromParent();
            volumeNode.setConfigurationParent(lunode);
            volumeNode.setLUNode(lunode);
            theLogger.trace(SrLogCategories.LEGACY, "LUManager: volume - ", volumeNode.getAlias(), " gets LU - ", lunode);
        }
    }

    public LUNode createLU(LU lu, HashMap params, TargetNode targetNode) throws RemoteException {
        LUNode lunode = new LUNode(lu);
        Object lunObj = this.getObjectForParam(params, ClientParameterCode.LU_LUN, true);
        Target parentTargetObj = (Target)this.getObjectForParam(params, ClientParameterCode.LU_PARENT_TARGET, true);
        Object PropagatedStateObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.PROPAGATED_STATE", true);
        VolumeNode volumeChildObj = (VolumeNode)this.getObjectForParam(params, ClientParameterCode.LU_VOLUME_CHILD, true);
        String deviceRevisionID = (String)this.getObjectForParam(params, ClientParameterCode.LU_DEVICE_REVISION_ID, true);
        SCSILunStateConstant deviceState = (SCSILunStateConstant)this.getObjectForParam(params, ClientParameterCode.LU_DEVICE_STATE, true);
        SCSILunStatusConstant deviceStatus = (SCSILunStatusConstant)this.getObjectForParam(params, ClientParameterCode.LU_DEVICE_STATUS, true);
        String luSerialNumber = (String)this.getObjectForParam(params, ClientParameterCode.LU_SERIAL_NUMBER, true);
        if (targetNode != null) {
            lunode.setTargetParent(targetNode);
        } else {
            if (parentTargetObj == null) {
                parentTargetObj = lu.getParentTarget();
            }
            targetNode = (TargetNode)SystemRootNode.getInstance().getRefByStub(parentTargetObj);
            lunode.setTargetParent(targetNode);
        }
        if (lunObj == null) {
            lunObj = lu.getLUN();
        }
        if (PropagatedStateObj == null) {
            PropagatedStateObj = lu.getPropagatedState();
        }
        if (volumeChildObj == null) {
            volumeChildObj = lu.getVolumeChild();
        }
        if (lunObj instanceof BigInteger) {
            lunObj = new Integer(((BigInteger)lunObj).intValue());
        }
        Integer lun = (Integer)lunObj;
        lunode.setLUN(lun);
        lunode.setStatus(LUManager.getSeverity((AlarmSeverity)PropagatedStateObj));
        lunode.setDeviceRevisionID(deviceRevisionID);
        lunode.setDeviceState(deviceState);
        lunode.setDeviceStatus(deviceStatus);
        SrTreeNode volumeNode = SystemRootNode.getInstance().getRefByStub(volumeChildObj);
        this.setVolumeToLu(lunode, (VolumeTreeNode)volumeNode);
        lunode.setSerialNumber(luSerialNumber);
        this.updateVolumeNodeIfDirectAccessDevice(volumeChildObj, volumeNode);
        SystemRootNode.getInstance().putRefAndStub(lu, lunode);
        theLogger.trace(SrLogCategories.LEGACY, "LUManager: createdLU() - ", lunode);
        this.fireLUCreatedEvent(lunode);
        return lunode;
    }

    public LUNode createLU(LU lu, HashMap params) throws RemoteException {
        return this.createLU(lu, params, null);
    }

    public void changeLU(LUNode lunode, VolumeTreeNode volumeNode) {
        VolumeTreeNode oldVol = lunode.getVolumeChild();
        if (oldVol != null) {
            oldVol.setLUNode(null);
            oldVol.setConfigurationParent(null);
            this.setVolumeToLu(lunode, volumeNode);
            theLogger.trace(SrLogCategories.LEGACY, "LUManager: cahnge() - ", lunode);
        }
        this.fireLUChangedEvent(lunode);
    }

    public void fireLUStatusChanged(LUNode node) {
        LUEvent event = this.createLUEvent((LU)node.getStub());
        theLogger.trace(SrLogCategories.LEGACY, "fire Lu status changed: ");
        this.m_listeners.fireEvent(LUListener.class, event, this.luStatusChangedInformer);
    }

    private void updateTarget(TargetNode targetNode, LUNode lu, boolean created) {
        if (targetNode != null) {
            if (created) {
                targetNode.getLuNodes().addElement(lu);
            } else {
                targetNode.getLuNodes().remove(lu);
            }
            targetNode.setLuCount(targetNode.getLuNodes().size());
            targetNode.setEmpty(targetNode.getLuNodes().isEmpty());
            theLogger.trace(SrLogCategories.LEGACY, "update target Node: ", targetNode.getName(), " luCount - ", targetNode.getLuCount());
        }
    }

    private void updateVolumeNodeIfDirectAccessDevice(Object volumeNodeStub, Object volumeNode) throws RemoteException {
        if (volumeNodeStub instanceof DirectAccessDevice) {
            DirectAccessDeviceNode disk = (DirectAccessDeviceNode)volumeNode;
            BigInteger nonAllocatedSpace = ((DirectAccessDevice)volumeNodeStub).getNonAllocatedSpace();
            BigInteger allocatedSpace = ((DirectAccessDevice)volumeNodeStub).getAllocatedSpace();
            disk.setNonAllocatedSpace(nonAllocatedSpace);
            disk.setAllocatedSpace(allocatedSpace);
            DirectAccessDeviceManager.getInstance().fireDirectAccessDeviceChanged(disk);
        }
    }

    private void fireLUCreatedEvent(LUNode lu) {
        Integer lun = lu.getLUN();
        TargetNode target = lu.getTargetParent();
        VolumeTreeNode volume = lu.getVolumeChild();
        if (volume != null) {
            theLogger.trace(SrLogCategories.LEGACY, "LU created - ", volume.getAlias(), " LUN -", lu.getLUN());
            this.updateTarget(target, lu, true);
            LUEvent event = new LUEvent(this, (RemoteObject)lu.getStub());
            event.setLUN(lun);
            event.setVolumeStub((VolumeNode)volume.getStub());
            event.setTargetAlias(target.getAlias());
            event.setTargetStub((Target)target.getStub());
            event.setVolumeAlias(volume.getAlias());
            this.m_listeners.fireEvent(LUListener.class, event, this.luCreatedInformer);
        } else {
            theLogger.error(SrLogCategories.LEGACY, "LU created - with a NULL Volume LUN -", lu.getLUN());
        }
    }

    public void fireLUChangedEvent(LUNode lu) {
        Integer lun = lu.getLUN();
        TargetNode target = lu.getTargetParent();
        if (SystemRootNode.getInstance().getRefByStub((RemoteObject)target.getStub()) == null) {
            theLogger.error(SrLogCategories.LEGACY, "LU Changed - stop change process: target node ", target.getAlias(), " exists as LU parent of lun ", lu.getLUN(), " BUT does not exist in SystemRootNode!");
            return;
        }
        VolumeTreeNode volume = lu.getVolumeChild();
        theLogger.trace(SrLogCategories.LEGACY, "LU changed - ", volume.getAlias(), " LUN -", lu.getLUN());
        LUEvent event = new LUEvent(this, (RemoteObject)lu.getStub());
        event.setLUN(lun);
        event.setVolumeStub((VolumeNode)volume.getStub());
        event.setTargetAlias(target.getAlias());
        event.setTargetStub((Target)target.getStub());
        event.setVolumeAlias(volume.getAlias());
        this.m_listeners.fireEvent(LUListener.class, event, this.luChangedInformer);
    }

    private void fireLURemovedEvent(LUNode lu) {
        Integer lun = lu.getLUN();
        TargetNode target = lu.getTargetParent();
        if (SystemRootNode.getInstance().getRefByStub((RemoteObject)target.getStub()) == null) {
            theLogger.error(SrLogCategories.LEGACY, "LU removed - stop remove process from client: target node ", target.getAlias(), " exists as LU parent of lun ", lu.getLUN(), " BUT does not exist in SystemRootNode!");
            return;
        }
        this.updateTarget(target, lu, false);
        VolumeTreeNode volumeNode = lu.getVolumeChild();
        LUEvent event = new LUEvent(this, (RemoteObject)lu.getStub());
        event.setLUN(lun);
        event.setVolumeStub((VolumeNode)volumeNode.getStub());
        event.setTargetAlias(target.getAlias());
        event.setTargetStub((Target)target.getStub());
        event.setVolumeAlias(volumeNode.getAlias());
        this.m_listeners.fireEvent(LUListener.class, event, this.luRemovedInformer);
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        LU lu = (LU)element;
        LUNode luNode = (LUNode)SystemRootNode.getInstance().getRefByStub(lu);
        if (luNode != null) {
            this.fireLURemovedEvent(luNode);
            SystemRootNode.getInstance().removeRefAndIdByStub(lu);
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        LUNode lu = (LUNode)SystemRootNode.getInstance().getRefByStub(element);
        if (lu == null) {
            return;
        }
        HashMap params = this.getParameterList(e);
        try {
            VolumeNode volume = (VolumeNode)this.getObjectForParam(params, ClientParameterCode.LU_VOLUME_CHILD, false);
            VolumeTreeNode vol = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(volume);
            if (volume != null) {
                this.changeLU(lu, vol);
            }
            HashMap parameterList = ((LU)lu.getStub()).getClientParameterList();
            lu.setDeviceRevisionID((String)this.getObjectForParam(parameterList, ClientParameterCode.LU_DEVICE_REVISION_ID, false));
            lu.setDeviceState((SCSILunStateConstant)this.getObjectForParam(parameterList, ClientParameterCode.LU_DEVICE_STATE, false));
            lu.setDeviceStatus((SCSILunStatusConstant)this.getObjectForParam(parameterList, ClientParameterCode.LU_DEVICE_STATUS, false));
            if (params.containsKey(ClientParameterCode.LU_SERIAL_NUMBER)) {
                lu.setSerialNumber((String)params.get(ClientParameterCode.LU_SERIAL_NUMBER));
            }
        }
        catch (Exception re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
        }
    }

    private LUEvent createLUEvent(LU lu) {
        LUEvent event = new LUEvent(this, lu);
        try {
            VolumeNode volumeChild = lu.getVolumeChild();
            event.setVolumeStub(volumeChild);
            event.setLUN(lu.getLUN());
            VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(volumeChild);
            if (volumeChild != null && volume != null) {
                event.setVolumeAlias(volume.getAlias());
            }
            event.setVolumeAlias(null);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            LUManager.onConnectionError();
        }
        return event;
    }

    public boolean canBeDeleted(Object[] lus) {
        if (lus == null || lus.length == 0) {
            return false;
        }
        try {
            for (int i = 0; i < lus.length; ++i) {
                int luNumber = ((LU)lus[i]).getParentTarget().getLUCount();
                if (((LU)lus[i]).getLUN() != 0 || luNumber <= 1) continue;
                return false;
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            LUManager.onConnectionError();
        }
        return true;
    }

    public static int getNextFreeLuNumber(TargetNode aTarget) {
        assert (aTarget != null) : "The given target should not be null";
        Integer maxLuNumber = ClientLoader.CONSTANSTS_BUNDLE.getIntResource(SrConstantsBundleKeys.MAX_LUN_VALUE);
        ArrayList<Integer> luNumbers = new ArrayList<Integer>();
        for (LUNode curNode : aTarget.getLuNodes()) {
            luNumbers.add(curNode.getLUN());
        }
        if (luNumbers.size() >= maxLuNumber) {
            throw new IllegalArgumentException("The target " + aTarget + " already has " + maxLuNumber + " LUs which is the maximum allowed number of LUs.");
        }
        for (int retVal = 0; retVal < maxLuNumber; ++retVal) {
            if (luNumbers.contains(retVal)) continue;
            return retVal;
        }
        throw new IllegalStateException("Could not find a free LU within the existing LUs for target " + aTarget + ": " + luNumbers);
    }
}

