/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.vswitch.InterfaceTableRowNode;
import com.sanrad.nms.client.data.vswitch.SFPConnectedInterfaceTableRow;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.data.vswitch.interfaces.ethernet.EthernetInterfaceTableRow;
import com.sanrad.nms.client.data.vswitch.interfaces.fc.FCInterfaceTableRow;
import com.sanrad.nms.client.data.vswitch.interfaces.fc.FCTopologyConstants;
import com.sanrad.nms.client.data.vswitch.interfaces.pscsi.PSCSIInterfaceTableRow;
import com.sanrad.nms.client.event.InterfaceEvent;
import com.sanrad.nms.client.event.InterfaceListener;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.logic.vswitch.SFPConnectedInterface;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.types.constants.FcAdminSpeedConstant;
import com.sanrad.nms.server.util.types.constants.FcPortTypeConstant;
import com.sanrad.nms.server.util.types.constants.IfJumboMtuConstant;
import com.sanrad.nms.server.util.types.constants.InterfaceSFPConnectorConstant;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.Callable;

public class InterfaceManager
extends ElementManager {
    public static final String ETHERNET_INTERFACE = "ethernetCsmacd";
    public static final String FC_INTERFACE = "fibreChannel";
    public static final String PSCSI_INTERFACE = "ultra";
    private static SrLogger theLogger = SrLogger.getLogger();
    private static InterfaceManager instance = null;
    SrEventListenerManager.Informer interfaceTableRowParameterChangedInformer = new SrEventListenerManager.Informer<InterfaceListener, InterfaceEvent>(){

        @Override
        public void inform(InterfaceListener listener, InterfaceEvent event) {
            listener.interfaceTableRowParameterChanged(event);
        }
    };
    SrEventListenerManager.Informer interfaceTableRowAliasChangedInformer = new SrEventListenerManager.Informer<InterfaceListener, InterfaceEvent>(){

        @Override
        public void inform(InterfaceListener listener, InterfaceEvent event) {
            listener.interfaceTableRowChanged(event);
        }
    };
    SrEventListenerManager.Informer interfaceTableRowOperStatusChangedInformer = new SrEventListenerManager.Informer<InterfaceListener, InterfaceEvent>(){

        @Override
        public void inform(InterfaceListener listener, InterfaceEvent event) {
            listener.interfaceTableRowOperStatusChanged(event);
        }
    };
    SrEventListenerManager.Informer interfaceTableRowCreatedInformer = new SrEventListenerManager.Informer<InterfaceListener, InterfaceEvent>(){

        @Override
        public void inform(InterfaceListener listener, InterfaceEvent event) {
            listener.interfaceTableRowCreated(event);
        }
    };

    private InterfaceManager() {
    }

    public static synchronized InterfaceManager getInstance() {
        if (instance == null) {
            instance = new InterfaceManager();
        }
        return instance;
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        try {
            InterfaceTableRow rowStub = (InterfaceTableRow)element;
            HashMap map = this.getParameterList(e);
            Object aliasObj = this.getObjectForParam(map, ClientParameterCode.INTERFACE_ALIAS, true);
            Object descriptorObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.INTERFACE_DESCRIPTOR", true);
            Object highSpeedObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.INTERFACE_HIGH_SPEED", true);
            Object nameObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.INTERFACE_NAME", true);
            Object typeObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.INTERFACE_TYPE", true);
            Object physAddressObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.INTERFACE_PHYS_ADDRESS", true);
            VSwitch parentObj = (VSwitch)this.getObjectForParam(map, "Missing code - ClientParameterCode. (should be VS ID) INTERFACE_PARENT_OBJ", true);
            Object operStatusObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.INTERFACE_OPER_STATUS", true);
            Object mtuJumboObj = this.getObjectForParam(map, ClientParameterCode.INTERFACE_JUMBO_MTU, true);
            if (aliasObj == null) {
                aliasObj = rowStub.getAlias();
            }
            if (descriptorObj == null) {
                descriptorObj = rowStub.getDescriptor();
            }
            if (highSpeedObj == null) {
                highSpeedObj = rowStub.getHighSpeedMbits();
            }
            if (nameObj == null) {
                nameObj = rowStub.getName();
            }
            if (typeObj == null) {
                typeObj = rowStub.getType();
            }
            if (physAddressObj == null) {
                physAddressObj = rowStub.getPhysicalAddress();
            }
            if (parentObj == null) {
                parentObj = rowStub.getParentVSwitch();
            }
            if (operStatusObj == null) {
                operStatusObj = rowStub.getOperationalStatus();
            }
            if (mtuJumboObj == null) {
                mtuJumboObj = rowStub.getJumboMtu();
            }
            String alias = (String)aliasObj;
            String descriptor = (String)descriptorObj;
            BigInteger highSpeed = (BigInteger)highSpeedObj;
            String name = (String)nameObj;
            String type = (String)typeObj;
            String physAddress = (String)physAddressObj;
            String operStatus = (String)operStatusObj;
            InterfaceTableRowNode row = null;
            if (rowStub instanceof com.sanrad.nms.server.logic.vswitch.fc.FCInterfaceTableRow) {
                com.sanrad.nms.server.logic.vswitch.fc.FCInterfaceTableRow fcRow = (com.sanrad.nms.server.logic.vswitch.fc.FCInterfaceTableRow)rowStub;
                row = new FCInterfaceTableRow(fcRow, parentObj, alias, descriptor, highSpeed, name, physAddress, type, operStatus);
                Object wwpnObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.FC_IF_WWPN", true);
                Object adminSpeedObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.FC_IF_ADMIN_SPEED", true);
                Object connectModeObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.FC_IF_CONNECT_NODE", true);
                Object operTypeObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.FC_IF_OPER_TYPE", true);
                if (wwpnObj == null) {
                    wwpnObj = fcRow.getWWPN();
                }
                if (adminSpeedObj == null) {
                    adminSpeedObj = fcRow.getAdminSpeed();
                }
                if (connectModeObj == null) {
                    connectModeObj = fcRow.getConnectMode();
                }
                if (operTypeObj == null) {
                    operTypeObj = fcRow.getOperType();
                }
                ((FCInterfaceTableRow)row).setWWPN((String)wwpnObj);
                ((FCInterfaceTableRow)row).setSpeed((String)adminSpeedObj);
                ((FCInterfaceTableRow)row).setTopology((String)connectModeObj);
                ((FCInterfaceTableRow)row).setPortType((String)operTypeObj);
            } else if (rowStub instanceof com.sanrad.nms.server.logic.vswitch.pscsi.PSCSIInterfaceTableRow) {
                com.sanrad.nms.server.logic.vswitch.pscsi.PSCSIInterfaceTableRow pscsiRow = (com.sanrad.nms.server.logic.vswitch.pscsi.PSCSIInterfaceTableRow)rowStub;
                row = new PSCSIInterfaceTableRow(pscsiRow, parentObj, alias, descriptor, highSpeed, name, physAddress, type, operStatus);
                Object busIdObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.PSCSI_BUS_ID", true);
                if (busIdObj == null) {
                    busIdObj = new Integer(pscsiRow.getBusId());
                }
                ((PSCSIInterfaceTableRow)row).setBusId((Integer)busIdObj);
            } else if (rowStub instanceof com.sanrad.nms.server.logic.vswitch.ethernet.EthernetInterfaceTableRow) {
                row = new EthernetInterfaceTableRow((com.sanrad.nms.server.logic.vswitch.ethernet.EthernetInterfaceTableRow)rowStub, parentObj, alias, descriptor, highSpeed, name, physAddress, type, operStatus);
                row.setJumboMtu((IfJumboMtuConstant)mtuJumboObj);
            } else {
                row = new InterfaceTableRowNode<InterfaceTableRow>(rowStub, parentObj, alias, descriptor, highSpeed, name, physAddress, type, operStatus);
            }
            if (rowStub instanceof SFPConnectedInterface) {
                SFPConnectedInterface sfpRowStub = (SFPConnectedInterface)rowStub;
                Object sfpTypeObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.INTERFACE_CONNECTED_SFP_TYPE", true);
                Object sfpVendorNameObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.INTERFACE_CONNECTED_SFP_VENDOR_NAME", true);
                Object sfpSpeedObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.INTERFACE_CONNECTED_SFP_SPEED", true);
                Object sfpVendorOUIObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.INTERFACE_CONNECTED_SFP_VENDOR_OUI", true);
                if (sfpTypeObj == null) {
                    sfpTypeObj = sfpRowStub.getConnectedSFPType();
                }
                if (sfpVendorNameObj == null) {
                    sfpVendorNameObj = sfpRowStub.getConnectedSFPVendorName();
                }
                if (sfpSpeedObj == null) {
                    sfpSpeedObj = sfpRowStub.getConnectedSFPSpeedMbits();
                }
                if (sfpVendorOUIObj == null) {
                    sfpVendorOUIObj = sfpRowStub.getConnectedSFPVendorOUI();
                }
                if (sfpTypeObj == null) {
                    ((SFPConnectedInterfaceTableRow)row).setSFPType(InterfaceSFPConnectorConstant.UNKNOWN);
                } else {
                    ((SFPConnectedInterfaceTableRow)row).setSFPType((InterfaceSFPConnectorConstant)sfpTypeObj);
                    ((SFPConnectedInterfaceTableRow)row).setSFPVendorName((String)sfpVendorNameObj);
                    ((SFPConnectedInterfaceTableRow)row).setSFPSpeed((Integer)sfpSpeedObj);
                    ((SFPConnectedInterfaceTableRow)row).setSFPVendorOUI((String)sfpVendorOUIObj);
                }
            }
            SystemRootNode.getInstance().putRefAndStub(rowStub, row);
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(parentObj);
            if (node != null) {
                VSwitchNode vswitchNode = (VSwitchNode)node;
                vswitchNode.getInterfaceTable().add(row);
                theLogger.trace(SrLogCategories.LEGACY, "Interface row was created: ", alias, " on ", ClientLoader.VSWITCH_DISPLAY_STRING, ": ", vswitchNode.getName());
            }
            this.fireInterfaceTableRowCreated(row);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            InterfaceManager.onConnectionError();
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "Interface row was changed.");
        InterfaceTableRowNode interfaceRow = (InterfaceTableRowNode)SystemRootNode.getInstance().getRefByStub(element);
        if (interfaceRow != null) {
            HashMap map = this.getParameterList(e);
            Object newAlias = this.getObjectForParam(map, ClientParameterCode.INTERFACE_ALIAS, false);
            Object newSpeed = this.getObjectForParam(map, ClientParameterCode.INTERFACE_SPEED, false);
            Object portOperType = this.getObjectForParam(map, ClientParameterCode.FC_IF_PORT_OPER_TYPE, false);
            Object fcSpeed = this.getObjectForParam(map, ClientParameterCode.FC_IF_SPEED, false);
            Object fcTopology = this.getObjectForParam(map, ClientParameterCode.FC_IF_TOPOLOGY, false);
            Object busId = this.getObjectForParam(map, ClientParameterCode.PSCSI_IF_BUS_ID, false);
            Object newOperStatus = this.getObjectForParam(map, ClientParameterCode.INTERFACE_OPER_STATUS, false);
            Object newJumboMtuVal = this.getObjectForParam(map, ClientParameterCode.INTERFACE_JUMBO_MTU, false);
            if (busId != null) {
                ((PSCSIInterfaceTableRow)interfaceRow).setBusId((Integer)busId);
                this.firePSCSIParameterChanged((PSCSIInterfaceTableRow)interfaceRow);
            }
            if (newAlias != null) {
                interfaceRow.setAlias(newAlias.toString());
                this.fireInterfaceChanged(interfaceRow);
            }
            if (newSpeed != null) {
                interfaceRow.setHighSpeed((BigInteger)newSpeed);
                this.fireInterfaceChanged(interfaceRow);
            }
            if (portOperType != null) {
                FcPortTypeConstant pType = FcPortTypeConstant.getType((int)((Integer)portOperType));
                ((FCInterfaceTableRow)interfaceRow).setPortType(pType.toString());
                this.fireFcParameterChanged((FCInterfaceTableRow)interfaceRow);
            }
            if (fcSpeed != null) {
                FcAdminSpeedConstant speed = FcAdminSpeedConstant.getSpeed((Integer)fcSpeed);
                ((FCInterfaceTableRow)interfaceRow).setSpeed(speed.toString());
                this.fireFcParameterChanged((FCInterfaceTableRow)interfaceRow);
            }
            if (fcTopology != null) {
                FCTopologyConstants topology = FCTopologyConstants.getTopology((Integer)fcTopology);
                ((FCInterfaceTableRow)interfaceRow).setTopology(topology.toString());
                this.fireFcParameterChanged((FCInterfaceTableRow)interfaceRow);
            }
            if (newOperStatus != null) {
                interfaceRow.setOperStatus(newOperStatus.toString());
                this.fireInterfaceOperStatusChanged(interfaceRow);
            }
            if (newJumboMtuVal != null) {
                int mtuVal = (Integer)newJumboMtuVal;
                IfJumboMtuConstant mtuToSet = IfJumboMtuConstant.valueOf(mtuVal);
                interfaceRow.setJumboMtu(mtuToSet);
                this.fireInterfaceChanged(interfaceRow);
            }
        }
    }

    private void fireFcParameterChanged(FCInterfaceTableRow fcInterface) {
        InterfaceEvent event = new InterfaceEvent((Object)this, fcInterface);
        theLogger.trace(SrLogCategories.LEGACY, "fire event: FC Interface row parameter changed.");
        this.m_listeners.fireEvent(InterfaceListener.class, event, this.interfaceTableRowParameterChangedInformer);
    }

    private void firePSCSIParameterChanged(PSCSIInterfaceTableRow pscsiInterface) {
        InterfaceEvent event = new InterfaceEvent((Object)this, pscsiInterface);
        theLogger.trace(SrLogCategories.LEGACY, "fire event: pSCSI Interface row parameter changed.");
        this.m_listeners.fireEvent(InterfaceListener.class, event, this.interfaceTableRowParameterChangedInformer);
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
    }

    private void fireInterfaceChanged(InterfaceTableRowNode row) {
        InterfaceEvent event = new InterfaceEvent((Object)this, row);
        event.setAlias(row.getAlias());
        theLogger.trace(SrLogCategories.LEGACY, "fire event: Interface row alias changed.");
        this.m_listeners.fireEvent(InterfaceListener.class, event, this.interfaceTableRowAliasChangedInformer);
    }

    private void fireInterfaceOperStatusChanged(InterfaceTableRowNode row) {
        InterfaceEvent event = new InterfaceEvent((Object)this, row);
        event.setOperStatus(row.getOperStatus());
        theLogger.trace(SrLogCategories.LEGACY, "fire event: Interface row oper status changed.");
        this.m_listeners.fireEvent(InterfaceListener.class, event, this.interfaceTableRowOperStatusChangedInformer);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    private void fireInterfaceTableRowCreated(InterfaceTableRowNode row) {
        InterfaceEvent event = new InterfaceEvent((Object)this, (RemoteObject)row.getStub());
        theLogger.trace(SrLogCategories.LEGACY, "fire event: Interface row created.");
        this.m_listeners.fireEvent(InterfaceListener.class, event, this.interfaceTableRowCreatedInformer);
    }

    public void addInterfaceListener(InterfaceListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeInterfaceListener(InterfaceListener listener) {
        this.m_listeners.remove(listener);
    }

    public SrFuture<Void> changeInterfaceTableRow(InterfaceTableRowNode<?> val, HashMap params) {
        return ClientAOImpl.getInstance().changeElements(Collections.singleton(val.getIdentifier()), params);
    }

    public Collection<SrFuture<Void>> editInterfaceTableRow(HashMap<? extends InterfaceTableRowNode, HashMap> interfaceParams) {
        Vector<SrFuture<Void>> retVal = new Vector<SrFuture<Void>>(interfaceParams.size());
        for (InterfaceTableRowNode interfaceTableRowNode : interfaceParams.keySet()) {
            HashMap params = interfaceParams.get(interfaceTableRowNode);
            retVal.add(this.changeInterfaceTableRow(interfaceTableRowNode, params));
        }
        return retVal;
    }

    public InterfaceTableRowNode getInterfaceByName(VSwitchNode aVS, String aIfName) {
        if (aIfName == null || aVS == null) {
            return null;
        }
        ArrayList<InterfaceTableRowNode> interfaces = new ArrayList<InterfaceTableRowNode>(aVS.getInterfaceTable());
        for (InterfaceTableRowNode curIf : interfaces) {
            if (!aIfName.equals(curIf.getName())) continue;
            return curIf;
        }
        return null;
    }

    class InterfaceTableRowEditor
    implements Callable<Void> {
        private Object aliasObject;
        private HashMap myParams;

        public InterfaceTableRowEditor(Object aliasObject, HashMap params) {
            this.aliasObject = aliasObject;
            this.myParams = params;
        }

        @Override
        public Void call() throws Exception {
            theLogger.trace(SrLogCategories.LEGACY, "Trying to change the parameters of the Interface");
            InterfaceTableRowNode clientRow = null;
            if (this.aliasObject instanceof AliasObject) {
                AliasObject obj = (AliasObject)this.aliasObject;
                clientRow = (InterfaceTableRowNode)obj.getAdditionalValue();
            } else {
                clientRow = (InterfaceTableRowNode)this.aliasObject;
            }
            InterfaceTableRow row = (InterfaceTableRow)clientRow.getStub();
            row.changeElement(this.myParams);
            return null;
        }
    }
}

