/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.vswitch.IPTableRow;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.IPTableEvent;
import com.sanrad.nms.client.event.IPTableListener;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.types.constants.NetConfigActivityConstant;
import com.sanrad.util.SrEventListenerManager;
import java.rmi.RemoteException;
import java.util.HashMap;

public class IPTableManager
extends ElementManager {
    private static IPTableManager instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer ipTableRowCreatedInformer = new SrEventListenerManager.Informer<IPTableListener, IPTableEvent>(){

        @Override
        public void inform(IPTableListener listener, IPTableEvent event) {
            listener.ipTableRowCreated(event);
        }
    };
    SrEventListenerManager.Informer ipTableRowChangedInformer = new SrEventListenerManager.Informer<IPTableListener, IPTableEvent>(){

        @Override
        public void inform(IPTableListener listener, IPTableEvent event) {
            listener.ipTableRowChanged(event);
        }
    };
    SrEventListenerManager.Informer ipTableRowRemovedInformer = new SrEventListenerManager.Informer<IPTableListener, IPTableEvent>(){

        @Override
        public void inform(IPTableListener listener, IPTableEvent event) {
            listener.ipTableRowRemoved(event);
        }
    };

    private IPTableManager() {
    }

    public static synchronized IPTableManager getInstance() {
        if (instance == null) {
            instance = new IPTableManager();
        }
        return instance;
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        try {
            theLogger.trace(SrLogCategories.LEGACY, "IP Table row created .");
            com.sanrad.nms.server.logic.vswitch.IPTableRow rowStub = (com.sanrad.nms.server.logic.vswitch.IPTableRow)element;
            HashMap map = this.getParameterList(e);
            Object activityStateObj = this.getObjectForParam(map, ClientParameterCode.IP_ACTIVITY_STATE, true);
            Object intrfaceObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.IP_INTERFACE", true);
            Object ipObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.IP_IP", true);
            Object ipMaskObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.IP_IP_MASK", true);
            VSwitch parentObj = (VSwitch)this.getObjectForParam(map, "Missing code - ClientParameterCode.IP_PARENT", true);
            if (activityStateObj == null) {
                activityStateObj = rowStub.getActivity();
            }
            if (intrfaceObj == null) {
                intrfaceObj = rowStub.getInterface();
            }
            if (ipObj == null) {
                ipObj = rowStub.getIPAddress();
            }
            if (ipMaskObj == null) {
                ipMaskObj = rowStub.getIPMask();
            }
            if (parentObj == null) {
                parentObj = rowStub.getParentVSwitch();
            }
            if (activityStateObj instanceof Integer) {
                activityStateObj = NetConfigActivityConstant.getNetConfigState((Integer)activityStateObj).toString();
            }
            String activity = (String)activityStateObj;
            InterfaceTableRow intrfaceStub = (InterfaceTableRow)intrfaceObj;
            String ip = (String)ipObj;
            String ipMask = (String)ipMaskObj;
            IPTableRow row = new IPTableRow(rowStub, parentObj, ip, ipMask, activity, intrfaceStub);
            SystemRootNode.getInstance().putRefAndStub(rowStub, row);
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(parentObj);
            if (node != null) {
                VSwitchNode vswitchNode = (VSwitchNode)node;
                vswitchNode.getIPTable().addElement(row);
                theLogger.trace(SrLogCategories.LEGACY, "Add IP - ", row.getIPAddress(), " to ", ClientLoader.VSWITCH_DISPLAY_STRING, " - ", vswitchNode.getName());
            }
            this.fireIPTableRowCreated(row);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            IPTableManager.onConnectionError("Failed to create IP.");
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "IP Table row removed .");
        com.sanrad.nms.server.logic.vswitch.IPTableRow rowStub = (com.sanrad.nms.server.logic.vswitch.IPTableRow)element;
        IPTableRow row = (IPTableRow)SystemRootNode.getInstance().getRefByStub(rowStub);
        if (row != null) {
            VSwitch vswitch = row.getParentStub();
            VSwitchNode node = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(vswitch);
            if (node != null) {
                node.getIPTable().remove(row);
                this.fireIPTableRowRemoved(row);
            }
        }
        SystemRootNode.getInstance().removeRefAndIdByStub(element);
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "IPTbleManager: IP Table row changed .");
        HashMap params = this.getParameterList(e);
        Object activityState = this.getObjectForParam(params, ClientParameterCode.IP_ACTIVITY_STATE, false);
        if (activityState != null) {
            theLogger.trace(SrLogCategories.LEGACY, "IPTbleManager: IP Table row activity is changed - ", activityState);
            SrTreeNode ipTableRow = SystemRootNode.getInstance().getRefByStub(element);
            if (ipTableRow != null) {
                ((IPTableRow)ipTableRow).setActivity(activityState.toString());
                this.fireActivityStateChanged((IPTableRow)ipTableRow);
            }
        }
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
    }

    public void addIPTableListener(IPTableListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeIPTableListener(IPTableListener listener) {
        this.m_listeners.remove(listener);
    }

    private void fireIPTableRowCreated(IPTableRow row) {
        IPTableEvent event = new IPTableEvent((Object)this, (RemoteObject)row.getStub(), row.getParentStub());
        theLogger.trace(SrLogCategories.LEGACY, "fire event: IP Table row created .");
        this.m_listeners.fireEvent(IPTableListener.class, event, this.ipTableRowCreatedInformer);
    }

    private void fireActivityStateChanged(IPTableRow row) {
        IPTableEvent event = new IPTableEvent((Object)this, (RemoteObject)row.getStub(), row.getParentStub());
        event.setActivity(row.getActivity());
        theLogger.trace(SrLogCategories.LEGACY, "fire event: IP Table row state changed .");
        this.m_listeners.fireEvent(IPTableListener.class, event, this.ipTableRowChangedInformer);
    }

    private void fireIPTableRowRemoved(IPTableRow row) {
        IPTableEvent event = new IPTableEvent((Object)this, (RemoteObject)row.getStub(), row.getParentStub());
        theLogger.trace(SrLogCategories.LEGACY, "fire event: IP Table row removed .");
        this.m_listeners.fireEvent(IPTableListener.class, event, this.ipTableRowRemovedInformer);
    }
}

