/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.vswitch.IPRouteTableRow;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.IPRouteTableEvent;
import com.sanrad.nms.client.event.IPRouteTableListener;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.util.SrEventListenerManager;
import java.rmi.RemoteException;
import java.util.HashMap;

public class IPRouteTableManager
extends ElementManager {
    private static IPRouteTableManager instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer ipRouteTableRowCreatedInformer = new SrEventListenerManager.Informer<IPRouteTableListener, IPRouteTableEvent>(){

        @Override
        public void inform(IPRouteTableListener listener, IPRouteTableEvent event) {
            listener.ipRouteTableRowCreated(event);
        }
    };
    SrEventListenerManager.Informer ipRouteTableRowRemovedInformer = new SrEventListenerManager.Informer<IPRouteTableListener, IPRouteTableEvent>(){

        @Override
        public void inform(IPRouteTableListener listener, IPRouteTableEvent event) {
            listener.ipRouteTableRowRemoved(event);
        }
    };

    private IPRouteTableManager() {
    }

    public static synchronized IPRouteTableManager getInstance() {
        if (instance == null) {
            instance = new IPRouteTableManager();
        }
        return instance;
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        try {
            theLogger.trace(SrLogCategories.LEGACY, "IP Route Table row created .");
            com.sanrad.nms.server.logic.vswitch.IPRouteTableRow rowStub = (com.sanrad.nms.server.logic.vswitch.IPRouteTableRow)element;
            HashMap map = this.getParameterList(e);
            Object destIPAddressObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.IP_ROUTE_DEST_IP_ADDRESS", true);
            Object destIPMaskObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.IP_ROUTE_DEST_IP_MASK", true);
            Object gatewayObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.IP_ROUTE_GATEWAY", true);
            Object intrfaceObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.IP_ROUTE_INTERFACE", true);
            VSwitch parentObj = (VSwitch)this.getObjectForParam(map, "Missing code - ClientParameterCode.IP_ROUTE_PARENT", true);
            if (destIPAddressObj == null) {
                destIPAddressObj = rowStub.getDestIPAdress();
            }
            if (destIPMaskObj == null) {
                destIPMaskObj = rowStub.getDestIPMask();
            }
            if (gatewayObj == null) {
                gatewayObj = rowStub.getGateway();
            }
            if (intrfaceObj == null) {
                intrfaceObj = rowStub.getInterface();
            }
            if (parentObj == null) {
                parentObj = rowStub.getParentVSwitch();
            }
            String destIPAddress = (String)destIPAddressObj;
            String destIPMask = (String)destIPMaskObj;
            String gateway = (String)gatewayObj;
            InterfaceTableRow intrfaceStub = (InterfaceTableRow)intrfaceObj;
            IPRouteTableRow row = new IPRouteTableRow(rowStub, parentObj, destIPAddress, destIPMask, gateway, intrfaceStub);
            SystemRootNode.getInstance().putRefAndStub(rowStub, row);
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(parentObj);
            if (node != null) {
                VSwitchNode vswitchNode = (VSwitchNode)node;
                vswitchNode.getIPRouteTable().addElement(row);
            }
            this.fireIPRouteTableRowCreated(row);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            IPRouteTableManager.onConnectionError();
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "IP Route Table row removed .");
        com.sanrad.nms.server.logic.vswitch.IPRouteTableRow rowStub = (com.sanrad.nms.server.logic.vswitch.IPRouteTableRow)element;
        SrTreeNode row = SystemRootNode.getInstance().getRefByStub(rowStub);
        if (row != null) {
            VSwitch vswitch = ((IPRouteTableRow)row).getParentStub();
            VSwitchNode node = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(vswitch);
            if (node != null) {
                node.getIPRouteTable().remove(row);
                this.fireIPTableRowRemoved((IPRouteTableRow)row);
            }
        }
        SystemRootNode.getInstance().removeRefAndIdByStub(element);
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
    }

    public void addIPRouteTableListener(IPRouteTableListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeIPRouteTableListener(IPRouteTableListener listener) {
        this.m_listeners.remove(listener);
    }

    private void fireIPRouteTableRowCreated(IPRouteTableRow row) {
        IPRouteTableEvent event = new IPRouteTableEvent((Object)this, (RemoteObject)row.getStub(), row.getParentStub());
        theLogger.trace(SrLogCategories.LEGACY, "fire event: IP route row created.");
        this.m_listeners.fireEvent(IPRouteTableListener.class, event, this.ipRouteTableRowCreatedInformer);
    }

    private void fireIPTableRowRemoved(IPRouteTableRow row) {
        IPRouteTableEvent event = new IPRouteTableEvent((Object)this, (RemoteObject)row.getStub(), row.getParentStub());
        theLogger.trace(SrLogCategories.LEGACY, "fire event: IP route row removed.");
        this.m_listeners.fireEvent(IPRouteTableListener.class, event, this.ipRouteTableRowRemovedInformer);
    }
}

