/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.comm.CommunicationEventService;
import com.sanrad.nms.client.comm.CommunicationListener;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.SrMainTreeModel;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.client.event.alarm.PropagatedStateListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.Site;
import java.rmi.RemoteException;
import java.util.HashMap;

public abstract class ElementManager
extends Manager
implements CommunicationListener,
PropagatedStateListener {
    private CommunicationEventService eventService = CommunicationEventService.getInstance();
    private static SrLogger theLogger = SrLogger.getLogger();

    protected ElementManager() {
        this.eventService.addCommunicationListener(this);
        this.eventService.addPropagatedStateListener(this);
    }

    protected abstract Object discoverElement();

    @Override
    public void discoverStarted(CommunicationEvent e) {
    }

    @Override
    public void storageDiscoveryStarted(CommunicationEvent e) {
    }

    @Override
    public void loginSucceed(CommunicationEvent e) {
    }

    @Override
    public void discoverCompleted(CommunicationEvent e) {
    }

    @Override
    public void resetVSwitchStarted(CommunicationEvent e) {
    }

    @Override
    public void alreadyKnownByVSwitch(CommunicationEvent e) {
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        AlarmsManager.getInstance().removeAlarmsOnSource(e.getElement());
    }

    protected boolean alreadyExist(Object element) {
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub((RemoteObject)element);
        if (node != null) {
            theLogger.trace(SrLogCategories.LEGACY, "element ", element.getClass().getName(), " is already exist !");
            theLogger.trace(SrLogCategories.LEGACY, "===========================================================");
            return true;
        }
        return false;
    }

    protected Object getObjectForParam(HashMap params, Object code, boolean isCreate) {
        Object obj = null;
        if (params != null) {
            obj = params.get(code);
        }
        if (obj == null && isCreate) {
            theLogger.trace(SrLogCategories.LEGACY, "parameter ", code, " does not exist in the ", "parameter list,", " the process will take it directly from the stub!");
        }
        return obj;
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
        RemoteObject stub = e.getStub();
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(stub);
        if (node instanceof SrTreeNode) {
            node.setStatus(AlarmsManager.getSeverity(e.getState()));
            SrMainTreeModel.getInstance().notifyNodeChanged(node);
            theLogger.trace(SrLogCategories.LEGACY, "New Status of ", node, " - ", node.getStatus());
        }
    }

    protected ClusterNode getClusterNode(Object stub) {
        return SystemRootNode.getInstance().getClusterNodeOfStub((LogicObject)stub);
    }

    protected boolean isClusterInDiscovery(Object stub) {
        if (stub instanceof Site || !(stub instanceof LogicObject)) {
            return false;
        }
        ClusterNode clusterNode = this.getClusterNode(stub);
        if (clusterNode != null) {
            return clusterNode.isInDiscoveryProcess();
        }
        return false;
    }

    protected HashMap getParameterList(CommunicationEvent e) {
        RemoteObject stub;
        HashMap list = e.getParameterList();
        if (list == null && (stub = e.getElement()) instanceof LogicObject) {
            try {
                list = ((LogicObject)stub).getClientParameterList();
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            }
            catch (IllegalValueException re) {
                theLogger.trace(SrLogCategories.LEGACY, re.getMessage());
            }
        }
        return list;
    }
}

