/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.comm;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.comm.CommunicationErrorEvent;
import com.sanrad.nms.client.comm.CommunicationErrorListener;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.comm.CommunicationListener;
import com.sanrad.nms.client.comm.DataListener;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.ManagersConfigurator;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.log.LogParameterMgr;
import com.sanrad.nms.client.data.login.UsersManager;
import com.sanrad.nms.client.event.SystemEvent;
import com.sanrad.nms.client.event.SystemListener;
import com.sanrad.nms.client.event.alarm.AlarmsEvent;
import com.sanrad.nms.client.event.alarm.AlarmsListener;
import com.sanrad.nms.client.event.alarm.PropagatedStateListener;
import com.sanrad.nms.server.EventType;
import com.sanrad.nms.server.RemoteEvent;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.event.AlarmEvent;
import com.sanrad.nms.server.alarm.event.PropagatedStateEvent;
import com.sanrad.nms.server.logic.ElementEvent;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.user.User;
import com.sanrad.util.SrEventListenerManager;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;

public class CommunicationEventService {
    protected SrEventListenerManager m_listeners = new SrEventListenerManager();
    private static CommunicationEventService theInstance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer eventSynchronizationErrorInformer = new SrEventListenerManager.Informer<CommunicationErrorListener, CommunicationErrorEvent>(){

        @Override
        public void inform(CommunicationErrorListener listener, CommunicationErrorEvent event) {
            listener.eventSynchronizationError(event);
        }
    };
    SrEventListenerManager.Informer configurationErrorInformer = new SrEventListenerManager.Informer<CommunicationErrorListener, CommunicationErrorEvent>(){

        @Override
        public void inform(CommunicationErrorListener listener, CommunicationErrorEvent event) {
            listener.configurationError(event);
        }
    };
    SrEventListenerManager.Informer fatalConfigurationErrorInformer = new SrEventListenerManager.Informer<CommunicationErrorListener, CommunicationErrorEvent>(){

        @Override
        public void inform(CommunicationErrorListener listener, CommunicationErrorEvent event) {
            listener.fatalConfigurationError(event);
        }
    };
    SrEventListenerManager.Informer snmpErrorInformer = new SrEventListenerManager.Informer<CommunicationErrorListener, CommunicationErrorEvent>(){

        @Override
        public void inform(CommunicationErrorListener listener, CommunicationErrorEvent event) {
            listener.snmpError(event);
        }
    };
    SrEventListenerManager.Informer serverWasShutdownInformer = new SrEventListenerManager.Informer<CommunicationErrorListener, CommunicationErrorEvent>(){

        @Override
        public void inform(CommunicationErrorListener listener, CommunicationErrorEvent event) {
            listener.serverWasShutdown(event);
        }
    };
    SrEventListenerManager.Informer alarmOpenedInformer = new SrEventListenerManager.Informer<AlarmsListener, AlarmsEvent>(){

        @Override
        public void inform(AlarmsListener listener, AlarmsEvent event) {
            listener.alarmOpened(event);
        }
    };
    SrEventListenerManager.Informer alarmClosedInformer = new SrEventListenerManager.Informer<AlarmsListener, AlarmsEvent>(){

        @Override
        public void inform(AlarmsListener listener, AlarmsEvent event) {
            listener.alarmClosed(event);
        }
    };
    SrEventListenerManager.Informer alarmChangedInformer = new SrEventListenerManager.Informer<AlarmsListener, AlarmsEvent>(){

        @Override
        public void inform(AlarmsListener listener, AlarmsEvent event) {
            listener.alarmChanged(event);
        }
    };
    SrEventListenerManager.Informer propagatedStateChangedInformer = new SrEventListenerManager.Informer<PropagatedStateListener, com.sanrad.nms.client.event.alarm.PropagatedStateEvent>(){

        @Override
        public void inform(PropagatedStateListener listener, com.sanrad.nms.client.event.alarm.PropagatedStateEvent event) {
            listener.propagatedStateChanged(event);
        }
    };
    SrEventListenerManager.Informer systemDiscoveryCompletedInformer = new SrEventListenerManager.Informer<SystemListener, SystemEvent>(){

        @Override
        public void inform(SystemListener listener, SystemEvent event) {
            listener.systemDiscoveryCompleted(event);
        }
    };
    SrEventListenerManager.RemoteInformer<DataListener, RemoteEvent> theDataReadyInformer = new SrEventListenerManager.RemoteInformer<DataListener, RemoteEvent>(){

        @Override
        public void inform(DataListener aListener, RemoteEvent aEvent) {
            aListener.dataReady(aEvent);
        }
    };

    private CommunicationEventService() {
    }

    public String hashKey() {
        return this.getClass().toString();
    }

    private boolean printEvent(RemoteEvent event) {
        if (event instanceof ElementEvent) {
            ElementEvent e = (ElementEvent)event;
            try {
                if (!(e.getElement() instanceof LogicObject)) {
                    return true;
                }
                System.out.println("EVENT:" + ((GeneralLogicObject)e.getElement()).getClassId() + " " + ((LogicObject)e.getElement()).getCommKeyClassId() + ",    EventType: " + event.getType() + "\n\t" + e.getParameterList());
                System.out.flush();
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
                System.err.flush();
            }
        }
        return true;
    }

    public void fireEvent(RemoteEvent event) throws RemoteException {
        assert (this.printEvent(event));
        EventType eventType = event.getType();
        if (eventType.equals(EventType.ALARM_CHANGED)) {
            this.fireAlarmChangedEvent(event);
        } else if (eventType.equals(EventType.LOG_CONFIG_CHANGED)) {
            this.fireLogPropertiesChanged(event);
        } else if (eventType.equals(EventType.ALARM_CLOSED)) {
            this.fireAlarmClosedEvent(event);
        } else if (eventType.equals(EventType.ALARM_OPENED)) {
            this.fireAlarmOpenedEvent(event);
        } else if (eventType.equals(EventType.CONFIGURATION_ERROR)) {
            this.fireConfigurationErrorEvent(event);
        } else if (eventType.equals(EventType.DISCOVER_COMPLETED)) {
            this.fireDiscoveryCompletedEvent(event);
        } else if (eventType.equals(EventType.ELEMENT_CHANGED)) {
            this.fireElementChangedEvent(event);
        } else if (eventType.equals(EventType.ELEMENT_CREATED)) {
            this.fireElementCreatedEvent(event);
        } else if (eventType.equals(EventType.ELEMENT_REMOVED)) {
            this.fireElementRemovedEvent(event);
        } else if (eventType.equals(EventType.FATAL_CONFIGURATION_ERROR)) {
            this.fireFatalConfigurationErrorEvent(event);
        } else if (eventType.equals(EventType.PROP_STATE_CHANGED)) {
            this.firePropagatedStateChangedEvent(event);
        } else if (eventType.equals(EventType.SNMP_ERROR)) {
            this.fireSNMPErrorEvent(event);
        } else if (eventType.equals(EventType.START_DISCOVERING)) {
            this.fireDiscoveryStartedEvent(event);
        } else if (eventType.equals(EventType.START_MANUAL_DISCOVERING)) {
            this.fireStorageDiscoveryStartedEvent(event);
        } else if (eventType.equals(EventType.START_RESET)) {
            this.fireResetStartedEvent(event);
        } else if (eventType.equals(EventType.DR_DISCOVER_STARTED)) {
            this.fireDRDiscoveryStarted(event);
        } else if (eventType.equals(EventType.DR_DISCOVER_COMPLETED)) {
            this.fireDRDiscoveryCompleted(event);
        } else if (eventType.equals(EventType.SYSTEM_DISCOVER_COMPLETED)) {
            this.fireSystemDiscoveryCompleted(event);
        } else if (eventType.equals(EventType.SERVER_SHUTDOWN)) {
            this.serverWasShutdown((ElementEvent)event);
        } else {
            theLogger.error(SrLogCategories.LEGACY, "CommunicationEventService:: fireEvent() - unknown EventType..." + eventType);
            theLogger.trace(SrLogCategories.LEGACY, "==============================================================");
        }
        this.m_listeners.fireEvent(DataListener.class, event, this.theDataReadyInformer);
    }

    private void fireEventsSynchronizationEvent() {
        CommunicationErrorEvent event = new CommunicationErrorEvent(this);
        this.m_listeners.fireEvent(CommunicationErrorListener.class, event, this.eventSynchronizationErrorInformer);
    }

    private void fireAlarmOpenedEvent(RemoteEvent event) {
        try {
            AlarmEvent e = (AlarmEvent)event;
            theLogger.trace(SrLogCategories.LEGACY, "CommunicationEventService:: Alarm opened. ", e.getAlarm().getMessage());
            AlarmsEvent alarmsEvent = this.createAlarmsEvent(e);
            this.m_listeners.fireEvent(AlarmsListener.class, alarmsEvent, this.alarmOpenedInformer);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, " in fireAlarmOpenedEvent()");
        }
    }

    private void fireAlarmClosedEvent(RemoteEvent event) {
        try {
            AlarmEvent e = (AlarmEvent)event;
            theLogger.trace(SrLogCategories.LEGACY, "CommunicationEventService:: Alarm closed. ", e.getAlarm().getMessage());
            AlarmsEvent alarmsEvent = this.createAlarmsEvent(e);
            this.m_listeners.fireEvent(AlarmsListener.class, alarmsEvent, this.alarmClosedInformer);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re.getMessage(), " in fireAlarmClosedEvent().", re);
        }
    }

    private void fireAlarmChangedEvent(RemoteEvent event) {
        try {
            AlarmEvent e = (AlarmEvent)event;
            theLogger.trace(SrLogCategories.LEGACY, "CommunicationEventService:: Alarm changed. ", e.getAlarm());
            AlarmsEvent alarmsEvent = this.createAlarmsEvent(e);
            this.m_listeners.fireEvent(AlarmsListener.class, alarmsEvent, this.alarmChangedInformer);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, " in fireAlarmChangedEvent()");
        }
    }

    private void fireConfigurationErrorEvent(RemoteEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "CommunicationEventService:: fireConfigurationErrorEvent()");
        CommunicationErrorEvent event = new CommunicationErrorEvent(this);
        try {
            String errMsg = ((ElementEvent)e).getErrorMesaage();
            event.setErrorMessage(errMsg);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
        }
        this.m_listeners.fireEvent(CommunicationErrorListener.class, event, this.configurationErrorInformer);
        theLogger.error(SrLogCategories.LEGACY, event.getErrorMessage());
    }

    private void fireDiscoveryCompletedEvent(RemoteEvent e) {
        try {
            ElementEvent ee = (ElementEvent)e;
            theLogger.trace(SrLogCategories.LEGACY, ee.getElement(), " in ", this.getClass(), "::discoverCompleted()");
            CommunicationEvent event = new CommunicationEvent(this, ee.getElement());
            ElementManager mgr = ManagersConfigurator.getInstance().getManager(event);
            if (mgr != null) {
                mgr.discoverCompleted(event);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re.getMessage(), " in ", this.getClass(), "::discoverCompleted()");
        }
    }

    private void fireElementChangedEvent(RemoteEvent e) {
        try {
            ElementEvent ee = (ElementEvent)e;
            theLogger.trace(SrLogCategories.LEGACY, ee.getElement(), " in ", this.getClass(), "::elementChanged()");
            CommunicationEvent event = new CommunicationEvent(this, ee.getElement());
            event.setParameterList(ee.getParameterList());
            ElementManager mgr = ManagersConfigurator.getInstance().getManager(event);
            if (mgr != null) {
                mgr.elementChanged(event);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re.getMessage(), " in ", this.getClass(), "::elementChanged()", re);
        }
    }

    private void fireElementCreatedEvent(RemoteEvent e) {
        try {
            ElementManager mgr;
            ElementEvent ee = (ElementEvent)e;
            theLogger.trace(SrLogCategories.LEGACY, ee.getElement().getClass(), " in ", this.getClass(), "::elementCreate()");
            CommunicationEvent event = new CommunicationEvent(this, ee.getElement());
            HashMap params = ee.getParameterList();
            if (params != null && !params.isEmpty()) {
                event.setParameterList(params);
            }
            if ((mgr = ManagersConfigurator.getInstance().getManager(event)) != null) {
                mgr.elementCreate(event);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re.getMessage(), " in ", this.getClass(), "::elementCreate()", re);
        }
    }

    private void fireElementRemovedEvent(RemoteEvent e) {
        try {
            ElementEvent ee = (ElementEvent)e;
            theLogger.trace(SrLogCategories.LEGACY, ee.getElement(), " in ", this.getClass(), "::elementRemove()");
            CommunicationEvent event = new CommunicationEvent(this, ee.getElement());
            ElementManager mgr = ManagersConfigurator.getInstance().getManager(event);
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(event.getElement());
            if (mgr != null) {
                mgr.elementRemove(event);
            }
            Manager.removeStubAndId(node);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re.getMessage(), " in ", this.getClass(), "::elementRemove()", re);
        }
    }

    private void fireFatalConfigurationErrorEvent(RemoteEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "CommunicationEventService:: fireFatalConfigurationErrorEvent()");
        CommunicationErrorEvent event = new CommunicationErrorEvent(this);
        try {
            String errMsg = ((ElementEvent)e).getErrorMesaage();
            event.setErrorMessage(errMsg);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
        }
        this.m_listeners.fireEvent(CommunicationErrorListener.class, event, this.fatalConfigurationErrorInformer);
        theLogger.error(SrLogCategories.LEGACY, event.getErrorMessage());
    }

    public void fireLoginSucceedEvent(User aUser) {
        theLogger.trace(SrLogCategories.LEGACY, "CommunicationEventService:: fireLoginSucceedEvent()");
        CommunicationEvent event = new CommunicationEvent(this, aUser);
        UsersManager.getInstance().loginSucceed(event);
    }

    private void firePropagatedStateChangedEvent(RemoteEvent e) {
        try {
            PropagatedStateEvent pse = (PropagatedStateEvent)e;
            GeneralLogicObject source = pse.getSourceObject();
            AlarmSeverity state = pse.getState();
            theLogger.trace(SrLogCategories.LEGACY, "CommunicationEventService:: PropogatedStateChange. ", source, " ", state);
            com.sanrad.nms.client.event.alarm.PropagatedStateEvent event = new com.sanrad.nms.client.event.alarm.PropagatedStateEvent((Object)this, (RemoteObject)source, state);
            this.m_listeners.fireEvent(PropagatedStateListener.class, event, this.propagatedStateChangedInformer);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re.getMessage(), " in ", this.getClass(), "::propagatedStateChanged()", re);
        }
    }

    private void fireResetStartedEvent(RemoteEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "CommunicationEventService:: fireResetStartedEvent()");
        try {
            CommunicationEvent event = new CommunicationEvent(this, ((ElementEvent)e).getElement());
            ElementManager mgr = ManagersConfigurator.getInstance().getManager(event);
            if (mgr != null) {
                mgr.resetVSwitchStarted(event);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re.getMessage(), " in ", this.getClass(), "::startReset()", re);
        }
    }

    private void fireStorageDiscoveryStartedEvent(RemoteEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "CommunicationEventService:: fireStorageDiscoveryStartedEvent()");
        try {
            CommunicationEvent event = new CommunicationEvent(this, ((ElementEvent)e).getElement());
            ElementManager mgr = ManagersConfigurator.getInstance().getManager(event);
            if (mgr != null) {
                mgr.storageDiscoveryStarted(event);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re.getMessage(), " in ", this.getClass(), "::startStorageDiscovering()", re);
        }
    }

    private void fireDiscoveryStartedEvent(RemoteEvent e) {
        try {
            ElementEvent ee = (ElementEvent)e;
            theLogger.trace(SrLogCategories.LEGACY, ee.getElement(), " in ", this.getClass(), "::discoverStarted()");
            CommunicationEvent event = new CommunicationEvent(this, ee.getElement());
            ElementManager mgr = ManagersConfigurator.getInstance().getManager(event);
            if (mgr != null) {
                mgr.discoverStarted(event);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re.getMessage(), " in ", this.getClass(), "::discoverCompleted()", re);
        }
    }

    private void fireSNMPErrorEvent(RemoteEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "CommunicationEventService:: fireSNMPErrorEvent()");
        CommunicationErrorEvent event = new CommunicationErrorEvent(this);
        try {
            String errMsg = ((ElementEvent)e).getErrorMesaage();
            event.setErrorMessage(errMsg);
            this.m_listeners.fireEvent(CommunicationErrorListener.class, event, this.snmpErrorInformer);
            theLogger.error(SrLogCategories.LEGACY, event.getErrorMessage());
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
        }
    }

    private void fireDRDiscoveryStarted(RemoteEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "CommunicationEventService:: fireDRDiscoveryStarted()");
        DRManager.getInstance().drDiscoveryStarted();
    }

    private void fireDRDiscoveryCompleted(RemoteEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "CommunicationEventService:: fireDRDiscoveryCompleted()");
        DRManager.getInstance().drDiscoveryCompleted();
    }

    private void fireSystemDiscoveryCompleted(RemoteEvent e) throws RemoteException {
        SystemEvent event = new SystemEvent(e.getSource());
        this.m_listeners.fireEvent(SystemListener.class, event, this.systemDiscoveryCompletedInformer);
    }

    private void fireLogPropertiesChanged(RemoteEvent e) {
        LogParameterMgr.getInstance().handleLogConfigChangeEvent(e);
    }

    public synchronized void addCommunicationListener(CommunicationListener listener) {
        this.m_listeners.add(listener);
    }

    public synchronized void removeCommunicationListener(CommunicationListener listener) {
        this.m_listeners.remove(listener);
    }

    public synchronized void addAlarmsListener(AlarmsListener listener) {
        this.m_listeners.add(listener);
    }

    public synchronized void removeAlarmsListener(AlarmsListener listener) {
        this.m_listeners.remove(listener);
    }

    public synchronized void addPropagatedStateListener(PropagatedStateListener listener) {
        this.m_listeners.add(listener);
    }

    public synchronized void removePropagatedStateListener(PropagatedStateListener listener) {
        this.m_listeners.remove(listener);
    }

    public void addCommunicationErrorListener(CommunicationErrorListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeCommunicationErrorListener(CommunicationErrorListener listener) {
        this.m_listeners.remove(listener);
    }

    public void addSystemListener(SystemListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeSystemListener(SystemListener listener) {
        this.m_listeners.remove(listener);
    }

    public synchronized void addDataListener(DataListener listener) {
        this.m_listeners.add(listener);
    }

    public synchronized void removeDataListener(DataListener listener) {
        this.m_listeners.remove(listener);
    }

    public static synchronized CommunicationEventService getInstance() {
        if (theInstance == null) {
            theInstance = new CommunicationEventService();
        }
        return theInstance;
    }

    public void connectionTimeOut(ElementEvent e) {
        theLogger.trace(SrLogCategories.LEGACY, "connection timeout");
    }

    public void alreadyKnownByVSwitch(ElementEvent e) {
    }

    @Deprecated
    public void fireElementRemoveFromVSwitch(ElementEvent e) throws RemoteException {
    }

    private AlarmsEvent createAlarmsEvent(AlarmEvent e) throws RemoteException {
        Alarm stub = e.getAlarm();
        HashMap params = e.getParameterList();
        GeneralLogicObject sourceStub = e.getSourceObject();
        AlarmsEvent event = new AlarmsEvent(this, stub, params, sourceStub);
        return event;
    }

    public void checkConnectivity() throws RemoteException {
    }

    public void serverWasShutdown(ElementEvent e) {
        CommunicationErrorEvent event = new CommunicationErrorEvent(this);
        Date time = new Date(System.currentTimeMillis());
        event.setErrorMessage(ClientLoader.PRODUCT_NAME + " Server (host: " + ClientLoader.getHostname() + ") was shutdown at:\n" + time);
        this.m_listeners.fireEvent(CommunicationErrorListener.class, event, this.serverWasShutdownInformer);
        theLogger.error(SrLogCategories.LEGACY, event.getErrorMessage());
    }
}

