/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.comm;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.SrSocketFactory;
import com.sanrad.nms.server.alarm.AlarmMgr;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.SystemRoot;
import com.sanrad.nms.server.logic.VSwitchGroup;
import com.sanrad.nms.server.logic.acl.PolicyManager;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.storage.Storage;
import com.sanrad.nms.server.user.UserManager;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;

public class Communication {
    private static SrLogger theLogger;
    private static Communication theInstance;
    private SystemRoot systemRootStub = null;
    private UserManager userManager = null;
    private AlarmMgr alarmMgr = null;
    private AlarmMgr DrAlarmMgr = null;

    private Communication() {
    }

    public static synchronized Communication getInstance() {
        if (theInstance == null) {
            theInstance = new Communication();
        }
        return theInstance;
    }

    public SystemRoot getSystemRootStub() {
        if (this.systemRootStub == null) {
            try {
                this.setSystemRootStub();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.systemRootStub;
    }

    private void initLogger() {
        theLogger = SrLogger.getLogger();
    }

    private void setSystemRootStub() throws Exception {
        this.initLogger();
        try {
            this.systemRootStub = this.userManager.getSystemRoot();
        }
        catch (RemoteException re) {
            theLogger.fatal(SrLogCategories.LEGACY, re.getMessage(), " in ", this.getClass(), "::getClusterStub()", re);
        }
    }

    public ArrayList getClusterStubs() {
        ArrayList<VSwitchGroup> clusters = new ArrayList<VSwitchGroup>();
        try {
            SystemRoot systemRoot = this.getSystemRootStub();
            ArrayList groups = systemRoot.getVSwitchGroups();
            int i = groups.size();
            while (i-- > 0) {
                VSwitchGroup group = (VSwitchGroup)groups.get(i);
                if (group instanceof Cluster) {
                    clusters.add(group);
                    continue;
                }
                if (!(group instanceof Site)) continue;
                clusters.addAll(((Site)group).getClusters());
            }
        }
        catch (RemoteException re) {
            theLogger.fatal(SrLogCategories.LEGACY, re, re.getMessage(), " in ", this.getClass(), "::getClusterStub()");
        }
        return clusters;
    }

    public AlarmMgr getAlarmManager() {
        this.initLogger();
        try {
            if (this.alarmMgr == null) {
                this.alarmMgr = this.userManager.getAlarmMgr();
            }
            return this.alarmMgr;
        }
        catch (RemoteException re) {
            theLogger.fatal(SrLogCategories.LEGACY, re.getMessage(), " in ", this.getClass(), "::getAlarmManager()", re);
            return null;
        }
    }

    public AlarmMgr getDrAlarmManager() {
        this.initLogger();
        try {
            if (this.DrAlarmMgr == null) {
                this.DrAlarmMgr = this.userManager.getDrAlarmMgr();
            }
            return this.DrAlarmMgr;
        }
        catch (RemoteException re) {
            theLogger.fatal(SrLogCategories.LEGACY, re.getMessage(), " in ", this.getClass(), "::getAlarmManager()", re);
            return null;
        }
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public UserManager getUserManager(String hostIp, int port) throws RemoteException, NotBoundException {
        try {
            if (this.userManager == null) {
                Registry registry = LocateRegistry.getRegistry(hostIp, port, new SrSocketFactory(hostIp));
                this.userManager = this.lookupForUserManager(registry, "UserManager");
            }
            return this.userManager;
        }
        catch (NotBoundException nbe) {
            System.err.println("Connection to host " + hostIp + " on port " + port + " was refused.");
            nbe.printStackTrace();
            throw nbe;
        }
        catch (RemoteException re) {
            System.err.println("Connection to host " + hostIp + " on port " + port + " was refused.");
            re.printStackTrace();
            throw re;
        }
    }

    private UserManager lookupForUserManager(Registry registry, String serverObjectName) throws NotBoundException, RemoteException {
        int[] retries = new int[]{1000, 1000, 1000, 1000};
        NotBoundException exception = null;
        for (int i = 0; i < retries.length; ++i) {
            try {
                return (UserManager)registry.lookup(serverObjectName);
            }
            catch (NotBoundException e) {
                exception = e;
                try {
                    Thread.sleep(retries[i]);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                continue;
            }
        }
        throw exception;
    }

    public PolicyManager getPolicyManager(Object clusterStub) {
        this.initLogger();
        try {
            return ((Cluster)clusterStub).getPolicyManager();
        }
        catch (RemoteException re) {
            theLogger.fatal(SrLogCategories.LEGACY, re.getMessage(), " in ", this.getClass(), "::getPolicyManager()", re);
            return null;
        }
    }

    public Storage getStorageStub(Object clusterStub) {
        this.initLogger();
        try {
            return ((Cluster)clusterStub).getStorage();
        }
        catch (RemoteException re) {
            theLogger.fatal(SrLogCategories.LEGACY, re.getMessage(), " in ", this.getClass(), "::getStorageStub()", re);
            return null;
        }
    }

    public void clearConnection() {
        this.userManager = null;
        this.systemRootStub = null;
        this.userManager = null;
        this.alarmMgr = null;
        this.DrAlarmMgr = null;
    }

    static {
        theInstance = null;
    }
}

