/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.activeobject;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAO_AG;
import com.sanrad.nms.client.activeobject.ServerListener;
import com.sanrad.nms.client.comm.Communication;
import com.sanrad.nms.client.comm.CommunicationEventService;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.SrConfigurationDiscoverer;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.log.LogParameterMgr;
import com.sanrad.nms.client.data.login.UsersManager;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.server.EventType;
import com.sanrad.nms.server.RemoteEvent;
import com.sanrad.nms.server.SrSocketFactory;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.ServerConnectionMgr;
import com.sanrad.nms.server.logic.ServerEventsListener;
import com.sanrad.nms.server.logic.ServerFacade;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.user.User;
import com.sanrad.nms.server.user.UserManager;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.NetConfigActivityConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import com.sanrad.security.StringCodec;
import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.IFuture;
import com.sanrad.util.concurrent.SrExecutionException;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.Timer;

public class ClientAOImpl
extends ClientAO_AG {
    private static final int FOLLOW_UP_DELAY_PATCH = 3000;
    private ServerFacade myFacade;
    private ServerListener myListener;
    private static SrLogger theLogger = SrLogger.getLogger();
    private static ClientAOImpl theInstance = null;
    private static final String UTIL_LOG_PROPERTY_NAME = "log4j.logger.com.sanrad.util";
    private static final String ACTIONS_LOG_PROPERTY_NAME = "log4j.logger.com.sanrad.swing.actions";
    private static final int RMI_WATCHDOG_DELAY = 3600000;

    public static ClientAOImpl getInstance() {
        if (theInstance == null) {
            throw new IllegalStateException("Pre-login or post-logout ClientAOImpl.getInstance() invocation");
        }
        return theInstance;
    }

    public static SrFuture<Void> init(String aUserName, String aPassword, String aHost, int aPort) {
        return new ClientAOImpl().login(aUserName, aPassword, aHost, aPort);
    }

    private ClientAOImpl() {
    }

    private void commonCallback(SrFuture<?> aControlFuture, Collection<? extends IFuture> futures, boolean aIsUseLog) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>(futures.size());
        HashSet<String> messages = new HashSet<String>(futures.size());
        for (IFuture iFuture : futures) {
            String description = "unknown future";
            try {
                description = iFuture.getDescription();
                iFuture.get();
            }
            catch (SrExecutionException e) {
                Set<Throwable> causes = e.getCauses();
                if (causes.isEmpty()) {
                    this.addNewCause(errors, e, messages);
                }
                for (Throwable cause : causes) {
                    if (aIsUseLog) {
                        if (cause instanceof RuntimeException || cause instanceof IllegalValueException) {
                            theLogger.warn(SrLogCategories.EXCEPTION, cause);
                        } else {
                            theLogger.error(SrLogCategories.EXCEPTION, cause, new Object[0]);
                        }
                    } else {
                        System.err.println("There was a problem during the execution of " + description);
                    }
                    this.addNewCause(errors, cause, messages);
                }
            }
            catch (InterruptedException ie) {
                if (aIsUseLog) {
                    theLogger.logAndAssert(SrLogCategories.EXCEPTION, ie);
                    continue;
                }
                System.err.println(description + " was interrupted.");
                ie.printStackTrace();
            }
            catch (RemoteException re) {
                re.printStackTrace();
                Manager.onConnectionError();
            }
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                aControlFuture.setException((Throwable)errors.get(0));
            } else {
                aControlFuture.setException(new SrExecutionException(errors));
            }
        }
    }

    private void addNewCause(ArrayList<Throwable> errors, Throwable cause, Set<String> messages) {
        if (!messages.contains(cause.getMessage())) {
            errors.add(cause);
            messages.add(cause.getMessage());
        }
    }

    @Override
    protected Void __default_callback(final SrFuture<Void> aControlFuture, final Collection<? extends IFuture<?>> futures, final boolean aIsUseLog) {
        EventDispatcherTask.submit(new Runnable(){

            @Override
            public void run() {
                ClientAOImpl.this.commonCallback(aControlFuture, futures, aIsUseLog);
                if (!aControlFuture.isDone()) {
                    aControlFuture.set(null);
                }
            }
        });
        return null;
    }

    private void handleFutures(SrFuture<Void> aFutureToFill, Collection<? extends IFuture<?>> aFuturesToWait) {
        this.handleFutures(aFutureToFill, aFuturesToWait, true);
    }

    private void handleFutures(final SrFuture<Void> aFutureToFill, final Collection<? extends IFuture<?>> aFuturesToWait, final boolean aIsUseLog) {
        assert (ClientAOImpl.logFutures(aFutureToFill, aFuturesToWait));
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                ClientAOImpl.this.default_callback(aFutureToFill, aFuturesToWait, aIsUseLog);
            }
        }, aFuturesToWait);
    }

    private static boolean logFutures(SrFuture<Void> aFutureToFill, Collection<? extends IFuture<?>> aFuturesToWait) {
        ArrayList<String> descriptions = new ArrayList<String>(aFuturesToWait.size());
        for (IFuture<?> f : aFuturesToWait) {
            try {
                descriptions.add(f.getDescription());
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        theLogger.info(SrLogCategories.INFORMATIVE, aFutureToFill.getDescription(), " waits for ", descriptions);
        return true;
    }

    @Override
    protected void __abortCopyOperations(SrFuture<Void> aFuture, Collection<CommKeyClassId> aOperations) throws RemoteException {
        ArrayList<IFuture<Void>> futuresToWait = new ArrayList<IFuture<Void>>(aOperations.size());
        for (CommKeyClassId operation : aOperations) {
            futuresToWait.add(this.myFacade.abortOperation(operation));
        }
        this.handleFutures(aFuture, futuresToWait);
    }

    @Override
    protected void __acknowledgeAlarms(SrFuture<Void> aFuture, List<String> aAlarms, long aPeriod) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.acknowledgeAlarms(aAlarms, aPeriod, UsersManager.getInstance().getCurrentUserName())));
    }

    @Override
    protected void __activateStatistics(SrFuture<Void> aFuture, CommKeyClassId aStatistics, CommKeyClassId aVSwitch) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.startStatisticsPolling(aVSwitch, aStatistics.getClassID())));
    }

    @Override
    protected void __deactivateStatistics(SrFuture<Void> aFuture, CommKeyClassId aStatistics, CommKeyClassId aVSwitch) throws RemoteException, IllegalValueException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.stopStatisticsPolling(aVSwitch, aStatistics.getClassID())));
    }

    @Override
    protected void __addCluster(SrFuture<Void> aFuture, String aAlias, CommKeyClassId aSite) throws RemoteException, IllegalValueException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createCluster(aSite, aAlias)));
    }

    @Override
    protected void __addMirror(SrFuture<Void> aFuture, CommKeyClassId aOldChild, CommKeyClassId aNewChild, String aAlias, boolean aIsAutoSync) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.addMirror(aOldChild, aNewChild, aAlias, aIsAutoSync)));
    }

    @Override
    protected void __addNewISNSServer(SrFuture<Void> aFuture, CommKeyClassId aCluster, String aServerIp) throws RemoteException, IllegalValueException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createISNSServer(aCluster, aServerIp)));
    }

    @Override
    protected void __addNewRadiusServer(SrFuture<Void> aFuture, CommKeyClassId aCluster, String aServerIp, String aPort, String aKey) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createRadiusServer(aCluster, aServerIp, aPort, aKey)));
    }

    @Override
    protected void __changeElements(SrFuture<Void> aFuture, Collection<? extends Object> aElements, HashMap aProperties) throws RemoteException {
        ArrayList<IFuture<Void>> futuresToWait = new ArrayList<IFuture<Void>>(aElements.size());
        for (Object object : aElements) {
            if (object instanceof CommKeyClassId) {
                futuresToWait.add(this.myFacade.changeElement((CommKeyClassId)object, aProperties));
                continue;
            }
            if (object instanceof String) {
                futuresToWait.add(this.myFacade.changeElement((String)object, aProperties));
                continue;
            }
            throw new IllegalArgumentException("Unsupported class of edited object: " + object.getClass());
        }
        this.handleFutures(aFuture, futuresToWait);
    }

    @Override
    protected void __changePassword(SrFuture<Void> aFuture, String aOldPassword, String aNewPassword) throws RemoteException {
        User loggedUser = UsersManager.getInstance().getCurrentUser();
        if (loggedUser == null) {
            throw new IllegalStateException("Could not find the logged user.");
        }
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.changePassword(loggedUser.hashKey(), aOldPassword, aNewPassword)));
    }

    @Override
    protected void __silentAlarms(SrFuture<Void> aFuture, List<String> aAlarms) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.silentAlarms(aAlarms)));
    }

    @Override
    protected void __setEmailEnabledAlarmTypes(SrFuture<Void> aFuture, List aEnabledAlarmTypes, List aDisabledAlarmTypes) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.setEmailEnabledAlarmTypes(aEnabledAlarmTypes, aDisabledAlarmTypes)));
    }

    @Override
    protected void __createCHAPCredentials(SrFuture<Void> aFuture, CommKeyClassId aIdentity, String aUserName, String aPassword, boolean aIsRadiusEnabled) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createCHAPCredentials(aIdentity, aUserName, aPassword, aIsRadiusEnabled)));
    }

    @Override
    protected void __createConcatinationVolume(SrFuture<Void> aFuture, String aStorage, String aAlias, CommKeyClassId[] aChildren) throws RemoteException, IllegalValueException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createConcatinationVolume(aStorage, aAlias, aChildren)));
    }

    @Override
    protected void __createGeneralFiberChannelDevice(SrFuture<Void> aFuture, String aStorage, PhysicalStorageTypeConstant aType, String aAlias, byte[] aTargetName, int aLun, String aSerialNumber) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createGeneralFiberChannelDevice(aStorage, aType, aAlias, aTargetName, aLun, aSerialNumber)));
    }

    @Override
    protected void __createIdentity(SrFuture<Void> aFuture, CommKeyClassId aCluster, String aAlias, String aDescription) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createIdentity(aCluster, aAlias, aDescription)));
    }

    @Override
    protected void __createIdentityName(SrFuture<Void> aFuture, CommKeyClassId aIdentity, String aName) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createIdentityName(aIdentity, aName)));
    }

    @Override
    protected void __createIPRouteTableRow(SrFuture<Void> aFuture, Collection<CommKeyClassId> aSwitchIds, String aDestIP, String aDestMask, String aGateway, String aInterfaceName) throws RemoteException {
        ArrayList<IFuture<Void>> futuresToWait = new ArrayList<IFuture<Void>>(aSwitchIds.size());
        for (CommKeyClassId vSwitchId : aSwitchIds) {
            futuresToWait.add(this.myFacade.createIPRouteTableRow(vSwitchId, aDestIP, aDestMask, aGateway, aInterfaceName));
        }
        this.handleFutures(aFuture, futuresToWait);
    }

    @Override
    protected void __createIPTableRow(SrFuture<Void> aFuture, Collection<CommKeyClassId> aSwitchIds, String aIP, String aMask, String aActivity, String aInterfaceName) throws RemoteException {
        ArrayList<IFuture<Void>> futuresToWait = new ArrayList<IFuture<Void>>(aSwitchIds.size());
        boolean isFirst = true;
        for (CommKeyClassId switchId : aSwitchIds) {
            String activityOnVSwitch = aActivity;
            theLogger.logAndAssert(SrLogCategories.ERROR, aSwitchIds.size() < 3, new Object[]{"There are more than 2 VSs, therefore the toggeling of the active state produces a bug"});
            if (!isFirst) {
                activityOnVSwitch = aActivity.equals(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_INACTIVE.toString()) ? NetConfigActivityConstant.NET_CONFIG_ACTIVITY_ACTIVE.toString() : NetConfigActivityConstant.NET_CONFIG_ACTIVITY_INACTIVE.toString();
            }
            futuresToWait.add(this.myFacade.createIPTableRow(switchId, aIP, aMask, activityOnVSwitch, aInterfaceName));
            isFirst = false;
        }
        this.handleFutures(aFuture, futuresToWait);
    }

    @Override
    protected void __createGeneralISCSIDevice(SrFuture<Void> aFuture, String aStorage, PhysicalStorageTypeConstant aType, String aAlias, String aTarget, int aLun, String aSerialNumber) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createGeneralISCSIDevice(aStorage, aType, aAlias, aTarget, aLun, aSerialNumber)));
    }

    @Override
    protected void __createRemoteDiscoveryPortal(SrFuture<Void> aFuture, CommKeyClassId aCluster, String aIpAddress, Integer aPort) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createRemoteDiscoveryPortal(aCluster, aIpAddress, aPort)));
    }

    @Override
    protected void __createISCSIRemoteTarget(SrFuture<Void> aFuture, String aStorage, String aRemoteTargetName, String aRemoteTargetAlias) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createISCSIRemoteTarget(aStorage, aRemoteTargetName, aRemoteTargetAlias)));
    }

    @Override
    protected void __createISCSIRemoteTargetPortal(SrFuture<Void> aFuture, CommKeyClassId aISCSIRemoteTarget, String aIp, int aPort, int aPortalGroupTag) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createISCSIRemoteTargetPortal(aISCSIRemoteTarget, aIp, aPort, aPortalGroupTag)));
    }

    @Override
    protected void __createISCSITarget(SrFuture<Void> aFuture, String aStorage, String aName, String aAlias, Permission aDefaultAccess, String aVS) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createISCSITarget(aStorage, aName, aAlias, aDefaultAccess, aVS)));
    }

    @Override
    protected void __createJournalVolume(SrFuture<Void> aFuture, String aStorage, String aAlias, Integer aThreshold, CommKeyClassId aVolumeNodeChildId, CommKeyClassId aActiveOnVswitchId) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createJournalVolume(aStorage, aAlias, aThreshold, aVolumeNodeChildId, aActiveOnVswitchId)));
    }

    @Override
    protected void __createMirrorVolume(SrFuture<Void> aFuture, String aStorage, String aVolAlias, CommKeyClassId[] aChildrenCommKeyClassId) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createMirrorVolume(aStorage, aVolAlias, aChildrenCommKeyClassId)));
    }

    @Override
    protected void __createPortalTableRow(SrFuture<Void> aFuture, Collection<CommKeyClassId> aVSwitches, String aIP, int aPort) throws RemoteException {
        ArrayList<IFuture<Void>> futuresToWait = new ArrayList<IFuture<Void>>(aVSwitches.size());
        for (CommKeyClassId vSwitch : aVSwitches) {
            futuresToWait.add(this.myFacade.createPortalTableRow(vSwitch, aIP, aPort));
        }
        this.handleFutures(aFuture, futuresToWait);
    }

    @Override
    protected void __createGeneralParallelSCSIDevice(SrFuture<Void> aFuture, String aStorage, PhysicalStorageTypeConstant aType, String aAlias, int aPort, int aBus, int aLun, String aSerialNumber) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createGeneralParallelSCSIDevice(aStorage, aType, aAlias, aPort, aBus, aLun, aSerialNumber)));
    }

    @Override
    protected void __createSnapshotVolume(SrFuture<Void> aFuture, String aStorage, String aVolAlias, CommKeyClassId aSourceVolume, CommKeyClassId aChildCKCI, int aThreshold) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createSnapshotVolume(aStorage, aVolAlias, aSourceVolume, aChildCKCI, aThreshold)));
    }

    @Override
    protected void __createSRPCredentials(SrFuture<Void> aFuture, CommKeyClassId aIdentity, String aName, String aPassword) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createSRPCredentials(aIdentity, aName, aPassword)));
    }

    @Override
    protected void __createStripeVolume(SrFuture<Void> aFuture, String aStorage, String aVolAlias, CommKeyClassId[] aChildrenCommKeyClassId, BigInteger aStripeSize) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createStripeVolume(aStorage, aVolAlias, aChildrenCommKeyClassId, aStripeSize)));
    }

    @Override
    protected void __createSubDirectAccessDevice(SrFuture<Void> aFuture, CommKeyClassId aDirectAccessDevice, String aAlias, BigInteger aStartAddr, BigInteger aSize) throws RemoteException {
        IFuture<Void> futureToWait = aStartAddr != null ? this.myFacade.createSubDirectAccessDevice(aDirectAccessDevice, aAlias, aStartAddr, aSize) : (aSize != null ? this.myFacade.createSubDirectAccessDevice(aDirectAccessDevice, aAlias, aSize) : this.myFacade.createSubDirectAccessDevice(aDirectAccessDevice, aAlias));
        this.handleFutures(aFuture, Collections.singleton(futureToWait));
    }

    @Override
    protected void __createTransparentVolume(SrFuture<Void> aFuture, String aStorage, String aVolAlias, CommKeyClassId aChildCommKeyClassId) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createTransparentVolume(aStorage, aVolAlias, aChildCommKeyClassId)));
    }

    @Override
    protected void __deleteObjects(SrFuture<Void> aFuture, Collection<Object> aObjectsToDelete) throws RemoteException {
        if (aObjectsToDelete == null || aObjectsToDelete.contains(null)) {
            String value = aObjectsToDelete == null ? null : aObjectsToDelete.toString();
            String msg = "The given parameter shouldn't be or contains null: aObjectsToDelete = " + value;
            theLogger.error(SrLogCategories.ILLEGAL_STATE, msg);
            throw new IllegalArgumentException(msg);
        }
        ArrayList<IFuture<Void>> futures = new ArrayList<IFuture<Void>>(aObjectsToDelete.size());
        for (Object object : aObjectsToDelete) {
            if (object instanceof CommKeyClassId) {
                futures.add(this.myFacade.deleteElement((CommKeyClassId)object));
                continue;
            }
            if (object instanceof String) {
                futures.add(this.myFacade.deleteElement((String)object));
                continue;
            }
            throw new IllegalArgumentException("Unsupported class of deleted object: " + object.getClass());
        }
        this.handleFutures(aFuture, futures);
    }

    @Override
    protected void __restartOperation(SrFuture<Void> aFuture, Collection<CommKeyClassId> aCopyOperations) throws RemoteException {
        ArrayList<IFuture<Void>> futures = new ArrayList<IFuture<Void>>(aCopyOperations.size());
        for (CommKeyClassId copyOperation : aCopyOperations) {
            futures.add(this.myFacade.restartOperation(copyOperation));
        }
        this.handleFutures(aFuture, futures);
    }

    @Override
    protected void __rediscover(SrFuture<Void> aFuture, CommKeyClassId aSwitchOrGroup) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.rediscover(aSwitchOrGroup)));
    }

    @Override
    protected void __manualDiscover(SrFuture<Void> aFuture, CommKeyClassId aCluster) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.manualDiscover(aCluster)));
    }

    @Override
    protected void __abortOperations(SrFuture<Void> aFuture, Collection<CommKeyClassId> aCopyOperations) throws RemoteException {
        ArrayList<IFuture<Void>> futuresToWait = new ArrayList<IFuture<Void>>(aCopyOperations.size());
        for (CommKeyClassId copyOperation : aCopyOperations) {
            futuresToWait.add(this.myFacade.abortOperation(copyOperation));
        }
        this.handleFutures(aFuture, futuresToWait);
    }

    @Override
    protected void __abortReplicate(SrFuture<Void> aFuture, Collection<? extends Object> aDRActivatesAndSites) throws RemoteException {
        ArrayList<IFuture<Void>> futuresToWait = new ArrayList<IFuture<Void>>(aDRActivatesAndSites.size());
        for (Object object : aDRActivatesAndSites) {
            if (object instanceof CommKeyClassId) {
                futuresToWait.add(this.myFacade.abortReplicate((CommKeyClassId)object));
                continue;
            }
            if (object instanceof String) {
                futuresToWait.add(this.myFacade.abortReplicate((String)object));
                continue;
            }
            throw new IllegalArgumentException("Unsupported class of deleted object: " + object.getClass());
        }
        this.handleFutures(aFuture, futuresToWait);
    }

    @Override
    protected void __activateDeactivateSnapshots(SrFuture<Void> aFuture, String aStorage, CommKeyClassId[] aSnapshots, SnapshotActivateTypeConstants aSnapActivateType) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.activateDeactivateSnapshots(aStorage, aSnapshots, aSnapActivateType)));
    }

    @Override
    protected void __synchronize(SrFuture<Void> aFuture, CommKeyClassId aVSwitchGroup) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.synchronize(aVSwitchGroup)));
    }

    @Override
    protected void __moveToSite(SrFuture<Void> aFuture, CommKeyClassId aCluster, CommKeyClassId aSite) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.moveToSite(aCluster, aSite)));
    }

    @Override
    protected void __clusterSync(SrFuture<Void> aFuture) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.clusterSync()));
    }

    @Override
    protected void __breakMirror(SrFuture<Void> aFuture, CommKeyClassId aMirrorVolume, CommKeyClassId[] aChildren) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.breakMirror(aMirrorVolume, aChildren)));
    }

    @Override
    protected void __expand(SrFuture<Void> aFuture, Collection<CommKeyClassId> aConcatenationOrMirrorVolumes) throws RemoteException {
        ArrayList<IFuture<Void>> futures = new ArrayList<IFuture<Void>>(aConcatenationOrMirrorVolumes.size());
        for (CommKeyClassId concatenationOrMirrorVolume : aConcatenationOrMirrorVolumes) {
            futures.add(this.myFacade.expand(concatenationOrMirrorVolume));
        }
        this.handleFutures(aFuture, futures);
    }

    @Override
    protected void __mirrorSync(SrFuture<Void> aFuture, Collection<CommKeyClassId> aVolumes) throws RemoteException {
        ArrayList<IFuture<Void>> futures = new ArrayList<IFuture<Void>>(aVolumes.size());
        for (CommKeyClassId volume : aVolumes) {
            futures.add(this.myFacade.mirrorSync(volume));
        }
        this.handleFutures(aFuture, futures);
    }

    @Override
    protected void __discoverRemoteTargets(SrFuture<Void> aFuture, String aStorage, CommKeyClassId[] aRemoteDiscoveryPortals) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.discoverRemoteTargets(aStorage, aRemoteDiscoveryPortals)));
    }

    @Override
    protected void __exposeVolume(SrFuture<Void> aFuture, String aStorage, int aLuNumber, CommKeyClassId aVolumeCommKeyClassId, CommKeyClassId aTargetCommKeyClassId, String aSerialNumber) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.exposeVolume(aStorage, aLuNumber, aVolumeCommKeyClassId, aTargetCommKeyClassId, aSerialNumber)));
    }

    @Override
    protected void __offlineCopy(SrFuture<Void> aFuture, CommKeyClassId aSourceVolume, CommKeyClassId aDestinationVolume) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.offlineCopy(aSourceVolume, aDestinationVolume)));
    }

    @Override
    protected void __refreshPercentUtilization(SrFuture<Void> aFuture, CommKeyClassId aJournalVolume) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.refreshPercentUtilization(aJournalVolume)));
    }

    @Override
    protected void __refreshCopyTable(SrFuture<Void> aFuture, String aSourceCopyOperationManager) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.refreshCopyTable(aSourceCopyOperationManager)));
    }

    @Override
    protected void __refreshRemoteDiscoveryPortalsTable(SrFuture<Void> aFuture, Collection<CommKeyClassId> aVSwitches) throws RemoteException {
        ArrayList<IFuture<Void>> futures = new ArrayList<IFuture<Void>>(aVSwitches.size());
        for (CommKeyClassId vSwitch : aVSwitches) {
            futures.add(this.myFacade.refreshRemoteDiscoveryPortalsTable(vSwitch));
        }
        this.handleFutures(aFuture, futures);
    }

    @Override
    protected void __readSnapshotVolumes(SrFuture<Void> aFuture, String aStorage) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.readSnapshotVolumes(aStorage)));
    }

    private static Properties replaceLevel(String aPropName, String aLevel, Properties aProps) {
        String oldVal = aProps.getProperty(aPropName);
        if (oldVal == null || oldVal.equals("")) {
            return aProps;
        }
        String[] propVals = oldVal.split(",");
        StringBuffer newVal = new StringBuffer(aLevel);
        for (int index = 1; index < propVals.length; ++index) {
            newVal.append(",").append(propVals[index]);
        }
        aProps.setProperty(aPropName, newVal.toString());
        return aProps;
    }

    @Override
    protected void __replaceLoggingLevels(SrFuture<Void> aFuture, String aClientPropName, String aClientLevel, String aServerPropName, String aServerLevel) throws RemoteException {
        ArrayList<IFuture<Void>> futuresToWait = new ArrayList<IFuture<Void>>(2);
        Properties newClientProps = ClientAOImpl.replaceLevel(aClientPropName, aClientLevel, LogParameterMgr.getInstance().getClientProps());
        newClientProps = ClientAOImpl.replaceLevel(UTIL_LOG_PROPERTY_NAME, aClientLevel, newClientProps);
        newClientProps = ClientAOImpl.replaceLevel(ACTIONS_LOG_PROPERTY_NAME, aClientLevel, newClientProps);
        futuresToWait.add(this.myFacade.setClientLogProperties(newClientProps));
        SrLogger.reInit(newClientProps);
        Properties newServerProps = ClientAOImpl.replaceLevel(aServerPropName, aServerLevel, LogParameterMgr.getInstance().getServerProps());
        newServerProps = ClientAOImpl.replaceLevel(UTIL_LOG_PROPERTY_NAME, aServerLevel, newServerProps);
        futuresToWait.add(this.myFacade.setServerLogProperties(newServerProps));
        this.handleFutures(aFuture, futuresToWait);
    }

    @Override
    protected void __reloadProperties(SrFuture<Void> aFuture) throws Exception {
        ArrayList<IFuture<Void>> futuresToWait = new ArrayList<IFuture<Void>>(2);
        Properties serverProps = Communication.getInstance().getUserManager().getLogManager().getServerLogProps();
        futuresToWait.add(this.myFacade.setServerLogProperties(serverProps));
        Properties clientProps = Communication.getInstance().getUserManager().getLogManager().getClientLogProps();
        futuresToWait.add(this.myFacade.setClientLogProperties(clientProps));
        this.handleFutures(aFuture, futuresToWait);
    }

    @Override
    protected void __replace(SrFuture<Void> aFuture, CommKeyClassId aOldVolume, CommKeyClassId aNewVolume) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.replace(aOldVolume, aNewVolume)));
    }

    @Override
    protected void __reset(SrFuture<Void> aFuture, Collection<CommKeyClassId> aVSwitches) throws RemoteException {
        ArrayList<IFuture<Void>> futures = new ArrayList<IFuture<Void>>(aVSwitches.size());
        for (CommKeyClassId vSwitch : aVSwitches) {
            futures.add(this.myFacade.reset(vSwitch));
        }
        this.handleFutures(aFuture, futures);
    }

    @Override
    protected void __resize(SrFuture<Void> aFuture, CommKeyClassId aVolumeToResize, CommKeyClassId aVolumeToResizeWith, String aAlias) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.resize(aVolumeToResize, aVolumeToResizeWith, aAlias)));
    }

    @Override
    protected void __restoreSnapshots(SrFuture<Void> aFuture, String aCopyOperationManager, Collection<CommKeyClassId> aSnapshots) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.restoreSnapshots(aCopyOperationManager, aSnapshots.toArray(new CommKeyClassId[aSnapshots.size()]))));
    }

    @Override
    protected void __retract(SrFuture<Void> aFuture, Collection<CommKeyClassId> aConcatenationVolumes) throws RemoteException {
        ArrayList<IFuture<Void>> futures = new ArrayList<IFuture<Void>>(aConcatenationVolumes.size());
        for (CommKeyClassId concatenationVolume : aConcatenationVolumes) {
            futures.add(this.myFacade.retract(concatenationVolume));
        }
        this.handleFutures(aFuture, futures);
    }

    @Override
    protected void __setEmailContactParameters(SrFuture<Void> aFuture, HashMap aParameters) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.setEmailContactParameters(aParameters)));
    }

    @Override
    protected void __shutdown(SrFuture<Void> aFuture, Collection<CommKeyClassId> aVSwitches) throws RemoteException {
        ArrayList<IFuture<Void>> futures = new ArrayList<IFuture<Void>>(aVSwitches.size());
        for (CommKeyClassId vSwitch : aVSwitches) {
            futures.add(this.myFacade.shutdown(vSwitch));
        }
        this.handleFutures(aFuture, futures);
    }

    @Override
    protected void __unacknowledgeAlarms(SrFuture<Void> aFuture, List<String> aAlarms, long aPeriod) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.unacknowledgeAlarms(aAlarms)));
    }

    @Override
    protected void __wakeOnLAN(SrFuture<Void> aFuture, Collection<CommKeyClassId> aVSwitches) throws RemoteException {
        ArrayList<IFuture<Void>> futures = new ArrayList<IFuture<Void>>(aVSwitches.size());
        for (CommKeyClassId vSwitch : aVSwitches) {
            futures.add(this.myFacade.wakeOnLAN(vSwitch));
        }
        this.handleFutures(aFuture, futures);
    }

    @Override
    protected void __removeUsers(SrFuture<Void> aFuture, Vector aUsersList) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.removeUsers(aUsersList)));
    }

    @Override
    protected void __addUser(SrFuture<Void> aFuture, String aUserName, String aPassword) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.addUser(aUserName, aPassword)));
    }

    @Override
    protected void __updateAcl(SrFuture<Void> aFuture, String aACL, Vector aData) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.updateAcl(aACL, aData)));
    }

    @Override
    protected void __abortInitialSync(SrFuture<Void> aFuture, Collection<String> aDRPairs) throws RemoteException {
        ArrayList<IFuture<Void>> futuresToWait = new ArrayList<IFuture<Void>>(aDRPairs.size());
        for (String drPair : aDRPairs) {
            futuresToWait.add(this.myFacade.abortInitialSync(drPair));
        }
        this.handleFutures(aFuture, futuresToWait);
    }

    @Override
    protected void __createAsyncPair(SrFuture<Void> aFuture, DRPairInitialSyncTypeConstant aInitialSyncType, CommKeyClassId aPrimaryId, CommKeyClassId aSecondaryId, String aLocalTarget, Integer aLocalLun, String aRemoteTarget, Integer aRemoteLun, CommKeyClassId aPrimarySnapshotId, CommKeyClassId aSecondarySnapshotId, HashMap aSecondarySnapshotParams, CommKeyClassId aPrimaryJournalId, CommKeyClassId aSecondaryJournalId, String aCG) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createAsyncPair(aInitialSyncType, aPrimaryId, aSecondaryId, aLocalTarget, aLocalLun, aRemoteTarget, aRemoteLun, aPrimarySnapshotId, aSecondarySnapshotId, aSecondarySnapshotParams, aPrimaryJournalId, aSecondaryJournalId, aCG)));
    }

    @Override
    protected void __createAsyncPair(SrFuture<Void> aFuture, DRPairInitialSyncTypeConstant aInitialSyncType, CommKeyClassId aPrimaryId, CommKeyClassId aSecondaryId, String aLocalTarget, Integer aLocalLun, String aRemoteTarget, Integer aRemoteLun, CommKeyClassId aPrimarySnapshotId, CommKeyClassId aSecondarySnapshotId, HashMap aSecondarySnapshotParams, CommKeyClassId aPrimaryJournalId, CommKeyClassId aSecondaryJournalId, String aCgAlias, HashMap aPitPolicy, HashMap aTransferPolicy, HashMap aMergePolicy) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createAsyncPair(aInitialSyncType, aPrimaryId, aSecondaryId, aLocalTarget, aLocalLun, aRemoteTarget, aRemoteLun, aPrimarySnapshotId, aSecondarySnapshotId, aSecondarySnapshotParams, aPrimaryJournalId, aSecondaryJournalId, aCgAlias, aPitPolicy, aTransferPolicy, aMergePolicy)));
    }

    @Override
    protected void __createAsyncPair(SrFuture<Void> aFuture, DRPairInitialSyncTypeConstant aInitialSyncType, CommKeyClassId aPrimaryId, CommKeyClassId aSecondaryId, String aLocalTarget, Integer aLocalLun, String aRemoteTarget, Integer aRemoteLun, CommKeyClassId aPrimarySnapshotId, CommKeyClassId aSecondarySnapshotId, HashMap aSecondarySnapshotParams, CommKeyClassId aPrimaryJournalId, CommKeyClassId aSecondaryJournalId, HashMap aPitPolicy, HashMap aTransferPolicy, HashMap aMergePolicy) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createAsyncPair(aInitialSyncType, aPrimaryId, aSecondaryId, aLocalTarget, aLocalLun, aRemoteTarget, aRemoteLun, aPrimarySnapshotId, aSecondarySnapshotId, aSecondarySnapshotParams, aPrimaryJournalId, aSecondaryJournalId, aPitPolicy, aTransferPolicy, aMergePolicy)));
    }

    @Override
    protected void __createSyncPair(SrFuture<Void> aFuture, DRPairInitialSyncTypeConstant aInitialSyncType, CommKeyClassId aPrimaryId, CommKeyClassId aSecondaryId, String aLocalTarget, Integer aLocalLun, String aRemoteTarget, Integer aRemoteLun) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createSyncPair(aInitialSyncType, aPrimaryId, aSecondaryId, aLocalTarget, aLocalLun, aRemoteTarget, aRemoteLun)));
    }

    @Override
    protected void __endInitialSync(SrFuture<Void> aFuture, Collection<String> aDRAsyncPairNode) throws RemoteException {
        ArrayList<IFuture<Void>> futures = new ArrayList<IFuture<Void>>(aDRAsyncPairNode.size());
        for (String drAsyncPairNode : aDRAsyncPairNode) {
            futures.add(this.myFacade.endInitialSync(drAsyncPairNode));
        }
        this.handleFutures(aFuture, futures);
    }

    @Override
    protected void __exportConfigurationFile(final SrFuture<Void> aFuture, final File aDestinationZIPFile) throws RemoteException {
        final IFuture<Void> futureToWaitFor = this.myFacade.exportConfigurationFile();
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                ClientAOImpl.this.exportConfigurationFile_step2(aFuture, aDestinationZIPFile, futureToWaitFor);
            }
        }, Collections.singleton(futureToWaitFor));
    }

    @Override
    protected Void __exportConfigurationFile_step2(final SrFuture<Void> aFutureToFill, final File aDestinationZIPFile, IFuture<Void> aFutures) throws RemoteException {
        this.commonCallback(aFutureToFill, Collections.singleton(aFutures), true);
        if (aFutureToFill.isDone()) {
            return null;
        }
        StringBuffer serverSideFile = new StringBuffer();
        serverSideFile.append(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SERVER_CONFIG_DIR_NAME));
        serverSideFile.append('\\');
        serverSideFile.append(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.EXPORT_CONFIGURATION_FILE_NAME));
        final IFuture<byte[]> futureToWaitFor = this.myFacade.downloadFile(serverSideFile.toString());
        DefaultFutureListener.listenTo(new Runnable(){

            @Override
            public void run() {
                ClientAOImpl.this.exportConfigurationFileFinished(aFutureToFill, aDestinationZIPFile, futureToWaitFor);
            }
        }, Collections.singleton(futureToWaitFor));
        return null;
    }

    @Override
    protected Void __exportConfigurationFileFinished(SrFuture<Void> aFutureToFill, File aDestinationZIPFile, IFuture<byte[]> aFutureToWait) throws IOException {
        this.commonCallback(aFutureToFill, Collections.singleton(aFutureToWait), true);
        if (aFutureToFill.isDone()) {
            return null;
        }
        try {
            byte[] filedata = aFutureToWait.get();
            aDestinationZIPFile.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(aDestinationZIPFile);
            fileOutputStream.write(filedata);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException e) {
            aFutureToFill.setException(e);
        }
        catch (Exception e) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, e, aFutureToWait.getDescription(), ": get() passed once and failed later");
            aFutureToFill.setException(e);
        }
        aFutureToFill.set(null);
        return null;
    }

    @Override
    protected void __recover(SrFuture<Void> aFuture, String aDRAsyncPair, CommKeyClassId aVolume, CommKeyClassId aSnapshot, CommKeyClassId aJournal) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.recover(aDRAsyncPair, aVolume, aSnapshot, aJournal)));
    }

    @Override
    protected void __recover(SrFuture<Void> aFuture, String aDRSyncPair, CommKeyClassId aVolume) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.recover(aDRSyncPair, aVolume)));
    }

    @Override
    protected void __refreshFields(SrFuture<Void> aFuture, String aGeneralLogicObject, ClientParameterCode[] aCodes) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.refreshFields(Collections.singletonList(aGeneralLogicObject), aCodes)));
    }

    @Override
    protected void __refreshInitialSyncProgress(SrFuture<Void> aFuture, String aDRPair) throws RemoteException {
        if (!DRManager.getInstance().isDRDiscoveryCompleted()) {
            this.handleFutures(aFuture, Collections.singleton(new CompleteFuture("ClientAOImpl.refreshInitialSyncProgress - DR discover in progress")));
        }
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.refreshInitialSyncProgress(aDRPair)));
    }

    @Override
    protected void __refreshPiTs(SrFuture<Void> aFuture, Collection<String> aDRAsyncPairOrCG) throws RemoteException {
        ArrayList<IFuture<Void>> futuresToWait = new ArrayList<IFuture<Void>>(aDRAsyncPairOrCG.size());
        for (String id : aDRAsyncPairOrCG) {
            futuresToWait.add(this.myFacade.refreshPiTs(id));
        }
        this.handleFutures(aFuture, futuresToWait);
    }

    @Override
    protected void __startInitialSync(SrFuture<Void> aFuture, Collection<String> aDRPairs) throws RemoteException {
        ArrayList<IFuture<Void>> futures = new ArrayList<IFuture<Void>>(aDRPairs.size());
        for (String drPair : aDRPairs) {
            futures.add(this.myFacade.startInitialSync(drPair));
        }
        this.handleFutures(aFuture, futures);
    }

    @Override
    protected void __startReplicate(SrFuture<Void> aFuture, Collection<String> aDRActivates) throws RemoteException {
        ArrayList<IFuture<Void>> futures = new ArrayList<IFuture<Void>>(aDRActivates.size());
        for (String drActivate : aDRActivates) {
            futures.add(this.myFacade.startReplicate(drActivate));
        }
        this.handleFutures(aFuture, futures);
    }

    @Override
    protected void __fallback(SrFuture<Void> aFuture, Collection<String> aDRActivates) throws RemoteException {
        ArrayList<IFuture<Void>> futures = new ArrayList<IFuture<Void>>(aDRActivates.size());
        for (String drActivate : aDRActivates) {
            futures.add(this.myFacade.fallback(drActivate));
        }
        this.handleFutures(aFuture, futures);
    }

    @Override
    protected void __disasterOccured(SrFuture<Void> aFuture, Collection<String> aDRActivates) throws RemoteException {
        ArrayList<IFuture<Void>> futures = new ArrayList<IFuture<Void>>(aDRActivates.size());
        for (String drActivate : aDRActivates) {
            futures.add(this.myFacade.disasterOccured(drActivate));
        }
        this.handleFutures(aFuture, futures);
    }

    @Override
    protected void __plannedFailover(SrFuture<Void> aFuture, Collection<String> aDRActivates) throws RemoteException {
        ArrayList<IFuture<Void>> futures = new ArrayList<IFuture<Void>>(aDRActivates.size());
        for (String drActivate : aDRActivates) {
            futures.add(this.myFacade.plannedFailover(drActivate));
        }
        this.handleFutures(aFuture, futures);
    }

    @Override
    protected void __createSite(SrFuture<Void> aFuture, CommKeyClassId aSite, String aAlias) throws RemoteException {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.createSite(aSite, aAlias)));
    }

    @Override
    protected Void __login(String aUserName, String aPassword, String aHost, int aPort) throws Exception {
        try {
            Communication.getInstance().clearConnection();
            UserManager userManager = Communication.getInstance().getUserManager(aHost, aPort);
            Properties logProps = LogParameterMgr.getInstance().getClientProps(aHost, aPort);
            try {
                LogParameterMgr.getInstance().setProps(logProps);
            }
            catch (AccessControlException ace) {
                System.out.println("Failed to set log properties: " + ace.getMessage());
                ace.printStackTrace();
            }
            Properties serverProp = LogParameterMgr.getInstance().getServerProps();
            if (serverProp == null || serverProp.isEmpty()) {
                Properties newProp = userManager.getLogManager().getServerLogProps();
                LogParameterMgr.getInstance().setServerProps(newProp);
            }
            VolumeManager.setMaxSnapshotsPerVolume(userManager.getMaxSnapshotsPerVolume());
            String key = userManager.getCodecKey();
            UsersManager.getInstance().setKey(key);
            String encPassword = StringCodec.encryptString(key, aPassword);
            final User fUser = userManager.loginClient(aUserName, encPassword);
            EventDispatcherTask.submit(new Runnable(){

                @Override
                public void run() {
                    CommunicationEventService.getInstance().fireLoginSucceedEvent(fUser);
                }
            });
            Registry registry = LocateRegistry.getRegistry(aHost, aPort, new SrSocketFactory(aHost));
            ServerConnectionMgr scm = (ServerConnectionMgr)registry.lookup("ServerConnectionMgr");
            this.myListener = new ServerListener();
            this.myFacade = scm.openSession((ServerEventsListener)((Object)UnicastRemoteObject.exportObject(this.myListener)));
            if (this.myFacade == null) {
                throw new IllegalStateException("Returned a null facade from the server on " + aHost + ":" + aPort);
            }
            this.setRmiWatchdog();
            theInstance = this;
            Manager.setConnected();
            return null;
        }
        catch (AccessControlException ace) {
            throw new Exception("Host: " + aHost + "\n" + ace.getMessage(), ace);
        }
    }

    private void setRmiWatchdog() {
        Timer rmiWatchdogTimer = new Timer(3600000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ClientAOImpl.this.myFacade.checkConnectivity();
                }
                catch (RemoteException exp) {
                    theLogger.error(SrLogCategories.EXCEPTION, exp, "The RMI watchdog could not reach the server.");
                }
            }
        });
        rmiWatchdogTimer.setRepeats(true);
        rmiWatchdogTimer.start();
    }

    @Override
    protected void __logout(SrFuture<Void> aFuture) throws RemoteException {
        theInstance = null;
        aFuture.set(null);
    }

    @Override
    protected Void __processEvent(final RemoteEvent aEvent) {
        EventDispatcherTask.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    EventType type = aEvent.getType();
                    theLogger.info(SrLogCategories.INFORMATIVE, "Started executing event ", type);
                    if (!ClientLoader.isClientLoaded() && !type.equals(EventType.SYSTEM_DISCOVER_COMPLETED)) {
                        return;
                    }
                    CommunicationEventService.getInstance().fireEvent(aEvent);
                    theLogger.info(SrLogCategories.INFORMATIVE, "Finished executing event ", type);
                }
                catch (RemoteException e) {
                    theLogger.error(SrLogCategories.LEGACY, e, "Client AO:: RemoteException in running event!!!");
                    Manager.onConnectionError();
                }
            }
        });
        return null;
    }

    public static boolean isUpdatedByServer() {
        return theInstance != null;
    }

    @Override
    protected Void __tryFindConfiguration(final SrConfigurationDiscoverer aConfigurationDiscoverer, final Runnable aRunAfterConfigFound, final List<SrFuture<Void>> aConfigurationFutures, final SrFuture<Void> aFutureToUpdate) throws Exception {
        for (SrFuture<Void> configFuture : aConfigurationFutures) {
            if (configFuture.isDone()) continue;
            theLogger.warn(SrLogCategories.BUG, "__tryFindConfiguration called where aConfigurationFutures are not finished yet. Futures: ", aConfigurationFutures, ". __tryFindConfiguration recalled with FutureListener");
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    ClientAOImpl.this.tryFindConfiguration(0L, aConfigurationDiscoverer, aRunAfterConfigFound, aConfigurationFutures, aFutureToUpdate);
                }
            };
            DefaultFutureListener.listenTo(toRun, aConfigurationFutures);
            return null;
        }
        for (SrFuture<Void> configFuture : aConfigurationFutures) {
            try {
                configFuture.get();
            }
            catch (SrExecutionException e) {
                aFutureToUpdate.setException(e);
                return null;
            }
        }
        aConfigurationDiscoverer.discoverConfiguration();
        if (aConfigurationDiscoverer.isFound()) {
            aRunAfterConfigFound.run();
        } else if (aConfigurationDiscoverer.hasMoreRetries()) {
            this.tryFindConfiguration(3000L, aConfigurationDiscoverer, aRunAfterConfigFound, aConfigurationFutures, aFutureToUpdate);
        } else {
            aFutureToUpdate.setException(new IllegalStateException("Could not complete operation, configuration not found: " + aConfigurationDiscoverer.getConfigurationDescription()));
        }
        return null;
    }

    @Override
    protected void __addClusterVSwitch(SrFuture<Void> aFuture, CommKeyClassId aCluster, String aIpAddr, String aMask, int aSnmpPort, int aTrapPort, String aReadCommunity, String aWriteCommunity, long aTimeout, int aNumOfRetries, SnmpVersion aSnmpVer) throws Exception {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.addClusterVSwitch(aCluster, aIpAddr, aMask, aSnmpPort, aTrapPort, aReadCommunity, aWriteCommunity, aTimeout, aNumOfRetries, aSnmpVer)));
    }

    @Override
    protected void __addVSwitch(SrFuture<Void> aFuture, CommKeyClassId aSite, String aClusterName, String aIpAddr, String aMask, int aSnmpPort, int aTrapPort, String aReadCommunity, String aWriteCommunity, long aTimeout, int aNumOfRetries, SnmpVersion aSnmpVer) throws Exception {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.addVSwitch(aSite, aClusterName, aIpAddr, aMask, aSnmpPort, aTrapPort, aReadCommunity, aWriteCommunity, aTimeout, aNumOfRetries, aSnmpVer)));
    }

    @Override
    protected void __configureElementsTree(SrFuture<Void> aFuture, ClientConfigElementData aCreationData) throws Exception {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.configureElementsTree(aCreationData)));
    }

    @Override
    protected void __suspendPolling(SrFuture<Void> aFuture, PollingGroupType aPollingType) throws Exception {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.suspendPolling(aPollingType)));
    }

    @Override
    protected void __resumePolling(SrFuture<Void> aFuture, PollingGroupType aPollingType) throws Exception {
        this.handleFutures(aFuture, Collections.singleton(this.myFacade.resumePolling(aPollingType)));
    }

    @Override
    protected void __deleteObjectsTree(SrFuture<Void> aFuture, Map<Object, Boolean> aObjectsToDelete) throws Exception {
        ArrayList<IFuture<Void>> futures = new ArrayList<IFuture<Void>>();
        for (Object object : aObjectsToDelete.keySet()) {
            if (object instanceof CommKeyClassId) {
                if (aObjectsToDelete.get(object).booleanValue()) {
                    futures.add(this.myFacade.deleteElementTree((CommKeyClassId)object));
                    continue;
                }
                futures.add(this.myFacade.deleteElement((CommKeyClassId)object));
                continue;
            }
            if (object instanceof String) {
                futures.add(this.myFacade.deleteElement((String)object));
                continue;
            }
            throw new IllegalArgumentException("Unsupported class of deleted object: " + object.getClass());
        }
        this.handleFutures(aFuture, futures);
    }

    @Override
    protected void __configureElementsTreeList(SrFuture<Void> aFuture, ClientConfigElementData ... aConfigurationData) throws Exception {
        ArrayList<ClientConfigElementData> allCeds = new ArrayList<ClientConfigElementData>(Arrays.asList(aConfigurationData));
        this.innerConfigureElementsTreeList(aFuture, allCeds);
    }

    @Override
    protected Void __innerConfigureElementsTreeList(final SrFuture<Void> aAllConfigsFuture, final List<ClientConfigElementData> aConfigurationData) throws Exception {
        if (aConfigurationData.isEmpty()) {
            aAllConfigsFuture.set(null);
            return null;
        }
        ClientConfigElementData firstCed = aConfigurationData.get(0);
        final SrFuture<Void> configFuture = this.configureElementsTree(firstCed);
        final Runnable toDoAfterConfig = new Runnable(){

            @Override
            public void run() {
                ArrayList<ClientConfigElementData> allCeds = new ArrayList<ClientConfigElementData>(aConfigurationData);
                allCeds.remove(0);
                ClientAOImpl.this.innerConfigureElementsTreeList(aAllConfigsFuture, allCeds);
            }
        };
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                ClientAOImpl.this.tryFindConfiguration(0L, SrConfigurationDiscoverer.DUMMY_DISCOVERER, toDoAfterConfig, Collections.singletonList(configFuture), aAllConfigsFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, configFuture);
        return null;
    }

    static {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread("Shutdown"){

                @Override
                public void run() {
                    if (theInstance != null) {
                        try {
                            theInstance.myFacade.closeSession();
                        }
                        catch (Throwable t) {
                            theLogger.info(SrLogCategories.EXCEPTION, t);
                        }
                    }
                }
            });
        }
        catch (SecurityException se) {
            theLogger.warn(SrLogCategories.EXCEPTION, se);
        }
    }
}

