/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.Client;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.Communication;
import com.sanrad.nms.client.comm.CommunicationEventService;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.event.SystemEvent;
import com.sanrad.nms.client.event.SystemListener;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.MainFrame;
import com.sanrad.nms.client.gui.MainFrameEvent;
import com.sanrad.nms.client.gui.MainFrameListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.login.LoginDialog;
import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.swing.SplashWindow;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.SrResourceBundle;
import com.sanrad.util.Util;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Font;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class ClientLoader
implements MainFrameListener {
    public static SrResourceBundle BUNDLE = SrResourceBundle.getInstance("product_client", Locale.US);
    public static SrResourceBundle CONSTANSTS_BUNDLE = SrResourceBundle.getInstance("constants", Locale.US);
    public static SrResourceBundle UI_BUNDLE = SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US);
    public static SrResourceBundle COMP_NAMES_BUNDLE = SrResourceBundle.getInstance("component_names", Locale.US);
    private static SrLogger theLogger;
    public static String VERSION;
    public static final String VENDOR_NAME;
    public static final String PRODUCT_NAME;
    public static final String VSWITCH_DISPLAY_STRING;
    public static final String VSWITCHES_DISPLAY_STRING;
    public static final String CLUSTER_DISPLAY_STRING;
    public static final String SINGLE_SWITCH_DISPLAY_STRING;
    public static final String STORAGE_RESOURCE_GROUP_DISPLAY_STRING;
    public static final String SPACE = " ";
    public static final String SPACEANDCOMMA = "; ";
    public static final String HELP_URL;
    public static final String HELP_MAIN_PAGE;
    public static final String NOT_AVAILABLE;
    public static final int CONFIGURATION_IMPORT = 0;
    public static final int CONFIGURATION_EXPORT = 1;
    public static final String PORT_DELIMITER = ":";
    public static final int NO_RMI_REGISTRY_PORT = 0;
    public static final String RMI_REGISTRY_PORT_PROPERTY = "rmiRegPort";
    private static MainFrame mainFrame;
    private SplashWindow splash;
    private static boolean isApplet;
    private boolean disposed = false;
    private static String host;
    private static String storageManagerDir;
    private static String storageManagerFile;
    private static int rmiRegistryPort;
    public static SrResourceBundle DATA_VALIDATION_BUNDLE;
    private static boolean isLoaded;
    Timer keepAliveTimer = null;
    private SystemListener m_systemListener;

    public ClientLoader(boolean applet, String hostname, int rmiRegistryPort, boolean debug) {
        try {
            try {
                SrLogger.initWithDefaultProperties("com.sanrad.nms.client", "default_client.log", "${user.home}/NMS_log");
            }
            catch (AccessControlException ace) {
                System.err.println("Could not initialize the log configuration, because a security issue: " + ace.getMessage() + ".");
                ace.printStackTrace();
            }
            theLogger = SrLogger.getLogger();
            theLogger.info(SrLogCategories.SYSTEM, "OS: ", Util.getOSName(), "; version: ", Util.getOSVersion());
            theLogger.info(SrLogCategories.SYSTEM, "JVM version: ", Util.getCurrentJVMVersion());
            theLogger.info(SrLogCategories.SYSTEM, "Locale: ", Util.getLocale());
            if (VERSION == null) {
                VERSION = Util.getCVSTagVersionString();
            }
            VERSION = VERSION + " (" + Util.getCurrentJVMVersion() + ")";
            theLogger.info(SrLogCategories.SYSTEM, PRODUCT_NAME + " version: ", VERSION);
            isApplet = applet;
            String SUBSTANCE_LOOK_AND_FEEL_STYLE_1 = SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME).getString(SrDefaultUIBundleKeys.SUBSTANCE_LOOK_AND_FEEL_STYLE_1);
            String SUBSTANCE_LOOK_AND_FEEL_STYLE_2 = SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME).getString(SrDefaultUIBundleKeys.SUBSTANCE_LOOK_AND_FEEL_STYLE_2);
            Util.setLookAndFeel(SUBSTANCE_LOOK_AND_FEEL_STYLE_1, SUBSTANCE_LOOK_AND_FEEL_STYLE_2);
            boolean isCompatibleJDK = true;
            String compiledJavaVersionStr = CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.JAVA_VERSION);
            if (!compiledJavaVersionStr.equals("")) {
                int[] compiledJavaVersion;
                int[] currentJavaVersion = Util.getCurrentJVMVersionTokens();
                if (Arrays.equals(currentJavaVersion, compiledJavaVersion = Util.getJVMVersionTokens(CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.JAVA_VERSION)))) {
                    isCompatibleJDK = Util.getCurrentJVMVersionUpdateNumber() >= Util.getJVMVersionUpdateNumber(compiledJavaVersionStr);
                } else {
                    for (int i = 0; i < compiledJavaVersion.length; ++i) {
                        if (currentJavaVersion[i] < compiledJavaVersion[i]) {
                            isCompatibleJDK = false;
                            break;
                        }
                        if (currentJavaVersion[i] > compiledJavaVersion[i]) break;
                    }
                }
                if (!isCompatibleJDK) {
                    JOptionPane.showMessageDialog(null, "You must use Java(TM) version " + CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.JAVA_VERSION) + " (or higher) in order to run " + PRODUCT_NAME + "\nCurrently you use Java(TM) version " + Util.getCurrentJavaVersion() + ".\nThe Java Runtime Environment can be downloaded from:\nhttp://java.sun.com", PRODUCT_NAME + " Error", 0);
                    this.terminate();
                }
            }
            String title = BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SPLASH_TITLE);
            ImageIcon icon = ClientImageObject.APP_ICON.getImageIcon();
            int versionX = Integer.parseInt(UI_BUNDLE.getString(SrDefaultUIBundleKeys.SPLASH_WINDOW_VERSION_X).trim());
            int versionY = Integer.parseInt(UI_BUNDLE.getString(SrDefaultUIBundleKeys.SPLASH_WINDOW_VERSION_Y).trim());
            Color colorVersion = UI_BUNDLE.getColorResource(SrDefaultUIBundleKeys.ABOUT_WINDOW_VERSION_COLOR);
            Font fontVersion = UI_BUNDLE.getFontResource(SrDefaultUIBundleKeys.ABOUT_WINDOW_VERSION_FONT);
            this.splash = new SplashWindow(ClientImageObject.SPLASH.getImageIcon(), title, icon, VERSION, versionX, versionY, colorVersion, fontVersion);
            EventDispatcherTask.submit(new Runnable(){

                @Override
                public void run() {
                    ClientLoader.this.splash.setVisible(true);
                }
            });
            host = hostname;
            ClientLoader.rmiRegistryPort = rmiRegistryPort;
            storageManagerDir = Client.getStorageManagerDir();
            storageManagerFile = Client.getStorageManagerFile();
            this.addListenersToSystemEvents();
        }
        catch (Exception e) {
            theLogger.fatal(SrLogCategories.LEGACY, e, " in ", this.getClass(), "::ClientLoader()");
        }
    }

    public void login(final boolean refreshMode) {
        try {
            LoginDialog ld = new LoginDialog((JFrame)this.splash, this);
            this.splash.toFront();
            while (!ld.isLoginSuccessful()) {
                Thread.sleep(500L);
            }
            if (Communication.getInstance().getSystemRootStub().isDiscoverCompleted()) {
                this.splash.drawMessage(BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SPLASH_CLIENT_LOADING_MSG), false);
                this.loadMainFrame(refreshMode);
            } else {
                this.m_systemListener = new SystemListener(){

                    @Override
                    public void systemDiscoveryCompleted(SystemEvent e) {
                        CommunicationEventService.getInstance().removeSystemListener(this);
                        ClientLoader.this.keepAliveTimer.stop();
                        EventDispatcherTask.submit(new Runnable(){

                            @Override
                            public void run() {
                                ClientLoader.this.splash.drawMessage(BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SPLASH_CLIENT_LOADING_MSG), false);
                            }
                        });
                        new Thread(){

                            @Override
                            public void run() {
                                ClientLoader.this.loadMainFrame(refreshMode);
                            }
                        }.start();
                    }
                };
                CommunicationEventService.getInstance().addSystemListener(this.m_systemListener);
                this.keepAliveTimer = new Timer(2000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            Communication.getInstance().getSystemRootStub().getAlias();
                        }
                        catch (RemoteException e1) {
                            ClientLoader.this.keepAliveTimer.stop();
                            String errorMsg = BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SPLASH_SERVER_COMMUNICATION_ERROR);
                            ClientLoader.this.splash.error(BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SPLASH_ERROR_LABEL));
                            SrOptionPaneUtil.showErrorMessage(ClientLoader.this.splash, errorMsg);
                            ClientLoader.this.terminate();
                        }
                    }
                });
                this.keepAliveTimer.setInitialDelay(2000);
                this.keepAliveTimer.start();
                EventDispatcherTask.submit(new Runnable(){

                    @Override
                    public void run() {
                        ClientLoader.this.splash.drawMessage(BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SPLASH_SERVER_LOADING_MSG), true);
                    }
                });
            }
        }
        catch (InterruptedException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.EXCEPTION, e, new Object[0]);
            Manager.onConnectionError();
        }
    }

    private void loadMainFrame(boolean refreshMode) {
        block3: {
            try {
                if (mainFrame != null) {
                    mainFrame.dispose();
                    mainFrame = null;
                }
                mainFrame = new MainFrame(isApplet, refreshMode);
                ClientLoader.setClientLoaded();
                mainFrame.addMainFrameListener(this);
                EventDispatcherTask.submit(new Runnable(){

                    @Override
                    public void run() {
                        ClientLoader.this.splash.dispose();
                    }
                });
                mainFrame.setVisible(true);
            }
            catch (RemoteException ce) {
                theLogger.trace(SrLogCategories.LEGACY, ce);
                JFrame owner = new JFrame();
                owner.setIconImage(ClientImageObject.APP_ICON.getImageIcon().getImage());
                JOptionPane.showMessageDialog(owner, "Connection refused to host: " + host, PRODUCT_NAME + " - Error", 0);
                if (isApplet) break block3;
                System.exit(-1);
            }
        }
    }

    public void terminate() {
        if (!isApplet) {
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        if (!this.disposed) {
            theLogger.trace(SrLogCategories.LEGACY, "Start dispose...");
            try {
                if (mainFrame != null) {
                    mainFrame.removeMainFrameListener(this);
                    mainFrame.dispose();
                }
                ClientAOImpl.getInstance().logout();
                theLogger.trace(SrLogCategories.LEGACY, "Unregistered from server");
                this.disposeSplash();
                this.disposed = true;
            }
            catch (Throwable throwable) {
                this.disposeSplash();
                this.disposed = true;
                theLogger.trace(SrLogCategories.LEGACY, "Finished dispose");
                throw throwable;
            }
            theLogger.trace(SrLogCategories.LEGACY, "Finished dispose");
        }
    }

    private void disposeSplash() {
        if (this.splash != null) {
            EventDispatcherTask.submit(new Runnable(){

                @Override
                public void run() {
                    ClientLoader.this.splash.dispose();
                    ClientLoader.this.splash = null;
                }
            });
        }
    }

    @Override
    public void exitMainFrame(MainFrameEvent event) {
        this.dispose();
        this.terminate();
    }

    public static MainFrame getMainFrame() {
        return mainFrame;
    }

    public boolean isApplet() {
        return isApplet;
    }

    public static String getHostname() {
        return host;
    }

    public static int getHostPort() {
        return rmiRegistryPort;
    }

    public static String getRaidConfigurationLocation() {
        return storageManagerDir;
    }

    public static String getRaidConfigurationFile() {
        return storageManagerFile;
    }

    public static boolean isClientLoaded() {
        return isLoaded;
    }

    private static void setClientLoaded() {
        isLoaded = true;
    }

    private void addListenersToSystemEvents() {
        Toolkit kit = Toolkit.getDefaultToolkit();
        kit.addAWTEventListener(new AWTEventListener(){
            long timeOf_VK_R_Released = 0L;

            @Override
            public void eventDispatched(AWTEvent event) {
                KeyEvent keyEvent = (KeyEvent)event;
                if (event.getID() == 401 && keyEvent.getModifiers() == 2 && keyEvent.getKeyCode() == 71) {
                    this.timeOf_VK_R_Released = System.currentTimeMillis();
                } else if (event.getID() == 402 && keyEvent.getKeyCode() == 17 && System.currentTimeMillis() - this.timeOf_VK_R_Released < 300L) {
                    try {
                        Robot robot = new Robot();
                        robot.mousePress(4);
                        robot.mouseRelease(4);
                    }
                    catch (AWTException e) {
                        theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
                    }
                }
            }
        }, 8L);
    }

    static {
        VERSION = BUNDLE.getString(SrClientBundleKeys.CLIENT_VERSION);
        VENDOR_NAME = CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.VENDOR_NAME);
        PRODUCT_NAME = CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.PRODUCT_NAME);
        VSWITCH_DISPLAY_STRING = CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.PRODUCT_BOX_NAME);
        VSWITCHES_DISPLAY_STRING = CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.PRODUCT_MULTIPLE_BOX_NAME);
        CLUSTER_DISPLAY_STRING = BUNDLE.getString(SrClientBundleKeys.CLUSTER_DISPLAY_STRING);
        SINGLE_SWITCH_DISPLAY_STRING = BUNDLE.getString(SrClientBundleKeys.SINGLE_SWITCH_DISPLAY_STRING);
        STORAGE_RESOURCE_GROUP_DISPLAY_STRING = BUNDLE.getString(SrClientBundleKeys.STORAGE_RESOURCE_GROUP_DISPLAY_STRING);
        HELP_URL = BUNDLE.getString(SrClientBundleKeys.MAIN_HELP_URL);
        HELP_MAIN_PAGE = UI_BUNDLE.getString(SrClientBundleKeys.MAIN_HELP_HOME_ID);
        NOT_AVAILABLE = BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_NOT_AVAILABLE_VALUE);
        mainFrame = null;
        storageManagerDir = null;
        storageManagerFile = null;
        DATA_VALIDATION_BUNDLE = SrResourceBundle.getInstance("client_data_validation", Locale.US);
        isLoaded = false;
    }
}

