/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client;

import com.sanrad.nms.client.ClientLoader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class Client {
    private static final String DEBUG_ARG = "-debug";
    private static final String DEFAULT_HOST = "localhost";
    private static final String HOST_PROPERTY = "host";
    private static final String PROPERTIES_FILE_NAME = "client.properties";
    public static final String STORAGE_MANAGER_WINDIR_PROPERTY = "StorageManager.WinDir";
    public static final String STORAGE_MANAGER_WINDIR_DEFAULT_LOCATION = "C:\\Program Files\\IBM_DS3000\\client";
    public static final String STORAGE_MANAGER_CLIENT_FILE_PROPERTY = "StorageManager.ClientFile";
    public static final String POPUP_ATTACH_RAID_DIALOG_PROPERTY = "PopUpAttachRAIDDialogEnable";
    public static final String STORAGE_MANAGER_WINFILE_DEFAULT = "SMclient.bat";

    public static String getStorageManagerDir() {
        return Client.getPropertyValue(STORAGE_MANAGER_WINDIR_PROPERTY, STORAGE_MANAGER_WINDIR_DEFAULT_LOCATION);
    }

    public static String getStorageManagerFile() {
        return Client.getPropertyValue(STORAGE_MANAGER_CLIENT_FILE_PROPERTY, STORAGE_MANAGER_WINFILE_DEFAULT);
    }

    public static boolean getPopUpAttachRAIDDialogEnable() {
        String value = Client.getPropertyValue(POPUP_ATTACH_RAID_DIALOG_PROPERTY, "true");
        return value.equalsIgnoreCase("true");
    }

    public static int getStatisticsMaxData() {
        String value = Client.getPropertyValue("StatisticsMaxData", "1000");
        return Integer.valueOf(value);
    }

    public static String getStatisticsIntervals() {
        return Client.getPropertyValue("StatisticsIntervals", "[1h,10s][3h,1m][24h,10m]");
    }

    public static int getRMIRgistryPort() {
        String port = Client.getPropertyValue("rmiRegPort", null);
        if (port == null) {
            return 0;
        }
        return Integer.parseInt(port);
    }

    public static String getHost() {
        return Client.getPropertyValue(HOST_PROPERTY, DEFAULT_HOST);
    }

    private static String getPropertyValue(String aKey, String aDefaultValue) {
        try {
            Properties clientData = new Properties();
            clientData.load(new FileInputStream(PROPERTIES_FILE_NAME));
            return clientData.getProperty(aKey, aDefaultValue);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.err.println("File client.properties not found: failed to get value for " + aKey);
            return aDefaultValue;
        }
    }

    public static void setHost(String host, String port) {
        try {
            Properties propertiesToSave = new Properties();
            propertiesToSave.put(HOST_PROPERTY, host);
            propertiesToSave.put("rmiRegPort", port);
            propertiesToSave.put(STORAGE_MANAGER_WINDIR_PROPERTY, ClientLoader.getRaidConfigurationLocation());
            propertiesToSave.put(STORAGE_MANAGER_CLIENT_FILE_PROPERTY, ClientLoader.getRaidConfigurationFile());
            FileOutputStream outFile = new FileOutputStream(PROPERTIES_FILE_NAME);
            propertiesToSave.store(outFile, null);
            outFile.flush();
            outFile.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.err.println("File client.properties not found: localhost is set");
            host = DEFAULT_HOST;
        }
    }

    public static boolean getDebug(String[] args) {
        boolean debug = false;
        if (args.length > 0) {
            int debugArgIndex = 0;
            if (args.length == 2) {
                debugArgIndex = 1;
            } else if (args.length != 1) {
                Client.usage();
                System.exit(-1);
            }
            String debugArg = args[debugArgIndex];
            debug = debugArg.equals(DEBUG_ARG);
        }
        return debug;
    }

    public static void main(String[] args) {
        String host = Client.getHost();
        int rmiRegistryPort = Client.getRMIRgistryPort();
        boolean debug = Client.getDebug(args);
        ClientLoader loader = new ClientLoader(false, host, rmiRegistryPort, debug);
        loader.login(false);
    }

    public static void usage() {
        System.out.println("Usage:\n\tjava -jar client.jar [server ip[:port]] [-d]");
    }
}

