.pl 62














                     DEFINICON SYSTEMS, INC.



                    DSI-32 COPROCESSOR BOARD
                   & MS/PC DOS SYSTEM SOFTWARE










        



    SUPERVISOR INTERFACE GUIDE


.pa
The MSDOS/CONCURRENT DOS Interface

The  DSI-32 compilers have been provided with  runtime  libraries 
that  make it unnecessary for a high-level language programmer to 
understand the intricacies of the Definicon MSDOS interface.

The  Definicon  software  interface  consists  of  two   software 
programs,  one running on the IBM PC (LOAD), and the other on the 
DSI-32 (32IO). All functions such as: file open, file close, read 
file,  write file,  rename file,  unlink file,  seek file etc are 
made available to the DSI-32 via the interface software. Below is 
a general outline of how the interface works.

As  an  example of the interface in action let us assume  that  a 
request to open a file is generated by a user program on the DSI-
32. The request is first processed by the runtime library for the 
particular  high  level language that the program is written  in. 
This  request  is  reformatted and then is  passed  to  the  32IO 
program  which  constructs a request vector in the  communication 
area  of 32IO.  32IO then initiates an Interrupt 2 on the PC  bus 
and then waits for the request to be serviced. The PC detects the 
Interrupt  2  signal  and  determines  what  function  is  to  be 
performed  by scanning the request vector that was set up by  the 
32IO  program.  Once the request has been serviced,  the PC  then 
informs 32IO that the task has been performed.  32IO detects that 
the  request  has  been  serviced  by  the  PC  and  returns  the 
appropriate status,  including any errors, to the calling routine 
which in turn returns to the user program.

Programs  written  in   assembler  language  may  be   interfaced 
directly  to  32IO via a special calling  convention.  The  32000 
series  of microprocessors reserve an intruction for performing a 
supervisor  call (SVC).  The SVC instruction (refer  to  National 
Semiconductor's Intruction manual on the 32000 series) vectors to 
the 32IO program via a interrupt table.  32IO determines the type 
of  request by the contents of various registers (refer Table  1) 
below. 

The  Definicon interface system also enables special devices that 
have  been  installed  into  the  IBM  PC  to  be  accessed   via 
special  device drivers (.SYS files) at boot time.  For instance, 
if  a  GPIB card has been installed in this way  a  user  program 
could  open  the device called GPIB,  in the same as opening  any 
other  file,  and  access  the  GPIB card  without  the  need  to 
perform direct input/output requests on the card.
.pa
Prior  to describing each of the system calls in 32IO an  example 
program  in assembler language that types the contents of a  file 
out has been included in this section to assist the programmer in 
visualising the interface system.

	title	"Sample test program"
        ;
        ; This is a sample program to open a file and then
        ; to display the contents of the file on the console
        ; several characters at a time.
        ;
        ; ****** Hint, increase the 'inbuf' size to 10k or
        ; so and then see how quick it is. 
        ;
        static
argbuf: blkb	132		;command line buffer
fileid:	blkw	1		;file id
inbuf:	blkb	10		;file buffer
inbufl:	equ	$-inbuf		;length of buffer
	endseg
	;
type:	movw	132,r1		;maximum length of command line
	addr	argbuf:w,r2	;buffer for command line
	movw	14,r0		;get argument list request #14
	svc
	cmpqw	2,r0		;want only one argument,
	bne	error1:w        ;1st arg is command
	movd	argbuf:w+8,r1	;get the first argument pointer
	movqw	0,r2		;read request
	movqw	5,r0		;open request #5
	svc
	cmpqw	-1,r0		;error ?
	beq	error2:w
	movw	r0,fileid	;save the file id returned from
loop:	movw	fileid,r1	;open and get file id
	addr	inbuf,r2	;the buffer for reading data
	movw	inbufl,r3	;get one character at a time
	movw	8,r0		;read request #8
	svc
	cmpqw	0,r0		;all done ?
	beq	done:b
	movqw	1,r1		;to stdout
	addr	inbuf,r2
	movw	r0,r3		;write the same length as read
	movw	9,r0		;write request #9
	svc
	cmpqw	0,r0
	bne	loop		;put it out to the console
.pa
	addr	mess3,r2	;message start
	movd	mess3l,r3
	br	putmsg:b
	;
error1:	addr	mess1:b,r2	;message start
	movd	mess1l,r3	;message length
putmsg:	movqd	2,r1		;stderr
	movw	9,r0		;write request #9
	svc
done:	movw	15,r0		;return to dos
	svc
	;
error2:	addr	mess2:b,r2	;message start
	movd	mess2l,r3	;message length
	br	putmsg
	;
mess1:	byte	"Filename only expected", h'0a
mess1l:	equ	$-mess1
mess2:	byte	"Could not find file", h'0a
mess2l:	equ	$-mess2
mess3:	byte	"Error in writing to console", h'0a
mess3l:	equ	$-mess3


Note. To execute this program all that is necessary is to:

A>as sample

A>ln file=sample

A>load sample -a <filename>

,where <filename> is the file to type out onto the console.

Refer to Table 1 below for detailed information regarding each of 
the   32000  series  supervisor  calls.   For  further   detailed 
information  on the assembler and assembler intructions refer  to 
both   the   Definicon   Assembler  manual   and   the   National 
Semiconductor's  Instruction  set  manual  on  the  32000  series 
microprocessor.
.pa
Support for IBM style bit-mapped graphics

System  call # 17 moves memory from the 32000 to  the  IBM.  This 
allows  a  user to set up single or multiple 16K graphics  screen 
images in the 32000's memory space and swap them to the  IBM-PC's 
screen  memory  as  required.   It  takes  only  a  few  tens  of 
milliseconds  to totally replace a PC's screen in this way.

Thus an application that,  for example,  requires animation,  can 
use the 32000 to set up successive backgrounds in its own  memory 
space, swapping only those portions of the screen memory actually 
necessary  to  update the foreground motion.  When  a  background 
change  is needed it can be transferred to the display in a  very 
short  time.  Note  that it would be possible to set up  a  large 
background  space  from  which the 16K screen  display  could  be 
'zoomed'  using the 32 bit integer manipulation capability of the 
32032.  Applications  which have already been written (in a  high 
level  language)  can  perform bit-mapped  graphics  with  nearly 
identical code in the DSI-32 environment.

Definicon  has developed a graphics interface library that can be 
accessed via C, Pascal and assembler language. The package may be 
separately  purchased  by  quoting the  graphics  interface  part 
number  (GRAPHICS32).  Definicon  also  sells the source  of  the 
graphics package.  The library supports multiple virtual  screens 
in  the DSI-32 memory,  as well as line,  circle and box drawing. 
Pixel setting and clearing is also supported.

The library offers a background updating mode whereby the  DSI-32 
can be processing the next virtual screen while the IBM is moving 
the current virtual screen to the display memory. This background 
mode  enables  high speed updating of information that  is  being 
displayed.
.pa
Parameters for Supervisor request

The  Supervisor  requests require certain register to be  set  up 
with appropriate values. 

- The  request code is always passed in the R0 register and  must 
be valid to 16 bits,  ie the top 16 bits is ignored.

- Pointers  to data areas must have all 32  bits,  generally  the 
pointers are computed with the 32000 'ADDR' or instruction and so 
automatically  have all 32 bit valid.

- Length parameters must be valid to 32 bits. Maximum data length 
depends  on the particular request.  Unless otherwise stated  the 
maximum transfer length is 2147483649 bytes ie 2**31-1.

- File  id parameters are returned as full 32 bit values and must 
be passed in the same way.

- Request  completion status is always returned as a full 32  bit 
value.


Supervisor request codes

Supervisor_request_5          OPEN A DEVICE

Pass:          R0 = 5
               R1 = Pointer to null delimited device name string
               R2 = Open mode,  0 = read,  1 = write, 2 = create. 
                    To  open a binary file set bit 2 of the  open 
                    mode. This is the preferred (fastest) mode.

Returns:       R0 = Device id, (-1 = error)


Description:

This supervisor request causes a device that already exists to be 
opened  for  access as specified via the mode parameter.  If  the 
device does not exist,  an error code will be returned, otherwise 
the device id (handle) via which all further access to the device 
will be directed is returned.
.pa
Supervisor_request_6          CLOSE A DEVICE

Pass:          R0 = 6
               R1 = Device id to close

Returns:       R0 = Close status (0 if successful, -1 if error)

Description:

This  supervisor request closes the device which is  attached  to 
the  device  id.   The return status reports any errors that  may 
have occurred, if any.

Supervisor_request_7          CREATE A DEVICE (FILE)

Pass:          R0 = 7
               R1 = Pointer to null terminated device name string
               R2 = Create mode, 0 = ASCII, 4 = binary

Returns:       R0 = File id, (-1 = error)

Description:

This supervisor request will create a file.  If the file  already 
exists  then  the file is truncated to zero length.  If an  error 
occurs then -1 is returned in R0, otherwise the file id via which 
all  further access to the file will be directed is  returned  in 
R0.

Supervisor_request_8          READ FROM A DEVICE

Pass:          R0 = 8
               R1 = Device id to read from
               R2 = Destination for the read data
               R3 = Length of data to read

Returns:       R0 = Length of data actually read (0 = error)

Description:

This  supervisor request will read data from the device  attached 
to  the device id.  If any errors occur during the read then  the 
return status will be zero,  otherwise the actual number of bytes 
read will be returned in R0.   The returned length will generally 
be  the  same  as  the requested length unless  end  of  file  is 
reached.
.pa
Supervisor_request_9          WRITE TO A DEVICE

Pass:          R0 = 9
               R1 = Device id to write to
               R2 = Write data source
               R3 = Length of data to write

Returns:       R0 = Length of data actually written (0 = error)

Description:

This supervisor request will write data to the device attached to 
the  device  id.  If any errors occur during the write  then  the 
return status will be zero,  otherwise the actual number of bytes 
written will be returned.  The returned length will generally  be 
the same as the requested length unless the device becomes full.

Supervisor_request_10         ERASE (UNLINK) A DISK FILE 

Pass:          R0 = 10
               R1 = Pointer to null terminated filename string

Returns:       R0 = Erase status (0 = successful, -1 = error)

Description:

This  supervisor request will erase the specified file.

Supervisor_request_11         RENAME A FILE

Pass:          R0 = 11
               R1 = Pointer to old null terminated name string
               R2 = Pointer to new null terminated name string

Returns:       R0 = Rename status (0 = successful, -1 = error)

Description:

This  supervisor request will rename the old filename to the  new 
filename.
.pa
Supervisor_request_12         SEEK TO BYTE IN FILE

Pass:          R0 = 12
               R1 = Device id
               R2 = Byte offset to seek to
               R3 = Seek base, 0 = from the beginning of the file
                               1 = from the current position
                               2 = from the end of the file

Returns:       R0 = New byte position relative to the  beginning 
                    of file or -1 if error. 

Description:

This  supervisor  request causes the file pointer to be moved  to 
the specified position.  Three bases from which the seek is to be 
offset  are available.  The new seek position is returned by  the 
function unless and error occurs.  The returned file pointer is a 
32 bit variable.

Supervisor_request_13         DETERMINE POSITION IN FILE

Pass:          R0 = 13
               R1 = Device id

Returns:       R0 = Current position or -1 if error

Description:

This  supervisor request returns the current file pointer  unless 
and error occurs. The returned file pointer is a 32 bit variable.
.pa
Supervisor_request_14         GET COMMAND LINE ARGUMENTS

Pass:          R0 = 14
               R1 = Length of command buffer
               R2 = Location to store the data

Returns:       R0 = Number of arguments returned

Description:

This  supervisor request allows the command line  arguments  that 
were entered on the IBM to be transferred to the DSI-32. The user 
supplies the address to store the arguments and the length of the 
buffer. The returned data is described below:

              ---------------------------------------------------
R2 ->         | Number of commands                 4 byte value |
              |-------------------------------------------------|
              | Pointer to first argument          4 byte value |
              |-------------------------------------------------|
              | Pointer to second argument         4 byte value |
              |-------------------------------------------------|
              |           ..                            ..      |
              |-------------------------------------------------|
              | Pointer to nth argument            4 byte value |
              |-------------------------------------------------|
              | First null terminated argument          *       |
              |-------------------------------------------------|
              | Second null terminated argument         *       |
              |-------------------------------------------------|
              |           ..                                    |
              |-------------------------------------------------|
              | Nth null terminated argument            *       |
              ---------------------------------------------------

*  - data  length  is determined by location of  null  terminator 
(i.e. 0 byte value).

Supervisor_request_15         TERMINATE 32000 EXECUTION

Pass:          R0 = 15

Returns:       (doesn't)

Description:

This  supervisor request causes the IBM to terminate execution of 
the resident portion of the code which interfaces to  32IO.  This 
request  should  be  performed at the end of every  program  that 
executes on the DSI-32 board.   It ensures a clean termination of 
a program.
Supervisor_request_16         MOVE MEMORY FROM 32000 TO IBM

Pass:          R0 = 16
               R1 = Pointer to source in 32000 memory
               R2 = Pointer to destination in IBM memory
               R3 = Length in bytes to move (maximum 65535 bytes)

Returns:       (nothing)

Description:

This  supervisor  request moves memory from the IBM memory  space 
into the 32000 memory space. The maximum length is limited to the 
size of an integer on the IBM which is 16 bits.

Supervisor_request_17         MOVE MEMORY FROM IBM TO 32000

Pass:          R0 = 17
               R1 = Pointer to source in IBM memory space
               R2 = Pointer to destination in 32000 memory
               R3 = Length in bytes to move (maximum 65535 bytes)

Returns:       (nothing)

Description:

This supervisor request moves memory from the 32000 memory  space 
into  the IBM memory space.  The maximum length is limited to the 
size of an integer on the IBM which is 16 bits.

Supervisor_request_18         MOVE MEMORY FROM 32000 TO IBM

Pass:          R0 = 18
               R1 = Pointer to source in 32000 memory
               R2 = Pointer to destination in IBM memory
               R3 = Length in bytes to move (maximum 65535 bytes)

Returns:       (nothing)

Description:

This  supervisor  request moves memory from the IBM memory  space 
into the 32000 memory space. The maximum length is limited to the 
size of an integer on the IBM which is 16 bits.

This function differs from #16 in that control is returned before 
the move operation is complete.  This permits programs to overlap 
screen updates with processing, among other uses.
.pa
Supervisor_request_19         MOVE MEMORY FROM IBM TO 32000

Pass:          R0 = 19
               R1 = Pointer to source in IBM memory space
               R2 = Pointer to destination in 32000 memory
               R3 = Length in bytes to move (maximum 65535 bytes)

Returns:       (nothing)

Description:

This supervisor request moves memory from the 32000 memory  space 
into  the IBM memory space.  The maximum length is limited to the 
size of an integer on the IBM which is 16 bits.

This function differs from #17 in that control is returned before 
the move operation is complete.  This permits programs to overlap 
screen updates with processing, among other uses.

Supervisor_request_20         INPUT FROM PORT ON IBM

Pass:          R0 = 20
               R1 = Port address to input a byte from

Returns:       R0 = Byte read from the input port

Description:

This supervisor request causes the IBM to read a single byte from 
an input port and return it to the 32000.  The port address is  a 
16 bit value.

Supervisor_request_21         OUTPUT TO A PORT ON THE IBM

Pass:          R0 = 21
               R1 = Port address to output a byte to
               R2 = Byte to output to the port

Returns:       (nothing)

Description:

This supervisor request causes the IBM to output a specified byte 
to the specified output port. The port address is a 16 bit value.
.pa
Supervisor_request_22         Read config register

Pass:          R0 = 22

Returns:       R0 = config register

Description:

This supervisor request causes the contents of the current config 
register in the 32000 to be read into R0.  This permits  programs 
to determine,  for example,  if an MMU is currently in use on the 
system. Following is a short table describing the contents of the 
config register.

     Bit  Use

       0  Interrupt Control Unit
       1  Floating Point Unit
       2  Memory Management Unit
       3  Custom Slave processor

A  normal return for the DSI-32 card would be 0x02,  meaning that 
an FPU was installed in the card.
     
