#include <stdio.h>
#include <errno.h>
#include <time.h>

#include "32kdef1.h"

extern int _argc,argt;
extern char *_argv[MAXARG],*arg[MAXARG];
	    
extern int ftype[MAXOPF],fisop[MAXOPF];
extern char *lastnm,*rdbuf_;

int _OPEN(s,x)
long s;
int x;
{
    unsigned char file[100];
    register int i;
    
    MOVE1(s,file,99);

    fix(file);

    if (x & 4) 
	i = openx(file, x&3);
    else 
	i = openxa(file, x&3);
    
    if ((x & _OP_EOF) && (i > 0))
	lseek(i,0L,2);  /* Seek to end of file, if that's what he wants.. */
	
    return(i);
}

fix(s)
unsigned char *s;
{
    unsigned char *t,*t1;
    int len;

#if PCDOS == 1
    while (*s) {
	if (*s == 13) *s = '\0';
	s++;
    }
#endif
    
#if PCDOS != 1
    
    t1=t=s;
    
    len=strlen(s);
    t1+=len;
    
    while ((*t1!='/') && (len != 0)) {
	len--;
	t1--;
    }
    if (len) 
	strcpy(t,++t1);
#endif
}

int _CREA(s,x)
long s;
int x;
{
    unsigned char file[100];
    register int i;
    
    MOVE1(s,file,99);

#if debug
printf("Create request for \"%s\"\n",file);
#endif

#if PCDOS != 1
    fix(file);
#endif

    if (x & 4) {
	i = creat (file, x&3);
	if (i > 0){ ftype[i] = 0; fisop[i] = 1; }
    } else {
	i = creat( file, x);
	if (i > 0){ ftype[i] = 1; fisop[i] = 1; }
    }
	
    return(i);
}
    
int _CLOS(x)
int x;
{
    static unsigned char eof=0x1a;

#if debug
printf("Close request for %d\n",x);
#endif
    
    if (ftype[x] == 2)
	write(x,&eof,1);
	
    fisop[x] = ftype[x] = 0;
    
    return(close(x));
}

int _READ(fd,buffer,bytes)
int fd;
long buffer;
int bytes;
{
    unsigned char *tbuf,*myalloc();
    int tret;
    
#if debug
printf("Reading %d bytes from %d into %8lx\n",bytes,fd,buffer);
#endif

    tbuf=myalloc(bytes);
	
    if (ftype[fd])
	tret = reada(fd,tbuf,bytes);
    else
	tret = read(fd,tbuf,bytes);
	
    if (tret > 0) {
	MOVE(tbuf,buffer,bytes);
	errno = 0;
    }
	
    free(tbuf);
    return(tret);
}

reada(fd,tbuf,bytes)
int fd,bytes;
unsigned char *tbuf;
{
    int lbytes, lret, tbytes, endof, tret;
    register unsigned char *pt1, *pt2, temp;
    
    endof = tbytes = 0;
    lret = read(fd,tbuf,bytes);
    pt1 = pt2 = tbuf;
    
    while (lret > 0) {
	pt1 = pt2;
    
	for (lbytes = lret; lbytes > 0; lbytes--) {
	    if (*pt1 == 0x1a) {
		endof = 1;
		pt1 = tbuf + lret;
		break;
	    }
	    if (*pt1 == 0x0d) {
		if (lbytes > 1 && *(pt1 + 1) == 0x0a) {
		    lbytes--;
		    pt1++;
		} else {
		    if (lbytes == 1) {
			if ((tret = read(fd,&temp,1)) != 1)
			    endof = 1;
			else {
			    if (temp != 0x0a)
				lseek(fd,-1L,1); /* Not a CR/LF, back up */
			    else
				*pt1 = 0x0a; /* It is a CR/LF, put a LF */
			
			}
		    }
		}
	    }
	    *pt2++ = *pt1++;
	}
	lret -= (pt1 - pt2);
	tbytes += lret;
	tbuf = pt2;
	if (tbytes == bytes || fd < 3 || endof)
	    break;
	else 
	    lret = read(fd,tbuf,bytes - tbytes);
    }
    return(tbytes);
}

    
int _WRIT(fd,buffer,bytes)
int fd;
long buffer;
int bytes;
{
    unsigned char *tbuf,*myalloc();
    int tret;
    
#if debug
printf("Writing %d bytes from %d into %8lx\n",bytes,fd,buffer);
#endif

#if PCDOS==1
    if (fd == 0) 
return(-1);
#endif

    tbuf=myalloc(bytes);
    MOVE1(buffer,tbuf,bytes);
	
    if (ftype[fd])
	tret = writea(fd,tbuf,bytes);
    else
	tret = write(fd,tbuf,bytes);
	
    if (tret > 0) errno = 0;
    
    free(tbuf);

    return(tret);
}
/* Replaced by assembler version of same
writea(fd,tbuf,bytes)
int fd,bytes;
unsigned char *tbuf;
{
    int lret,lbytes,x;
    unsigned char *pt1,*pt2;
    static unsigned char cr = 0x0d;
    
    ftype[fd] = 2;
    pt1 = pt2 = tbuf;
    
    for (lbytes = bytes; lbytes > 0; lbytes--) {
	if (*pt1 == 0x0a) {
	    x = pt1 - pt2;
	    if ( (lret = write(fd,pt2,x)) != x)
		goto error;
	    if (write(fd,&cr,1) != 1)
		goto error;
	    pt2 = pt1;
	}
	pt1++;
    }
    lret = write(fd,pt2,(pt1 - pt2));
    if (lret == (int)(pt1 - pt2)) lret = bytes;
error:
    return(lret);
}
*/

	
	
    

int _RENAM(file2,file1)
long file1,file2;
{
    unsigned char f1[100],f2[100];
    int ret;
    
    MOVE1(file1,f1,99);
    MOVE1(file2,f2,99);
    
#if debug
printf("Renaming \"%s\" to \"%s\"\n",f1,f2);
#endif
    
    if ((ret=open(f2,0)) != -1) {
	close(ret);
	ret = 1;
    } else {
	ret = rename(f1,f2);
    }
    return(ret);
}


long _SEEK(fd,offset,ptrname)
int fd;
long offset;
int ptrname;
{

    register long x;
    
#if PCDOS==0
    if (ftype[fd]) 
	x = lseek(fd,offset,ptrname);
    else
	x = lseekb(fd,offset,ptrname);
	
#endif

#if PCDOS==1
    x = lseek(fd,offset,ptrname);
#endif
    
    
#if debug
printf("Seeking in %d to %ld, with a mode of %d\n",fd,offset,ptrname);
#endif

    return(x);
}

long _TELL(fd)
int fd;
{
    register long x;

    x = _SEEK(fd,0L,1);
#if debug
printf("Telling location of %d = %ld\n",fd,x);
#endif

    return(x);
}


    

int _UNLI(s,l)
long s;
int l;
{
    unsigned char file[100];
    MOVE1(s,file,99);

#if debug
printf("Unlinking %s\n",file);
#endif

    return(unlink(file));
}
    
    

_ARGP(len,dta)
long dta;
int len;
{
    unsigned char *loc,*temp,*myalloc(),c;
    int curoff=0,x;
    long *t1;

    loc=temp=myalloc(len);

    t1=(long *)loc;
    
    *t1++=(long) _argc + 1L;
    
    *t1++ = (long) curoff;
    curoff += strlen(lastnm)+1;
    
    for (x=0;x<_argc;x++) {
	*t1++ = (long) curoff;
	curoff+=strlen(_argv[x])+1;
    }
    
    temp=(unsigned char *)t1;
    strcpy(temp,lastnm);
    temp += strlen(lastnm)+1;
    
    for (x=0;x<_argc;x++) {
	if (argt == 0) {
	    strtol(_argv[x]);
	    if (_argv[x][0]=='-' &&
		((c = _argv[x][1])=='d' || c =='x' || c =='e' ||
			        c =='z' || c =='s' || c =='i'))
		_argv[x][1]=toupper(c);
	    if (strcmp(_argv[x],"-o1")==0)
		strcpy(_argv[x],"-O ");
	    if (strcmp(_argv[x],"-o2")==0)
		strcpy(_argv[x],"-O2");
	} 
	strcpy(temp,_argv[x]);
	temp += strlen(_argv[x])+1;
    }
    
    
    MOVE(loc,dta,len);
    free(loc);
    
}

DOSTIME(add)
long add;
{
    struct tm ltime;
    VOID dostime();
    
    dostime(&ltime);
    MOVE(&ltime,add,sizeof(struct tm));
}


_ENV(dest)
long dest;
{
    int index,segment;
    unsigned char *envs, *myalloc();
    struct {
	unsigned int cs;
	unsigned int ss;
	unsigned int ds;
	unsigned int es;
    } segs;

    envs = myalloc(32767);

#if PCDOS == 1
    segread(&segs);
    segment = segs.cs - 0x10;
    segment = peekw(0x2c,segment);
    
    for (index = 0; peekw(index,segment); index++)
	envs[index] = peekb(index,segment);
    envs[index + 1] = envs[index] = 0;
#endif
#if PCDOS == 0
    strcpy(envs,"COMSPEC= \nOS=CPCDOS 4.1\nPATH=P:\\\n");
    segment = strlen(envs);
    for (index = 0; index < segment; index++)
	if (envs[index] == '\n')
	    envs[index] = '\0';
#endif

    MOVE(envs,dest,index + 1);
    free(envs);
}
    
_SYSIT(add)
long add;
{
    char sys[256];
    
    MOVE1(add,sys,255); 
    
    return(system(sys));
}


_EXECIT(name,args)
long name,args;
{
    char nm[64];
    unsigned char *myalloc(),*fixname();
    int narg,x;
    long argx;
    
    MOVE1(name,nm,64);
    narg = 0;
    do {
	MOVE1(args,&argx,4);
	if (argx) {
	    MOVE1(argx,arg[narg],40);
	    narg++;
	}
	args += 4;
    } while (argx);

    for (x = 0; x < narg; x++)
	_argv[x] = arg[x];
    
    _argc = narg;
    
    rdbuf_ = (char *)myalloc(RDBUFSIZE);
    if ((x = openx(fixname(nm),0)) != -1) {
	close(x);
	x = load("32io",1); /* Load up 32io */
	if (x == 0) 
	    x = load(nm,1);
    }
    free(rdbuf_);
    return(x);

}

_SIG(sig,type)
int sig, *(type)();
{
#if PCDOS == 0
    bdos(109,8); /* Disable control C termination */
#endif
#if PCDOS
    signal(sig,type);
#endif
}
_PATH(str,type)
long str;
int type;
{
    char temp[65];
    int retcode = 0;
#if PCDOS
    MOVE1(str,temp,64);
    switch(type) {
	case 1:
	    retcode = mkdir(temp);
	    break;
	    
	case 2:
	    retcode = rmdir(temp);
	    break;
	    
	case 3:
	    retcode = chdir(temp);
	    break;
	    
	case 4:
	    retcode = getcwd(temp,64);
	    MOVE(temp,str,64);
	    break;
    }
#endif
    
    return(retcode);
}

	    



    