#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <time.h>
#include <signal.h>

#include "32kdef.h"
#include "32kdef1.h"

unsigned char *rdbuf_;		/* pointer to 32K buffer */
long rdoff_;		/* Current file offset */
int  rdbyt_;		/* Current number of bytes in buffer */
int  rdpos_;		/* Current offset into buffer */
unsigned char *buffer,*fixn;
long start;
int fi;			/* Current work file */

static char *erm[]={
"Loader version 2.24v  02/15/85 (c) 1985,1986 Definicon Systems, Inc.",
"File too short! Possible non-32k file.",
"Seek error during program load. Possible non-32k file.",
"File read error during program load. File corrupt.",
"Could not allocate sufficient memory.",
"is not a 32000 executable file.",
"Dave Rand 1985,1986"
};

int ftype[MAXOPF],fisop[MAXOPF];

#if PCDOS == 1
int abort();
#endif

/*
CSD-32000 Cross-Assembler V1.08 LISTING OF: LOADER.A32			PAGE 1

00000000 PC 6FAD20		     1  	LPRD	SB,@H'20
00000003 PC EDA70020		     2  	LPRW	MOD,H'20
00000007 PC 17A82C		     3  	MOVD	@H'2C,R0
0000000A PC 7F02		     4  	JUMP	R0
0 Assembly error(s) detected. 
*/

static unsigned char start32k[]={0x6f,0xad,0x20,0xed,0xa7,0x00,0x20,0x17,0xa8,0x2c,
			0x7f,0x02};
int _argc=0;
int argt;
int tcard=-1;   /* Type of card installed is unknown */
int dovirt;     /* Are we running virtual? */

static char *cardt[] = {
    "XT",
    "AT",
    "Alt AT"
};

unsigned char *_argv[MAXARG],*arg[MAXARG];
unsigned char *lastnm;

extern VOID MOVE();
extern VOID MOVE1();
extern int INIT();
extern VOID EXEC();
extern VOID EXECT();
extern int GETSYS();


VOID error();
VOID fix();

main(argc,argv)
int argc;
unsigned char *argv[];
{
    long retcode;
    int time,x,mstat, didload, largc, brk;
    unsigned char *tq,*myalloc(),c,*index1();
    VOID dostat();

    /* Get local buffer space */
    
#if PCDOS == 1
    signal(SIGINT,abort);
#endif
    tq = myalloc(MAXARG * 40);
    for (x = 0; x<MAXARG; x++) {
	arg[x] = tq;
	tq += 40;
    }
    buffer = myalloc(MAX);
    fixn = myalloc(30);
    lastnm = myalloc(30);
    rdbuf_ = myalloc(RDBUFSIZE);

/*
printf("BETA TEST ONLY LOADER\n");
*/

    for (x=0; x < MAXOPF; x++) {
	ftype[x] = 0;		/* All files in binary */
	fisop[x] = 0;		/* All files are closed */
    }
    
    fisop[0]=fisop[1]=fisop[2]=	
    ftype[0]=ftype[1]=ftype[2]=1;	/* Except STDIN, STDOUT, STDERR */

    for (x=1; x <= argc; x++) {
	strcpy(rdbuf_,argv[x]);
	strtol(rdbuf_);
	if (!strcmp(rdbuf_,"-a") || !strcmp(rdbuf_,"-b"))
	    break;   /* If on to real arguments, break out */
	
	if (!strcmp(rdbuf_,"-1")) {
	    tcard = 0; /* We found a standard address card */
	    break;
	}
	if (!strcmp(rdbuf_,"-2")) {
	    tcard = 1; /* We found an alternate address card */
	    break;
	}
	if (!strcmp(rdbuf_,"-3")) {
	    tcard = 2; /* We found an alternate AT address card */
	    break;
	}
    }

    if (tcard == -1) {
	tcard = 0;
	if (INIT(0)) {
	    tcard = 1;
	    if (INIT(1)) {
		tcard = 2;
		if (INIT(2)) {
		    printf("LOAD: No Definicon DSI-32 found.\n");
		    exit(1);
		}
	    }
	}
    } else {
	if (INIT(tcard)) {
	    printf("LOAD :Specified DSI-32 card is not installed. Type=%s\n",cardt[tcard]);
	    exit(1);
	}
    }
    
    /* init 32k page zero */
    
    MOVE(start32k,0L,sizeof(start32k));
    
    /* Zero fill the communication area */
    tq=myalloc(4096);
    MOVE(tq,20L,4096);
    MOVE(tq,0x1000L,4096);
    MOVE(tq,8192L,4096);
    free(tq);
    
    dovirt = didload = mstat = time = 0;

    load("32io",0);
#if debug
printf("\n");
#endif
    if (argc>1) {
	brk = 0;
	for (largc = 1; largc < argc; largc++) {
	    if (argv[largc][0] == '-') {
		switch(c = tolower(argv[largc][1])) {
		    case 'a':
		    case 'b':
			argt = (c == 'b') ? 1 : 0;
			largc++;
			brk = TRUE;
			break;
		    
		    case 'm':
			mstat = TRUE;
			break;
			
		    case 't':
			time = TRUE;
			break;

		    case '1':
		    case '2':
		    case '3':
			break;
		    
		    default:
			printf("LOAD: Unknown option: %c\n",c);
			break;
		}
		if (brk)
		    break; /* Time to process arguments */
	    } else {
		strcpy(lastnm,argv[largc]);
		if (!dovirt) load(argv[largc],0);
		didload = 1;
	    }

#if debug
		printf("\n");
#endif
	}
	
	_argc=argc - largc;
	for (x=0;x<=_argc;x++)
	    _argv[x]=argv[x + largc];
	
#if debug
	printf("\nStarting execution...\n\n");
#endif
	if (didload) {
	    free(rdbuf_);
	    if (time) 
		EXECT();
	    else 
		EXEC();
	    
	    finish();
    	    if (mstat) 
		dostat();
	    MOVE1(0x2032L,&retcode,4);
#if PCDOS==0
	    if (retcode) 
		printf("\nLOAD: Exit code is %ld\n",retcode);
#endif
	    INIT(tcard);
	    exit((int)retcode);
	}
    }
    
    printf(erm[0]);
    MOVE1(0x2200L,rdbuf_,500);
    tq = index1(rdbuf_,"(C) ",500);
    if (tq) {
	fixn = tq;
	while (*fixn++ != '*') 
	    ;
	*--fixn = '\0';
    } else {
	tq = rdbuf_;
	strcpy(tq,"is invalid.");
    }
	    
    printf("\n32000 Kernel %s\n\n",tq);
    printf("DSI-32 board is using the %s address.\n",cardt[tcard]);
    printf("\nYou must supply a name to load.\n\n");
    exit(0);

    
}

strtol(s)
unsigned char *s;
{
    while (*s)
	*s++ = tolower(*s);
}

finish(){
    int x;
	    for (x=3; x<MAXOPF; x++) {
		if (ftype[x])
		    _CLOS(x);
		else if (fisop[x])
		    close(x);
	    }
}
	    


VOID dostat() {
    long var1,var2,var3;
    double res,pc,tot;
    
    fprintf(stderr,"\n\nMemory statistics          :    Bytes   Percent\n",'%');
    MOVE1(0x2020L,&var1,4); /* get the heap low address */
    MOVE1(0x2024L,&var2,4); /* get the heap high address */
    MOVE1(0x371fL,&var3,4); /* get CHEAPL */
    tot =  (double) var2 / 1024.0 ;
    res = (double) var1 / 1024.0 ;
    pc = res / tot * 100.0;
    fprintf(stderr,"Size of program            : %8.2f K %6.2f%c\n",res,pc,'%');
/*
    res = (double) (var2 - var1) / 1024.0;
    pc = res / tot * 100.0;
    fprintf(stderr,"Memory available to program: %8.2f K %6.2f%c\n",res,pc,'%');
*/
    res = (double) (var3 - var1) / 1024.0;
    pc = res / tot * 100.0;
    fprintf(stderr,"Memory used by program     : %8.2f K %6.2f%c\n",res,pc,'%');
    res = (double) ((var2 - var1) - (var3 - var1)) / 1024.0;
    pc = res / tot * 100.0;
    fprintf(stderr,"Free memory remaining      : %8.2f K %6.2f%c\n",res,pc,'%');
    fprintf(stderr,"Total memory on card       : %8.2f K %6.2f%c\n",tot,100.0,'%');

}


load(s,doret)
unsigned char *s;
int doret;
{
    struct GENINF *gen;
    unsigned char *namein,*fixname();
    VOID loadit();
    
    namein=fixname(s);
    
    fi=openx(namein,0);
    if (fi != -1) {
#if debug
printf("Loading %s...",namein);
#endif
    
	if (read(fi,buffer,sizeof(struct GENINF))==-1) 
	    error(1);
    
	gen = (struct GENINF *)buffer;
	
	switch (gen->execid) {
	    case 7700:
		loadit(fi);
		break;
		
	    case 7701:
		MOVE(namein,0x80L,strlen(namein)+1);
		dovirt = TRUE;
		load("virt.e32",0);
		break;
	    
	    default:
		printf("LOAD: \"%s\" ",namein);
		error(5);
	}
	close(fi);
	
    } else {
	if (doret)
return(-1);
	printf("\nLOAD: File %s not found.\n",namein);
	exit(1);
    }
return(0);
}

unsigned char *fixname(s)
unsigned char *s;
{
    unsigned char *index();
    strcpy(fixn,s);
    if (index(fixn,'.')==NULL) {
	strcat(fixn,".e32");
    }
    return(fixn);
}

VOID loadit(fi)
int fi;
{
    struct GENINF *gen;
    struct MODDIR *mod,*directory;
    struct GMT *temp;
    struct MODREC *modrec;
    
    int t,curdir,curptr,totmrec;
    long totmod,realstart;
    unsigned char *myalloc();
    
    VOID sort(),ldblk();
    
    gen = (struct GENINF *)buffer;
    totmod=gen->modcount;
    
    /* Move general information to 32032 */
    MOVE(&gen->heap_low,0x2020L,16);

#ifdef debug
printf("Exec id=%d, Dirblk=%d, modcnt=%ld, modaddr=%ld\n",gen->execid,gen->dirblk,totmod,gen->modaddr);
#endif

    start=gen->modaddr;
    curdir=totmod;
    
    mod=(struct MODDIR *)myalloc(sizeof(struct MODDIR));

    lseek(fi,(long) (long)(gen->dirblk*512)+((gen->mainmod - 1L)*
		    sizeof(struct MODDIR)),0);
    
    if (read(fi,mod,sizeof(struct MODDIR))==-1) 
	error(1);

    realstart = mod->strtaddr;

    free(mod);
    
    lseek(fi,32L,0);

    temp=(struct GMT *)myalloc(16 * (int)totmod);
    if (read(fi,temp,16 * (int)totmod)== -1)
	error(1);

    temp->reserved = realstart + ((&temp[(int)(gen->mainmod - 1L)])->codead);

    (&temp[1])->reserved = gen->mainmod - 1L;
    
    MOVE(temp,start,16 * (int)totmod);
    start += 16L * totmod;
    
    free(temp);
    
    lseek(fi,(long) (gen->dirblk*512),0);
    curdir=totmod*64;
    
    directory=(struct MODDIR *)myalloc(curdir);
    modrec=(struct MODREC *)myalloc(3 * totmod * sizeof(struct MODREC));

    if (read(fi,directory,curdir)==-1)
	error(1);

    for (totmrec=curptr=t=0;curptr<totmod;curptr++) {
	modrec[t].record=directory[curptr].lblk;
	modrec[t].modoff=curptr;
	modrec[t].type='L';			/* Link information */
	t++;
	
	modrec[t].record=directory[curptr].cblk;
	modrec[t].modoff=curptr;
	modrec[t].type='C';			/* Code information */
	t++;
	
  
	modrec[t].record=directory[curptr].sbblk;
	modrec[t].modoff=curptr;
	modrec[t].type='S';
	t++;					/* Static base information */
    }
    if (t) {
	totmrec = t;
	sort(modrec,totmrec);
    }

    rdoff_ = -1;			/* Right now, we are nowhere */
    rdbyt_ = 0;				/* And we have no bytes in buffer */
    for (t=0;t<totmrec;t++) {

#ifdef debug
pinfo(&directory[modrec[t].modoff]);
#endif
	
	ldblk(fi,&modrec[t],&directory[modrec[t].modoff]);
    }
    free(modrec);
    free(directory);
}

#ifdef debug
pinfo(mod)
struct MODDIR *mod;
{
    int x;
    
    printf("Module ");
    
    for (x=0;x<8;x++) {
	putchar(mod->modnm[x]);
    }
    printf(" Code start %d, Link start %d, Entry %lx\n",mod->cblk,mod->lblk,mod->strtaddr);
}
#endif
    
VOID sort(modrec,totmrec)
struct MODREC *modrec;
int totmrec;
{
    int compare();
    qsort(modrec,totmrec,sizeof(struct MODREC),compare);
}

int compare(a,b)
struct MODREC *a,*b;
{
    return((a->record)-(b->record));
}


VOID ldblk(fi,modr,mod)
int fi;
struct MODREC *modr;
struct MODDIR *mod;
{
    int t;
    long offset;
    unsigned char *ld,*myalloc();

    switch(modr->type) {
    
	case 'C':
	    if ((offset=(long) mod->cblk*512l)>0) {

#ifdef debug
printf("\t(code) Now we load %ld bytes into physical address %lx\n",mod->clen,mod->caddr);
#endif

	
		mread(fi,offset,mod->caddr,mod->clen);
	    }
	    break;
	
	case 'L':

	    if ((offset=(long) mod->lblk*512l)>0) {

#ifdef debug
printf("\t(link) Now we load %ld bytes into physical address %lx\n",mod->llen,mod->laddr);
#endif
	
		mread(fi,offset,mod->laddr,mod->llen);
	    }
	    break;

	case 'S':

	    if ((offset=(long) mod->sbblk*512l)>0) {

#ifdef debug
printf("\t(sb) Now we load %ld bytes into physical address %lx\n",mod->slen,mod->saddr);
#endif
		mread(fi,offset,mod->saddr,mod->slen);
	    
	    } else {
		if (strncmp(mod->modnm,"$$$_COMM",8) == 0) 
		    zero_fill(mod->saddr,mod->slen);
	    }
	    break;
	    
	default:
	    printf("LOAD: Fatal error. Tried to load type \"%c\"\n",modr->type);
	    error(3);
    }
}


zero_fill(add,size)
long add,size;
{
    unsigned char *temp,*myalloc();
    int tsize;
    
    temp = myalloc(1000);
    
    while (size > 0) {
	tsize = (size > 1000) ? 1000 : (int) size;
	MOVE(temp,add,tsize);
	add += tsize;
	size -= tsize;
    }
    free(temp);
}

    
VOID error(x)
int x;
{
    printf("%s\n",erm[x]);
    exit(1);
}

unsigned char *myalloc(x)
int x;
{
    unsigned char *t,*calloc();
    if ((t=calloc(x,1))==NULL) {
	printf("\n\nLOAD: %d bytes: ",x);
	error(4);
    }
    return(t);
}



int mread(fd,offset,buffer,bytes)
int fd;
long offset,buffer;
long bytes;
{
    long locoff;
    register int lbytes;
    
    while (bytes) {	/* While we still have bytes to load */
	if (rdoff_ == -1) {	/* we don't know where we are */
	    rdoff_ = offset;	/* Point to current location */
	    if (lseek(fd,offset,0)==-1)
		error(2);
	    rdbyt_=0;
	}
	if (rdbyt_==0) {
	    rdbyt_ = read(fd,rdbuf_,RDBUFSIZE);
	    rdpos_ = 0;
	}
	if (rdbyt_==-1)
	    error(3);
	
	locoff = offset - rdoff_;	/* This is where we want to be */
	    

	if (locoff < 0) {
	printf("\nWe can't back up in file! Offset=%ld,%ld",offset,rdoff_);
	    exit(1);
	}
	
	if (locoff > (long)rdbyt_) {
	    /* If want to read in the next block, go there */
	    rdoff_+= (long) rdbyt_;
	    rdbyt_=0;
	} else {
	    rdoff_+=locoff;		/* Position to correct offset */
	    rdbyt_-=(int)locoff;	/* And decrement byte count */
	    rdpos_+=(int)locoff;	/* and correct position offset */
	    lbytes = (bytes > (long)rdbyt_) ? rdbyt_ : (int)bytes;
	    MOVE(&rdbuf_[rdpos_],buffer,lbytes);
	    buffer+= (long) lbytes;
	    bytes -= (long) lbytes;
	    offset+= (long) lbytes;
	    rdoff_+= (long) lbytes;
	    rdbyt_-= lbytes;
	    rdpos_+= lbytes;
	}
    }
    return(1);
}


    

int openx(s,i)
register unsigned char *s;
int i;
{
    unsigned char lclnam[100], *index();
#if PCDOS ==1
    char *getenv(), *env;
#endif
    int r1;
    
    if (s[1]==':') {
	r1 = open(s,i);
	goto ret;
    }
    
    if ((r1=open(s,i))!=-1)
	goto ret;
    
#if PCDOS != 1
    lclnam[0]='A'+GETSYS();
    lclnam[1]=':';
    lclnam[2]='\0';
    strcat(lclnam,s);
    r1 = open(lclnam,i);
#endif
#if PCDOS == 1
    if (index(s,'/') == NULL && index(s,'\\')== NULL) {
	if ( (env = getenv("DSI")) != NULL) {
	    while (parse(lclnam,s,&env)) {
		if ((r1 = open(lclnam,i)) != -1) 
		    break;
	    }
	} else if ( (env = getenv("PATH")) != NULL) {
	    while (parse(lclnam,s,&env)) {
		if ((r1 = open(lclnam,i)) != -1)
		    break;
	    }
	}
    }
#endif
		
ret:
    if (r1 >= 0) {
	ftype[r1] = 0;
	fisop[r1] = 1;
    }

    return(r1);
}

#if PCDOS == 1
parse(d,s,cd)
register char *d, *s;
char **cd;
{
    char *dir;
    
    if (**cd) {
	dir = *cd;
	while ((*dir != ';') && (*dir != '\0')) 
	    *d++ = *dir++;
	
	if (*dir) dir++;
	--d;
	if (*d != '/' && *d != '\\')
	    *++d = '\\';
	d++;
	
	while (*s) *d++ = *s++;
	
	*d = '\0';
	
	*cd = dir;
	
return(TRUE);
    }
return(FALSE);
}
#endif

	    

	
int openxa(s,i)
register unsigned char *s;
int i;
{
    unsigned char lclnam[100];
#if PCDOS ==1
    char *getenv(), *env;
#endif
    int r1;
    
    if (s[1]==':') {
	r1 = open(s,i);
	goto ret;
    }
    
    if ((r1=open(s,i))!=-1)
	goto ret;
    
	
#if PCDOS != 1
    lclnam[0]='A'+GETSYS();
    lclnam[1]=':';
    lclnam[2]='\0';
    strcat(lclnam,s);
    r1 = open(lclnam,i);
#endif
#if PCDOS == 1
    if (index(s,'/') == NULL && index(s,'\\')== NULL) {
	if ( (env = getenv("DSI")) != NULL) {
	    while (parse(lclnam,s,&env)) {
		if ((r1 = open(lclnam,i)) != -1) 
		    break;
	    }
	} else if ( (env = getenv("PATH")) != NULL) {
	    while (parse(lclnam,s,&env)) {
		if ((r1 = open(lclnam,i)) != -1)
		    break;
	    }
	}
    }
#endif
		
    
ret:
    if (r1 >= 0 ) {
	ftype[r1] = 1;
	fisop[r1] = 1;
    }
    return(r1);
}

/* finds the position of a string in another string.  Returns the offset to
    the substring's position (0 based) or -1 if not found.
*/
unsigned char *index1( str, sub,len ) unsigned char *str, *sub ; int len; {
    register unsigned char *sbase, *spt, *bpt ;

    for ( sbase = str ; len > 0 ; sbase++,len-- ) {
	for ( spt = sbase, bpt = sub ; *bpt != '\0' && *spt == *bpt ; spt++, bpt++ );
	if ( *bpt == '\0' )
return( sbase );
    }
return( 0 );
}

#if PCDOS == 1
abort(sig)
int sig;
{
    printf("\nLOAD: Control C aborted\n");
    finish();
    exit(-1);
}
#endif

