codeseg	segment public word 'code'
	assume	cs:codeseg, ds:dataseg, es:dataseg, ss:dataseg
	public	writea_
	extrn	write_:near

len	equ	word ptr 8[bp]
ptr1	equ	word ptr 6[bp]
fd	equ	word ptr 4[bp]
bufsiz	equ	4096

writea_	proc	near
	push	bp
	mov	bp,sp
	push	si
	push	di
	push	es
	push	ds
	pop	es			;make sure es is a copy of DS
	mov	si,ptr1			;get source pointer
	mov	di,offset locbuf	;destination pointer
	mov	cx,len			;total number of bytes to write
	mov	dx,0			;number of bytes to write
	jcxz	ex1			;if no bytes to write, just exit
lp:	lodsb				;get it
	cmp	al,10			;is it a LF?
	jz	filcr			;yes, add a CR
	stosb				;store it out
l1:	inc	dx
	cmp	dx,bufsiz		;are we over buffer size?
	jnc	flush			;yes, flush the buffer
l2:	loop	lp			;loop for more
	call	flush1			;flush what we need to
	cmp	ax,dx			;did we do ok?
	jnz	exit			;nope...
ex1:	mov	ax,len			;get back length
exit:	pop	es
	pop	di
	pop	si
	pop	bp
	ret				;and that will be all

filcr:	mov	ax,0a0dh		;stuff a CRLF
	stosw
	inc	dx			;one more
	jmp	l1			;and back into loop

flush:	push	cx			;because we use them
	call	flush1			;flush it
	pop	cx
	cmp	ax,dx			;did we write ok?
	jnz	exit			;nope. do the exit
	mov	dx,0			;zap count
	mov	di,offset locbuf	;and reset buffer
	jmp	l2

flush1:	push	dx			;save number of bytes
	push	dx			;and again
	mov	ax,offset locbuf	;get address of buffer
	push	ax			;save that
	push	fd			;save the file descriptor
	call	write_			;do the low-level write
	add	sp,6			;unstack
	pop	dx
	ret				;and return

writea_	endp
codeseg	ends

dataseg	segment public word 'data'
locbuf	db	4097 dup (?)
dataseg	ends


	
	