#define todec(x) ((x) & 0xf) + ((((x) & 0xf0) >> 4) * 10)
#include <time.h>

dostime(tl)
struct tm *tl;
{
    static int ytab[]={    365,365,366, /* 78-80 */
    		   365,365,365,366, /* 81 84 */
    		   365,365,365,366, /* 85 88 */
    		   365,365,365,366, /* 89 92 */
    		   365,365,365,366  /* 93 96 */
		};
    static int mtab[]={-1,31,28,31,30,31,30,31,31,30,31,30,31};
    		
    struct {
	int day;
	unsigned char hour;
	unsigned char min;
	unsigned char sec;
    } tod;
    register int tday,year,month,yday;
    
    bdos(155,&tod);

    tl->tm_sec = todec(tod.sec);
    tl->tm_min = todec(tod.min);
    tl->tm_hour = todec(tod.hour);

    tday = tod.day;
    year=0;
    
    while (tday > 0)
	tday -= ytab[year++];
	
    yday = tday += ytab[--year];
    
    if (ytab[year] == 366)
	mtab[2]=29;
    else
	mtab[2]=28;
	
    month = 1;
    
    while (tday > 0)
	tday -= mtab[month++];
	
    tday += mtab[--month];
    
    tl->tm_mday = tday;
    tl->tm_mon  = month - 1;
    tl->tm_year = year + 78;
    tl->tm_yday = --yday;
    tl->tm_wday = (yday + tl->tm_year + ((tl->tm_year-1)>>2) + 1) % 7;
    tl->tm_hsec = 0;
}
