#include "stdio.h"
#include "errno.h"
#include "ctype.h"
#include "rev.h"
#define and &&
#define or  ||
#define not !
#define orif  ||
#define andif &&
#define elseif else if
#define forever for(;;)
#define DO_NOTHING
#define internal
typedef char *STRING ;
typedef char BOOLEAN ;
typedef int (*intfunc)();
#define TRUE  1
#define FALSE 0
#define alloc_len(pt)	(8*(*(((int *) pt)-1))-sizeof( int ))

#ifdef debug
extern int g_errno ;
#else
#define g_errno errno
#define g_open  open
#define g_creat creat
#define g_close close
#define g_read  read
#define g_write write
#define g_sbrk  sbrk
#endif

/* there is some documentation/example in syscalls.c */
/* this package includes the following external routines
	START	;to be marked as the starting address of the program
		; calls main
	exit	;exits the program, closes all files
	getpid	;gets a (fake) PID

IO routines
	fputc	;adds a character to the specified file
	fgetc	;gets a character from the specified file
	fread	;reads an array from the specified file
	fwrite	;writes an array to the specified file
	fseek	;seeks to a byte in a stream file
	ftell	;tells the current byte location in a stream file
	rewind	;rewinds a stream file to the beginning
	getl	;Returns a 4byte integer from a file
	getw	;returns a 2byte integer from a file
	gets	;reads a string from standard input up to newline
	fgets	;reads a string from the specified file
	fopen	;opens a file in ascii mode
	fopenb	;opens a file in binary mode
	fopena	;opens a file in ascii mode
	fclose	;closes a file
	fflush	;flushes any buffered data to the file
	_flsbuf	;used by putc
	_filbuf	;used by getc
	putl	;puts a 4byte integer into a file
	putw	;puts a 2byte integer into a file
	puts	;puts a string onto standard output appending a newline
	fputs	;puts a string onto the specified file
	ungetc	;look-ahead mechanism, pushes a character back onto the
		;input stream
Storage allocation routines
	malloc	;allocates a specified amount of storage
	free	;returns malloc/calloced storage to the heap
	realloc	;Makes a piece of storage larger
	calloc	;allocates a specified amount of zeroed storage
	cfree	;returns malloc/calloced storage to the heap
String manipulation
	now all in STRINGS.A32

	clearn	;clears n bytes of storage
	filln	;fills n bytes of storage with the specified character
	index	;returns the position of a string in another
	rindex	;returns the position of a string in another starting at end
	strcat	;appends one string to another
	strchr	;returns the position of a character in a string
	strrchr	;returns the position of a character in a string from end
	strcpy	;copies one string to another
	strcmp	;compares two strings
	strlen	;finds the length of a string
	strncat
	strncpy
	strncmp
	strsave	;Allocates space and copies a string into it.
	swab	;swaps bytes in a word (ie conversion to/from pdp11s)
	bufcpy	;copies exactly n bytes

Formatting routines
	eprintf	;Prints stuff onto stdard error
	printf	;Prints stuff onto standard output
	fprintf	;Prints stuff onto the specified file
	sprintf	;Prints stuff onto the specified string
	perror	;Prints errno value and optional prefix string to stderr
	mktemp	;Creates a unique string (this requires getpid() or equivalent)
Unformatting routines
	fscanf	;Reads stuff from the specified file
	scanf	;Reads stuff from standard input
	sscanf	;Reads stuff from the specified string
	strtol	;converts a string to a number
	atol	;converts a string to a number
	atoi	;converts a string to a number
	atof	;converts a string to a number (double)
Math routines (more in math.c)
	rand	;returns a positive psuedo-random number between 0 and
		; 2029052025-1
	srand	;sets the seed of the random-number generator
*/

/* this is the routine that should start all c programs.  It opens stdin, etc
*/

extern int FILEBUF;
extern char **environ;
static int inode_no;

__vers_() {
    return(REVISION);
}

_strt() {
    char *malloc();
	/*
    static char *env[] = { NULL }, *argv[]={"", NULL};
	*/
    FILE *fopen();

    clearn( sizeof( _iob ), _iob );
    g_errno = 0 ;

#ifdef debug
    close(0); close(1); close(2);
#endif

    FILEBUF = BLKSIZ;
    if ((environ = malloc(32768)) != 0) {

	asm("movd	r0,r1");
	asm("addrd	@28,r0");
	asm("SVC");
/*
	asm("movd	r0,tos");
	asm("movd	_environ,tos");
	asm("cxp	_realloc");
	asm("cmpd	tos,tos");
	asm("movd	r0,_environ");
*/
    }

    
    
    fopen( "/dev/tty", "q0r" );
    fopen( "/dev/tty", "q1w" );
    fopen( "/dev/tty", "q2w" );

}


/* data */

struct iobuf _iob[_NFILE];
char _ctype_[]= {
0,		/* EOF */
_C,		/* ^@ */
_C,		/* ^A */
_C,		/* ^B */
_C,		/* ^C */
_C,		/* ^D */
_C,		/* ^E */
_C,		/* ^F */
_C,		/* ^G */
_C,		/* ^H */
_C|_S,		/* ^I */
_C|_S,		/* ^J */
_C|_S,		/* ^K */
_C|_S,		/* ^L */
_C|_S,		/* ^M */
_C,		/* ^N */
_C,		/* ^O */
_C,		/* ^P */
_C,		/* ^Q */
_C,		/* ^R */
_C,		/* ^S */
_C,		/* ^T */
_C,		/* ^U */
_C,		/* ^V */
_C,		/* ^W */
_C,		/* ^X */
_C,		/* ^Y */
_C,		/* ^Z */
_C,		/* ^[ */
_C,		/* ^\ */
_C,		/* ^] */
_C,		/* ^^ */
_C,		/* ^_ */
_S,		/*   */
_P,		/* ! */
_P,		/* " */
_P,		/* # */
_P,		/* $ */
_P,		/* % */
_P,		/* & */
_P,		/* ' */
_P,		/* ( */
_P,		/* ) */
_P,		/* * */
_P,		/* + */
_P,		/* , */
_P,		/* - */
_P,		/* . */
_P,		/* / */
_N,_X		/* 0 */
_N,_X		/* 1 */
_N,_X		/* 2 */
_N,_X		/* 3 */
_N,_X		/* 4 */
_N,_X		/* 5 */
_N,_X		/* 6 */      
_N,_X           /* 7 */
_N,_X		/* 8 */
_N,_X		/* 9 */
_P,		/* : */
_P,		/* ; */
_P,		/* < */
_P,		/* = */
_P,		/* > */
_P,		/* ? */
_P,		/* @ */
_U|_X,		/* A */
_U|_X,		/* B */
_U|_X,		/* C */
_U|_X,		/* D */
_U|_X,		/* E */
_U|_X,		/* F */
_U,		/* G */
_U,		/* H */
_U,		/* I */
_U,		/* J */
_U,		/* K */
_U,		/* L */
_U,		/* M */
_U,		/* N */
_U,		/* O */
_U,		/* P */
_U,		/* Q */
_U,		/* R */
_U,		/* S */
_U,		/* T */
_U,		/* U */
_U,		/* V */
_U,		/* W */
_U,		/* X */
_U,		/* Y */
_U,		/* Z */
_P,		/* [ */
_P,		/* \ */
_P,		/* ] */
_P,		/* ^ */
_P,		/* _ */
_P,		/* ` */
_L|_X,		/* a */
_L|_X,		/* b */
_L|_X,		/* c */
_L|_X,		/* d */
_L|_X,		/* e */
_L|_X,		/* f */
_L,		/* g */
_L,		/* h */
_L,		/* i */
_L,		/* j */
_L,		/* k */
_L,		/* l */
_L,		/* m */
_L,		/* n */
_L,		/* o */
_L,		/* p */
_L,		/* q */
_L,		/* r */
_L,		/* s */
_L,		/* t */
_L,		/* u */
_L,		/* v */
_L,		/* w */
_L,		/* x */
_L,		/* y */
_L,		/* z */
_P,		/* { */
_P,		/* | */
_P,		/* } */
_P,		/* ~ */
_C,		/* DEL */
};

/*****************************************************************************/
/*				IO routines				     */
/*****************************************************************************/

/* exits from the current process, and close all files nicely beforehand */

exit(val) int val ; {
    register int i ;
 /*
   if ( val != 0 )
	eprintf( "Error code=%d\n", val );  */

    for ( i=3 ; i < _NFILE ; i++ ) {
	if ( _iob[i].io_flags&(_IO_READ|_IO_WRITE) ) {
	    if ( _iob[i].io_flags&(_IO_BUF|_IO_USRBUF) )
		fclose( &_iob[i]);
	    else
		g_close( i );
	}
    }
    _exit(val);
}


/* seeks to an arbitrary point in the file */
fseek(file,offset,ptrname)
register FILE *file;
long offset;
int ptrname;
{
    long lseek(),tell();
	
    if (file->io_flags & _IO_WRITE) 
	fflush(file);
    else
	lseek(fileno(file),(long) -(file->io_lid - file->io_next),1);
    
    
    file->io_lid = file->io_base ;
    file->io_next = file->io_base ;
    if (lseek(fileno(file),offset,ptrname) == -1)
	return(-1);
    else
	return(0);
}

long ftell(file)
register FILE *file;
{
    long temp,tell();
    
    temp=tell(fileno(file));
    
    if (file->io_flags & _IO_DISK) 
	temp += (long) (file->io_next - file->io_base);
    if ((file->io_flags & _IO_WRITE) == 0)
	temp -= (long) (file->io_lid - file->io_base);
    return(temp); 
}

rewind(file)
FILE *file;
{
    return(fseek(file,0L,0));
}

    
    
	
    
	
/* gets the next character from the file. */
fgetc( file ) register FILE *file ; {
return( getc( file ));
}

/* Puts a single character into a file, may buffer it for later of course */
fputc(ch,file) int ch ; register FILE *file ; {
    putc(ch,file);
}

/* read/write an array of somethings onto a file openned with fopen */
fread(pt,size,nitems,file) register char *pt ; int size,nitems ; register FILE *file ; {
    register char *next, *lid ;
    register int byte, cnt ;

    next = file->io_next ; lid = file->io_lid ;
    g_errno = 0 ;
    for ( cnt=0 ; cnt < nitems ; cnt++ ) {
	for ( byte=0 ; byte < size ; byte++ ) {
	    if ( next < lid )
		*(pt++) = (unsigned) *(next++);
	    else {
		file->io_next = next ;
		*(pt++) = _filbuf( file );
		next = file->io_next ; lid = file->io_lid ; 
		if (g_errno != 0)
		    break;
	    }
	}
	if ( g_errno != 0 )
	    break ;
     }
     file->io_next = next ;
return( cnt );
}

fwrite(pt,size,nitems,file) register char *pt ; int size,nitems ; register FILE *file ; {
    register char *next, *top ;
    register int byte, cnt ;
   
    next = file->io_next ; top = file->io_top ;
    g_errno = 0 ;
    for ( cnt=0 ; cnt < nitems ; cnt++ ) {
	for ( byte=0 ; byte < size ; byte++ ) {
	    if ( next < top )
		*(next++) = *(pt++);
	    else {
		file->io_next = next ;
		_flsbuf( file, *(pt++));
		next = file->io_next ;
	    }
	    if (g_errno != 0)
		break;
	}
	if ( g_errno != 0 )
	    break ;
     }
     file->io_next = next ;
return( cnt );
}

/* the various routines that get words/longs/lines */
long getl( file ) register FILE *file ; {
    long ret ;
    register int ch ;
    register char *pt, *end ;
    
    pt = (char *) &ret ; end = pt+sizeof( long );
    while ( pt < end ) {
	if (( ch = getc( file ))== EOF )
return( EOF );
	*(pt++) = ch ;
    }
return( ret );
}

getw( file ) register FILE *file ; {
    /* note that this inputs a short, not an int */
    short ret ;
    register int ch ;
    register char *pt, *end ;
    
    pt = (char *) &ret ; end = pt+sizeof( short );
    while ( pt < end ) {
	if (( ch = getc( file ))== EOF )
return( EOF );
	*(pt++) = ch ;
    }
return( ret );
}

char *gets( str ) char *str ; {
    register char *pt=str ;
    register int ch ;
    register char *next, *lid ;
    

    next = stdin->io_next ; lid = stdin->io_lid ;
    forever {
	if ( next < lid )
	    ch = (unsigned) *(next++) ;
	else {
	    stdin->io_next = next ;
	    ch = _filbuf( stdin );
	    next = stdin->io_next ; lid = stdin->io_lid ; 
	}
	if ( ch == EOF or ch == '\n' ) {
	    stdin->io_next = next ;
	    *pt = '\0' ;
	    if ( ch == EOF and pt == str )
return( NULL );
	    else
return( str );
	} else
	    *(pt++) = ch ;
    }
}

char *fgets( str, n, file ) char *str ; int n ; register FILE *file ; {
    register char *pt=str ;
    register int ch ;
    register char *next, *lid ;
    
    next = file->io_next ; lid = file->io_lid ;
    while ( --n > 0 ) {
	if ( next < lid )
	    ch = (unsigned) *(next++) ;
	else {
	    file->io_next = next ;
	    ch = _filbuf( file );
	    next = file->io_next ; lid = file->io_lid ;
	}
	if ( ch == EOF or ch == '\n' ) {
	    file->io_next = next ;
	    if ( ch == '\n' )
		*(pt++) = '\n' ;
	    *pt = '\0' ;
	    if ( ch == EOF and pt == str )
return( NULL );
	    else
return( str );
	} else
	    *(pt++) = ch ;
    }
    file->io_next = next ;
    *pt = '\0' ;
return( str );
}

/* all the various ways of openning files */
internal _mode( str ) register char *str ; {
    /* parses a string mode string given to fopen, returns -1 on illegal */

    /* we now have RB, WB, so this is invalid 
    if ( str[1]!= '\0' )
return( -1 );
    */

    if ( *str == 'r' )
return( 0 );
    elseif ( *str == 'w' )
return( 1 );
    elseif ( *str == 'a' )
return( 1|_OP_EOF );
    else
return( -1 );
}

FILE *fopen(name, mode ) char *name, *mode ;
{
    FILE *_fopen();
    
    return(_fopen(name,mode,((toupper(mode[1]) == 'B') ? 4 : 0)));
}

FILE *fopena(name, mode ) char *name, *mode ;
{
    FILE *_fopen();
    return(_fopen(name,mode,0));
}

FILE *fopenb(name, mode ) char *name, *mode ;
{
    FILE *_fopen();
    return(_fopen(name,mode,4));
}


FILE *_fopen( name, mode, type ) char *name, *mode ; int type; {
    int m, fno, x ;
    FILE *file ;
    char *malloc();

    if (*mode != 'q') {
	if (( m = _mode( mode ))== -1 )
	    return( NULL );
	if ((m & 1)==1) {
	    if (m & _OP_EOF) {
		if ((fno = open(name, m|type)) == -1) {
		    if (type & 4)
			fno = creatb(name,0);
		    else
			fno = creata(name,0);
		}
	    } else {
		if (type & 4)
		    fno = creatb(name,0);
		else
		    fno = creata(name,0);
	    }
	} else 
	    fno = open(name,m|type);
	    
	if ( fno == -1 )
	    return( NULL );
	file = &_iob[fno];
	if (file->io_flags != 0) {
	    for (x=0; x<_NFILE; x++)
		if (_iob[x].io_flags == 0)
		    break;
	    file = &_iob[x];
	}
	file->io_flags = _IO_BUF | _IO_DISK | ((m==0)? _IO_READ : _IO_WRITE);
    } else {
	fno = (int) (*++mode - '0');
	m = _mode(++mode);
	file = &_iob[fno];
	file->io_flags = (((m==0)? _IO_READ : _IO_WRITE) | _IO_BUF);
    }
    

    file->io_file=fno;

    if ( not ( file->io_flags&_IO_BUF ))
return( file ); 			/* don't buffer character devices */

    file->io_base = malloc( FILEBUF);
    file->io_top = file->io_base+FILEBUF;
    file->io_lid = file->io_base ;
    file->io_next = file->io_base ;
return( file );
}

fclose( file ) register FILE *file ; {
    int ret = 0 ;

    if ( not ( file->io_flags&(_IO_READ|_IO_WRITE))) {
	g_errno = EBADF ;
return( EOF );
    }
    if (file->io_flags & _IO_WRITE)
	fflush(file);
    
    if ( file->io_flags&_IO_BUF )
	free( file->io_base );

    file->io_flags = 0; /* Make bloody sure we tell the file is closed */
    
    if ( g_close( file->io_file )== EOF )
	ret = EOF ;
return( ret );
}

/* the various routines used to deal with buffered streams */
fflush( file ) register FILE *file ; {
    register int size;
    
    size = file->io_next - file->io_base;
    if (size) {
	if (g_write( file->io_file, file->io_base, size)< 0 )
return( EOF );
    }
    file->io_lid = file->io_next = file->io_base ;
return( 0 );
}

_flsbuf( file,ch ) register FILE *file ; register int ch ; {
    char buf[1];
    register int doneflg = 1;

    if ( not ( file->io_flags&(_IO_BUF|_IO_USRBUF))) {
	buf[0]=ch ;
	g_write( fileno( file ), buf, 1 );
    } else {
	if ( file->io_next < file->io_top ) {
	    *(file->io_next++) = ch ;
	    doneflg = 0;
	}
	if (fflush(file) == EOF )
return ;
	if ( doneflg )
	    *(file->io_next++) = ch ;
    }
}

_filbuf( file ) register FILE *file ; {
    register int num ; char buf[1];
    register long tell(),tpos;
    register int ret;
    
    if (file->io_flags & _IO_STR) {
	ret = EOF;
	goto exit1;
    }
    
    if (file->io_flags & _IO_WRITE) 
	tpos = tell(fileno(file));
    
    if ( not ( file->io_flags&(_IO_BUF|_IO_USRBUF))) {
	if ( g_read( file->io_file, buf, 1 )<= 0 ) {
	    ret = EOF;
	    goto exit;
	}
	ret = (unsigned) buf[0];
	goto exit;
    }
    num = g_read( fileno( file ), file->io_base, file->io_top-file->io_base);
    if ( num <= 0 ) {
	errno = EOF;
	ret = EOF;
	file->io_flags |= _IO_EOF;
	goto exit;
    }
    file->io_next = file->io_base ;
    file->io_lid = file->io_base+num ;
    ret = ( (unsigned) *(file->io_next++) );

exit:
    if (file->io_flags & _IO_WRITE) 
	lseek(fileno(file),tpos,0);
exit1:
    return(ret);
}

/* the various routines that put words etc. */
putl(l,file) long l ; register FILE *file ; {
    register char *pt = (char *) &l, *end ;
    
    for ( end = pt+sizeof( long ) ; pt < end ; pt++ )
	putc( *pt,file );
}

putw(w,file) short w ; register FILE *file ; {
    /* not that this outputs a short, not an int */
    register char *pt = (char *) &w, *end ;
    
    for ( end = pt+sizeof( short ) ; pt < end ; pt++ )
	putc( *pt,file );
}

puts( str ) register char *str ; {
    register char *next, *end ;
    
    next = stdout->io_next ;
    end = stdout->io_top ;
    while ( *str != '\0' ) {
	if ( next < end ) 
	    *(next++) = *(str++);
	else {
	    stdout->io_next = next ;
	    _flsbuf( stdout,*(str++) );
	}
    }
    stdout->io_next = next ;
    _flsbuf( stdout,'\n' );
return( 0 );
}

fputs( str,file ) register char *str ; register FILE *file ; {
    register char *next, *end ;
    
    next = file->io_next ;
    end = file->io_top ;
    while ( *str != '\0' ) {
	if ( next < end and *str != '\n' ) 
	    *(next++) = *(str++);
	else {
	    file->io_next = next ;
	    _flsbuf( file,*(str++) );
	    next = file->io_next ;
	}
    }
    file->io_next = next ;
return( 0 );
}

ungetc(ch,file) int ch ; register FILE *file ; {
    register char *temp = ((char *) &file->io_tmp)+1 ;

    if ( not ( file->io_flags&_IO_READ )) {
	g_errno = EBADF ;
return( EOF );
    } elseif ( ch == EOF )
return( EOF );

    if ( file->io_next == temp )
return( EOF );
    if (( file->io_next == file->io_base and file->io_lid == file->io_next )
      or ( not ( file->io_flags&(_IO_BUF|_IO_USRBUF))) ) {
	file->io_next = temp ;
	file->io_lid = temp+1 ;
	*temp = ch ;
    } elseif ( file->io_next == file->io_base )
return( EOF );
    else
	    *--(file->io_next) = ch ;
return( ch );
}
/*****************************************************************************/
/*				Storage allocation			     */
/*****************************************************************************/

typedef struct free_hdr {
    long length ;
    struct free_hdr *next ;
} FREE ;

static FREE *first = NULL , *next;
	/* head of free list, and pointer to make Knuth happy */
static int alloc_quant = 4*BLKSIZ ;	/* default amount to allocate */
static int signal = 0 ;

char *malloc( siz ) int siz ; {
    register FREE *search , *prev ; FREE *get_free();
    register char *pt ;
    int size ;
    /* allocate size memory.  we only allocate memory in blocks of FREE's
	so size must be made a multiple of the size of a FREE, we also allocate
	an extra free so the the free routine can know how much to to free
	but this leaves us with an unused pointer, (the next field has no
	meaning if we aren't on the free list) so we can use this as data
	(note that we use units of FREE's rather than bytes)
    */

    if ( siz <= 0 )
return( NULL );

    size = (siz+sizeof( struct free_hdr *)+sizeof( FREE )-1)/sizeof( FREE )+1 ;
    if ( next != NULL orif get_free( size )!= NULL ) {
	for ( prev=next , search=prev->next ; ; prev = search , search = search->next ) {
	    if ( search->length >= size ) {
		if ( search->length == size )
		    prev->next = search->next ;
		else {
		    search->length -= size ;
		    search += search->length ;
		    search->length = size ;
		}
		next = prev ;
		if ( prev == search )
		    next = first = NULL ;
		elseif ( search == first )
		    first = search->next ;
		pt = (char *) &search->next ;
	break ;
	    } elseif ( search == next ) {
		if ( get_free( size )== NULL ) {
		    pt = NULL ;
	break ;
		}
	    }
	}
    } else
	pt = NULL ;
return( pt );
}

internal FREE *get_free( size ) int size ; {
    char *more, *g_sbrk();
    register FREE *new ;

    size = ((alloc_quant+size*sizeof( FREE )+BUFSIZ-1)/BUFSIZ)*BUFSIZ ;
    if (( more = g_sbrk( size ))== NULL or (int) more == -1 )
return( NULL );
    new = ( FREE * ) more ;
    new->length = size/sizeof( FREE ) - 1;
    free( ((char *) new)+sizeof( struct header * ) );
return( new );
}

free( pt ) char *pt ; {
    register FREE *prev , *item = (FREE *) (pt - sizeof( long ));

    if ( pt != NULL) {
	if ( first == NULL ) {
	    first = next = item->next = item ;
	} else {
	    for ( prev = ( item >= next or item <= first )? next : first ; 
		prev->next != first and !(prev <= item and prev->next > item);
		prev = prev->next );

	    if ( prev == item or item == first )
		eprintf( "Already free %x\r\n", item );
	    else {
		if ( item+item->length == prev->next ) {
		    item->length += prev->next->length ;
		    item->next = prev->next->next ;
		} elseif ( item+item->length < prev->next or item > prev->next )
			item->next = prev->next ;
		    else {
			eprintf( "Free list corrupted\r\n" );
return ;
		    }
		if ( prev+prev->length == item ) {
		    prev->length += item->length ;
		    prev->next = item->next ;
		} elseif ( prev+prev->length < item or prev > item )
			prev->next = item ;
		    else {
			eprintf( "Free list corrupted\r\n" );
return ;
		    }
		next = prev ;
		if ( prev < first )
		    first = prev ;
		elseif ( prev->next < first )
		    first = prev->next ;
	    }
	}
    }
}

char *realloc( old,new_size ) char *old ; int new_size ; {
    register char *pt ;

    if ( old == NULL )
return( malloc( new_size ));

    if (( pt = malloc( new_size ))!= NULL ) {
	bufcpy( pt,old ,(alloc_len( old ) > alloc_len(pt)) ? alloc_len(pt) : alloc_len(old));
	free( old );
    }
return( pt );
}

char *calloc( num,size ) int num,size ; {
    register char *temp ;

    if (( temp = malloc( num*size ))!= NULL )
	clearn( alloc_len( temp ),temp );
return( temp );
}

cfree( item ) char *item ; {
    free( item );
}


/*****************************************************************************/
/*				formatting routines			     */
/*****************************************************************************/

/* wait for the end of the printf to flush the buffer, not each newline */
#undef putc
#define putc(ch,f) putb(ch,f)

typedef struct {
    int size, decimals ;
    unsigned int use_space :1 ;
    unsigned int right_just :1 ;
    unsigned int sign :1 ;
    unsigned int pad :1 ;
    unsigned int alt_form :1 ;
    char type ;
} FORMAT ;

#define SIGDIG	20	/* in both ieee and vax d floating there are about 17 digits of accuracy */
typedef struct {
    int pred , postd , exp ;
    int ival ;
    int usable ;
    BOOLEAN isint ;
    char digits[SIGDIG];
} FLOAT_BUF ;

typedef char	**ARG_PT ;

#define DEFLT     -1
#define INTMAX	    20

#define BUFSIZE		100

static char space[BUFSIZE];

internal STRING percent( spec , format , args ) register STRING spec ; register FORMAT *format ; register ARG_PT *args ; {
    int num ;

    format->size = format->decimals = DEFLT ;
    format->use_space = format->right_just = TRUE ;
    format->sign = FALSE; format->pad = FALSE; format->alt_form=FALSE;
    format->type = '\0' ;

    while ( *spec=='-' or *spec == '+' or *spec == ' ' or *spec == '#' ) {
	if ( *spec == '-' )
	    format->right_just = FALSE ;
	elseif ( *spec=='+' )
	    format->sign = TRUE;
	elseif ( *spec == ' ' )
	    format->pad = TRUE;
	else
	    format->alt_form = TRUE;
	spec++;
    }

    if ( *spec == '0' ) {
	spec++ ;
	format->use_space = FALSE ;
    } elseif ( *spec == '.' )
    	format->use_space = FALSE ;

    if ( isdigit( *spec )) {
	num = 0 ;
	while( isdigit( *spec )) {
	    num = 10*num + *spec-'0' ;
	    spec++ ;
	}
	format->size = num ;
    } elseif ( *spec == '*' ) {
	format->size = *((int *) ((*args)++));
	spec ++ ;
    }
    if ( *spec == '.' ) {
	spec++ ;
	if ( isdigit( *spec )) {
	    num = 0 ;
	    while( isdigit( *spec )) {
		num = 10*num + *spec-'0' ;
		spec++ ;
	    }
	    format->decimals = num ;
	} elseif ( *spec == '*' ) {
	    format->decimals = *((int *) ((*args)++));
	    spec ++ ;
	}
    }
    if ( *spec == 'l' )
	spec++ ;
    format->type = *(spec++) ;
return( spec );
}

ARG_PT gww___printf( file , spec, args ) register FILE *file ; register STRING spec ; ARG_PT args ; {
    FORMAT format ;
    STRING percent();
    double foo ;
    int ch ;

    if ( spec == NULL )
	spec = "(null)";

    while ( *spec != '\0' ) {
	if ( *spec != '%' ) {
	    putc( *spec , file );
	    spec++ ;
	} else {
	    spec = percent( spec+1 , &format , &args );
	    switch ( format.type ) {
	    case '%':
		putc( '%',file ); break ;
	    case 'p':
		args = gww___printf( file , *((STRING *) args), args+1 );  break ;
	    case 's':
		strout( file , &format , *((STRING *) (args++))); break ;
	    case 'd':
		decout( file , &format , *((int *) (args++))); break ;
	    case 'o':
		octout( file , &format , *((unsigned *) (args++))); break ;
	    case 'x': case 'X':
		hexout( file , &format , *((unsigned *) (args++))); break ;
	    case 'u':
		unsout( file , &format , *((unsigned *) (args++))); break ;
	    case 'c':
		ch = *((int *) args++ );
		if (format.size != DEFLT) {
		    while (format.size--) 
			putc(ch,file);
		} else {
		    putc(ch,file);
		}
		break;
	    case 'e': case 'E':
	    	foo = *((double *) args); args += sizeof( double )/sizeof( *args);
		e_flt( file , &format , foo ); break ;
	    case 'f': case 'F':
	    	foo = *((double *) args); args += sizeof( double )/sizeof( *args);
		f_flt( file , &format , foo ); break ;
	    case 'g': case 'G':
	    	foo = *((double *) args); args += sizeof( double )/sizeof( *args);
		gen_flt( file , &format , foo ); break ;
	    default: ch = ch ;
	    }
	}
    }
return( args );
}

internal decout( file , format , val ) register FILE *file ; register FORMAT *format ; int val ; {
    register char *pt = space+BUFSIZE-1 ;
    BOOLEAN neg = FALSE ;

    *(pt--)= '\0' ;
    if ( val < 0 )
	neg = TRUE ;

    do {
	if ( val < 0 ) {
	    *(pt--) = -(val%10)+'0' ;
	    val = -(val/10) ;
	} else {
	    *(pt--) = (val%10)+'0' ;
	    val /= 10 ;
	}
    } while ( val != 0 );
    if ( neg )
	*(pt--) = '-' ;
    elseif ( format->sign )
    	*(pt--) = '+';
    elseif ( format->pad )
    	*(pt--) = ' ';

    format->decimals = DEFLT ;
    strout( file , format , pt+1 );
}

internal octout( file , format , val ) register FILE *file ; register FORMAT *format ; unsigned val ; {
    register char *pt = space+BUFSIZE-1 ;

    *(pt--)= '\0' ;

    do {
	*(pt--) = (val&07)+'0' ;
	val = (val>>3)& 0x1fffffff ;
    } while ( val != 0 );

    if ( format->alt_form )
    	*(pt--) = '0';
    format->decimals = DEFLT ;
    strout( file , format , pt+1 );
}

internal hexout( file , format , val ) register FILE *file ; register FORMAT *format ; unsigned val ; {
    static char digits[2][16] = {
	{ '0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f' },
	{ '0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F' }
    };
    register char *pt = space+BUFSIZE-1 ;
    register char *d = &digits[ format->type=='X' ][0];

    *(pt--)= '\0' ;

    do {
	*(pt--) = d[ val&0xf ];
	val = ( val >> 4 )& 0x0fffffff ;
    } while ( val != 0 );

    if ( format->alt_form ) {
	*(pt--) = format->type;
    	*(pt--) = '0';
    }
    format->decimals = DEFLT ;
    strout( file , format , pt+1 );
}

internal unsout( file , format , val ) register FILE *file ; register FORMAT *format ; unsigned val ; {
    register char *pt = space+BUFSIZE-1 ;
    static int power2[] = { 8 , 4 , 6 , 3 , 8 , 4 , 7 , 4 , 1 , 2 , 0 , 0 , 0 };
    int carry = 0 , i , temp ;
    BOOLEAN add = FALSE ;

    *(pt--)= '\0' ;

    if ( val & 0x80000000 ) {
	val &= ~0x80000000 ;
	add = TRUE ;
    }
    i = 0 ;
    do {
	if ( add ) {
	    temp = (val%10)+power2[i]+carry ;
	    if ( temp > 10 ) {
		temp -= 10 ;
		carry = 1 ;
	    } else
		carry = 0 ;
	} else
	    temp = val%10 ;
	*(pt--) = temp+'0' ;
	val /= 10 ;
	i++ ;
    } while ( val != 0 or carry != 0 or ( add and power2[i]!= 0 ));

    format->decimals = DEFLT ;
    strout( file , format , pt+1 );
}

internal strout( file , format , str ) register FILE *file ; register FORMAT *format ; register STRING str ; {
    int len , size , i , pad ;

    pad = (format->use_space)? ' ' : '0' ;
    if ( str == NULL )
	str = "(null)";

    len = strlen( str );
    if ( format->decimals != DEFLT and format->decimals < len )
	len = format->decimals ;
    size = ( format->size < len )? len : format->size ;

    if ( format->right_just ) {
	for ( i=size-len ; i > 0 ; i-- )
	    putc( pad , file );
	size = len ;
    }
    while ( *str != '\0' and len > 0 ) {
	putc( *str , file );
	str++ ;
	len-- ; size-- ;
    }
    for ( i=size-len ; i > 0 ; i-- )
	putc( pad , file );
}

#define fabs(x) ((x) < 0. ? -(x) : (x))

internal eval_flt( format , val , eval )
register FORMAT *format ;
register double val ;
register FLOAT_BUF *eval ;
{
    register int exp = 0, digits, i, temp;
    register double temp1;

    if (fabs(val) <= 2147483649.) {
	eval->ival = (int) val ;
	eval->isint = (double) eval->ival == val and eval->exp < 10 ;
    } else {
	eval->ival = 0;
	eval->isint = FALSE;
    }
    if ( format->decimals != DEFLT and format->decimals != 0 )
	eval->isint = FALSE ;

    if ( val < 0. ) val = -val ;
    if ( val != 0.0 ) {
	while ( val < 1.0 ) {
	    val *= 10. ;
	    exp-- ;
	}
	while ( val >= 10.0 ) {
	    val /= 10. ;
	    exp ++ ;
	}
    }

    if ( exp > 6 ) {
	eval->pred = exp ;
	eval->postd = 0 ;
	digits = exp ;
    } elseif ( exp > 0 ) {
	eval->pred = exp ;
	eval->postd = 6-exp ;
	digits = 7 ;
    } else {
	eval->pred = 0 ;
	eval->postd = 6-exp ;
	digits = 7 ;
    }
    if ( format->decimals != DEFLT ) {
	eval->postd = format->decimals ;
	digits = eval->pred+eval->postd+1 ;
    }
    if ( digits > SIGDIG )
	digits = SIGDIG ;

    /* at this point val is a number [1.,10.) or 0. */
    for ( i=0 ; i < digits ; i++ ) {
	temp = (int) val;	/* this gets around an apparent bug in trunc
				   Dave Rand, 08/04/85 */
    	eval->digits[i]= (int) val;
	temp1 = val;
	val = 10.*(val - (double)temp) ;
    }
    if ( val > 5. ) {			/* now round if desirable */
	for ( i=digits-1 ; i> 0 ; i-- ) {
	    if ( (++(eval->digits[i])) < 10 )
	break ;
	    else
		eval->digits[i]= 0 ;
	}
	if ( i== 0 ) {
	    if ( (++(eval->digits[0])) >= 10 ) {
		exp ++ ;
		eval->digits[0]= 1 ;
	    }
	}
    }
    if ( format->decimals == DEFLT ) {
	for ( i=digits-1 ; i > 0 and eval->digits[i]==0 ; i-- ) eval->postd--;
	digits = i+1 ;
    }
    eval->exp = exp ;
    eval->usable = digits ;
}

internal gen_flt( file , format , val, flush ) register FILE *file ; register FORMAT *format ; double val ; intfunc flush ; {
    FLOAT_BUF eval ;
    int edecs = ( format->decimals == DEFLT )? 6 : format->decimals ;

    eval_flt( format , val , &eval );
    if ( eval.isint and not format->alt_form )
	decout( file , format , eval.ival, flush );
    elseif ( 1+eval.pred+1+eval.postd > 1+1+edecs+4 )
	eout( file , format , val , &eval, flush );
    else
	fout( file , format , val , &eval, flush );
}

internal f_flt( file , format , val, flush ) FILE *file ; FORMAT *format ; double val ; intfunc flush ; {
    FLOAT_BUF eval ;

    eval_flt( format , val , &eval );
    if ( eval.isint and not format->alt_form )
	decout( file , format , eval.ival );
    else
	fout( file , format , val , &eval, flush );
}

internal e_flt( file , format , val, flush ) FILE *file ; FORMAT *format ; double val ; intfunc flush ; {
    FLOAT_BUF eval ;

    eval_flt( format , val , &eval );
    eout( file , format , val , &eval, flush );
}

internal fout( file , format , val , eval, flush ) FILE *file ; FORMAT *format ; double val ; FLOAT_BUF *eval ; intfunc flush ; {
    char *fltout();

    fltout( format , val , eval );
    strout( file , format , space, flush );
}

internal eout( file , format , val , eval , flush ) FILE *file ; register FORMAT *format ; double val ; register FLOAT_BUF *eval ; intfunc flush ; {
    char *fltout();
    int exp ;
    char *pt ;
    char foo[8];

    exp = (eval->exp < 0 )? -eval->exp : eval->exp ;
    eval->postd = format->decimals != DEFLT ? format->decimals : eval->usable-1 ;

    pt = foo ;
    *(pt++)= isupper( format->type )? 'E' : 'e' ;
    if ( eval->exp < 0 )
	*(pt++) = '-' ;
    elseif ( format->alt_form )
    	*(pt++) = '+';
    if ( exp/10 != 0 )
	*(pt++)='0'+exp/10 ;
    *(pt++)='0'+exp%10 ;
    *pt = '\0' ;

    exp = eval->exp ;
    while ( exp > 0 ) {
	val /= 10 ;
	exp-- ;
    }
    while ( exp < 0 ) {
	val *= 10 ;
	exp ++ ;
    }
    eval->exp = exp ;

    pt = fltout( format , val , eval );
    strcpy( pt, foo );
    strout( file , format , space, flush );
}

internal char *fltout( format , val , eval ) register FORMAT *format ; double val ; register FLOAT_BUF *eval ; {
    register int i, post, exp=eval->exp ;
    register char *pt ;

    pt = space ;
    if ( val < 0.0 ) {
	*(pt++) = '-' ;
	val = -val ;
    } elseif ( format->sign )
    	*(pt++)= '+';
    elseif ( format->pad )
    	*(pt++) = ' ';
    i=0; post = 0 ;
    while ( exp >= 0 and i < eval->usable ) {
	*(pt++) = eval->digits[i]+'0' ;
	exp-- ;
	i++ ;
    }
    while ( exp >= 0 ) {
	*(pt++) = '0';
	exp-- ;
    }
    *(pt++) = '.' ;
    while ( exp < -1 and post < eval->postd ) {
	*(pt++) = '0' ;
	exp++ ; post++ ;
    }
    while ( i < eval->usable and post < eval->postd ) {
	*(pt++) = eval->digits[i++]+'0';
	post++ ;
    }
    if ( post > 100 ) post = 100 ;
    while ( post++ < eval->postd )
	*(pt++) = '0';
    *pt = '\0' ;

    format->decimals = DEFLT ;
return( pt );
}

eprintf( args ) char *args ; {

    if ( stderr->io_flags & _IO_WRITE ) {
	gww___printf( stderr , args, ((ARG_PT) &args)+1 );
	if ( not ( stderr->io_flags&_IO_DISK ))
	    fflush( stderr );
    } else
	g_errno = EBADF ;
}

fprintf( file , args ) register FILE *file ; char *args ; {

    if ( file->io_flags & _IO_WRITE ) {
	gww___printf( file , args, ((ARG_PT) &args)+1 );
	if ( not ( file->io_flags&_IO_DISK ))
	    fflush( file );
    } else
	g_errno = EBADF ;
}

printf( args ) char *args ; {

    if ( stdout->io_flags & _IO_WRITE ) {
	gww___printf( stdout , args, ((ARG_PT) &args)+1 );
	if ( not (stdout->io_flags&_IO_DISK) )
	    fflush( stdout );
    } else
	g_errno = EBADF ;
}

sprintf( str , args ) STRING str ; char *args ; {
    FILE kludge ;

    clearn( sizeof( FILE ), &kludge );
    kludge.io_top = (char *) 0x7fffffff ;
    kludge.io_flags = _IO_STR ;
    kludge.io_next = kludge.io_base = str ;
    gww___printf( &kludge , args, ((ARG_PT) &args)+1 );
    *kludge.io_next = '\0' ;
}

#define INFINITY	1000000
#define BAD_OFF 	-3

internal skip_blanks( file , ch ) register FILE *file ; register int ch ; {

    while( ch != EOF and isspace( ch ))
	ch = getc( file );
return( ch );
}

gww___scanf( file, frmt, ungetc, args ) register FILE *file ; STRING frmt ; intfunc ungetc ; ARG_PT args ; {
    int done = 0, max_width, size, unsuppress ;
    int ch , fch ;
    long ifoo ; 
    double ffoo ;			/* junk locs for suppression */

    ch = getc( file );
    while ( ch != EOF and *frmt != '\0' ) {
	if ( isspace( *frmt )) {
	    while ( isspace( *frmt ))
		frmt ++ ;
	    ch = skip_blanks( file, ch );
	} elseif ( *frmt != '%' ) {
	    if ( *frmt != ch ) {
		if ( ch != EOF )
		    (*ungetc)( ch,file );
return(( done==0 and ch == EOF )? EOF : done );
	    }
	    frmt++ ;
	    ch = getc( file );
	} else {
	    frmt++ ;
	    size = 0 ; max_width = 0 ; unsuppress = TRUE ;
	    forever {
		if ( isupper(fch = *(frmt++)) )
		    fch = tolower( fch );
		if ( isdigit( fch ))
		    max_width = 10*max_width + fch-'0' ;
		elseif ( fch == 'l' )
		    size ++ ;
		elseif ( fch == 'h' )
		    size -- ;
		elseif ( fch == '*' )
		    max_width = *((int *) (args++));
		elseif ( fch == '^' )
		    unsuppress = FALSE ;
		else
	    break ;
	    }
	    if ( fch != '%' and fch != 'c' and fch != '[' )
		ch = skip_blanks( file , ch );
	    if ( max_width <= 0 )
		max_width = INFINITY ;
	    switch ( fch ) {
	    case '%' :
		if ( ch != '%' ) {
		    if ( ch != EOF )
			(*ungetc)( ch,file );
return(( done==0 and ch == EOF )? EOF : done );
		}
		ch = getc( file );  break ;
	    case 'c' :
		if ( unsuppress ) {
		    **((char **) (args++)) = ch ;
		    done ++ ;
		}
		ch = getc( file ); break ;
	    case 'o' : case 'd' : case 'x' :
		if (( ch = read_num( unsuppress ? *((int **) (args++)): &ifoo , file , ch , fch == 'o' ? 8 : fch == 'd' ? 10 : 16, max_width, size ))>= EOF )
		    done += unsuppress ;
		else {
		    if ( ch != -EOF+BAD_OFF )
			(*ungetc)( -ch+BAD_OFF, file );
return(( done==0 and ch == -EOF+BAD_OFF )? EOF : done );
		}   break ;
	    case 'e' : case 'f' : case 'g' :
		if (( ch = read_float( unsuppress ? *((double **) (args++)): &ffoo , file , ch, max_width, size ))>= EOF )
		    done += unsuppress ;
		else {
		    if ( ch != -EOF+BAD_OFF )
			(*ungetc)( -ch+BAD_OFF, file );
return(( done==0 and ch == -EOF+BAD_OFF )? EOF : done );
		}   break ;
	    case 's' :
		ch = read_string( unsuppress, &args, file, ch, max_width );
		done ++ ;   break ;
	    case '[' :
		ch = read_tstr( &frmt, unsuppress, &args, file, ch, max_width );
		done ++ ;   break ;
	    default :
return( done );
	    }
	}
    }
    if ( ch != EOF )
	(*ungetc)( ch, file );
return(( ch == EOF and done == 0 )? EOF : done );
}

internal int read_tstr( frmt, unsuppress, args, file, ch, max_width ) STRING *frmt ; int unsuppress, ch, max_width ; ARG_PT *args ; register FILE *file ; {
    register char *pt ;
    register int tog , och = -1 ;
    char ok_char[ 256 ];

    pt = (*frmt)++ ;			    /* skip the "[" */
    if ( not ( tog = *pt != '^' ))
	pt++ ;
    filln( 256, ok_char, not tog );
    if ( *pt == ']' ) {
	pt++ ;
	ok_char[ ']' ]= tog ;
    }
    while ( *pt != ']' ) {
	if ( *pt == '-' and och != -1 and *(pt+1)!= '\0' and *(pt+1)!= ']') {
	    pt++ ;
	    while ( och < *pt )
		ok_char[ och++ ]= tog ;
	    och = -1 ;
	} else
	    ok_char[ och = *pt ]= tog ;
	pt++ ;
    }
    *frmt = pt+1 ;

    pt = unsuppress ? *((*(( char ***) args))++) : NULL ;
    while ( ch != EOF and ok_char[ ch ] and max_width-- > 0 ) {
	if ( pt != NULL )
	    *(pt++) = ch ;
	ch = getc( file );
    }
    if ( pt != NULL )
	*pt = '\0' ;
return( ch );
}

internal int read_string( unsuppress, args, file, ch, max_width ) int unsuppress, ch, max_width ; ARG_PT *args ; register FILE *file ; {
    register char *pt ;

    pt = unsuppress ? *((*(( char ***) args))++) : NULL ;
    while ( ch != EOF and not isspace( ch ) and max_width-- > 0 ) {
	if ( pt != NULL )
	    *(pt++) = ch ;
	ch = getc( file );
    }
    if ( pt != NULL )
	*pt = '\0' ;
return( ch );
}

internal read_num( val, file, ch, base, max_width, size ) int *val, ch, base, max_width, size ; register FILE *file ; {
    static char digits[] = { '0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f' };
    register int lc, v=0, sign=0;
    register char *off ; char *strchr();

    if ( ch == '-' or ch == '+' ) {
	sign = ch == '-' ;
	ch = getc( file ); max_width-- ;
    }

    if ( base == 16 and ch == '0' ) {
	ch = getc( file ); max_width -- ;
	if ( ch == 'x' or ch == 'X' ) {
	    ch = getc( file );
	    max_width -- ;
	}
    }

    lc = isupper( ch )? tolower( ch ): ch ;
    if ( ch == EOF orif (off = strchr( digits, lc ))== NULL orif off-digits >= base )
return( BAD_OFF-ch );
    while ( ch != EOF and (off = strchr( digits, lc ))!= NULL andif off-digits < base and max_width -- > 0 ) {
	v = base*v + (off-digits) ;
	ch = getc( file );
	lc = isupper( ch )? tolower( ch ): ch ;
    }
    if ( sign )
	v = -v ;
    if ( size < 0 )
	*((short *) val) = v ;
    elseif ( size > 0 )
	*((long *) val) = v ;
    else
	*val = v ;
return( ch );
}

internal read_float( val, file, ch, max_width, size ) float *val; int ch, max_width, size ; register FILE *file ; {
    register double v=0.0 ;
    register int exp=0, dec=0, sign=0, exp_sign=0 ;

    if ( ch == '+' or ch == '-' ) {
	sign = ch == '-' ;
	ch = getc( file ); max_width -- ;
    }
    if ( ch == EOF or not ( isdigit( ch ) or ch == '.' ))
return( BAD_OFF-ch );

    while ( ch != EOF and isdigit( ch ) and max_width-- > 0 ) {
	v = 10.0*v + (double)(ch-'0') ;
	ch = getc( file );
    }
    if ( ch == '.' andif max_width-- > 0 ) {
	ch = getc( file );
	while ( ch != EOF and isdigit( ch ) and max_width-- > 0 ) {
	    v = 10.0*v + (double)(ch-'0') ;
	    ch = getc( file );
	    dec++ ;
	}
    }
    if (( ch == 'e' or ch == 'E') and max_width-- > 0 ) {
	ch = getc( file );
	if ( ch == '-' or ch == '+' ) {
	    exp_sign = ch == '-' ;
	    max_width-- ;
	    ch = getc( file );
	}
	while ( ch != EOF and isdigit( ch ) and max_width-- > 0 ) {
	    exp = 10*exp + (double)(ch-'0') ;
	    ch = getc( file );
	}
	if ( exp_sign )
	    exp = -exp ;
    }
    exp -= dec ;
    while ( exp > 0 ) {
	v *= 10.0 ;
	exp-- ;
    }
    while ( exp++ < 0 )
	v /= 10.0 ;
    if ( sign )
	v = -v ;
    if ( size > 0 )
	*((double *) val) = v ;
    else
	*val = (float)v ;
return( ch );
}

fscanf( file, args ) FILE *file ; char *args ; {
    int ungetc();

    if ( file->io_flags & _IO_READ )
return( gww___scanf( file , args , ungetc, ((ARG_PT) &args)+1 ));
    else
	g_errno = EBADF ;
return( -1 );
}

scanf( args ) char *args ; {
    int ungetc();

    if ( stdin->io_flags & _IO_READ )
return( gww___scanf( stdin , args , ungetc, ((ARG_PT) &args)+1 ));
    else
	g_errno = EBADF ;
return( -1 );
}

internal noop() {
}

sscanf( str, args ) STRING str ; char *args ; {
    FILE kludge ;

    clearn( sizeof( FILE ), &kludge );
    kludge.io_lid = str+strlen( str );
    kludge.io_next = kludge.io_base = str ;
    kludge.io_flags = _IO_EOF|_IO_STR ;
return( gww___scanf( &kludge , args , noop, ((ARG_PT) &args)+1 ));
}

/* converts an ascii string into an int */

long strtol(str,ptr,base) register char *str, **ptr ; register int base ; {
    register unsigned long result = 0 ;
    register int ch ;
    int neg = FALSE ;

    while ( isspace( *str )) str++ ;
    if ( *str == '-' ) {
    	neg = TRUE ;
	str++ ;
    } elseif ( *str == '+' )
    	str++ ;

    if ( base <= 1 or base > 36 ) {
	if ( *str == '0' and ( str[1]== 'x' or str[1]== 'X' )) {
	    str += 2 ;
	    base = 16 ;
	} elseif ( *str == '0' )
	    base = 8 ;
	else
	    base = 10 ;
    }

    forever {
	ch = *(str++);
	if (( isdigit( ch ) and ch-'0' >= base )
    	or ( islower( ch ) and ch-'a'+10 >= base )
	or ( isupper( ch ) and ch-'A'+10 >= base ))
    break ;
    	if ( isdigit( ch )) {
	    if ( ch-'0' > base )
    break ;
	    ch -= '0' ;
	} elseif ( islower( ch )) {
	    if ( ch-'a'+10 > base )
    break ;
	    ch -= 'a'-10 ;
	} elseif ( isupper( ch )) {
	    if ( ch-'A'+10 > base )
    break ;
	    ch -= 'A'-10 ;
	} else
    break ;
    	result = base*result + ch ;
    }
    if ( ptr != NULL )
    	*ptr = str-1 ;
    if ( neg )
return( -((long) result));

return( (long) result );
}

long atol( str ) char *str ; {
return( strtol( str, (char **) NULL, 10));
}

int atoi( str ) char *str ; {
return( (int) strtol( str, (char **) NULL, 10));
}

double atof( str ) register char *str ; {
    register double v=0.0 ;
    register int exp=0, dec=0, sign=0, exp_sign=0 ;

    while ( *str == ' ' ) str++ ;

    if ( *str == '+' or *str == '-' ) {
	sign = *str == '-' ;
	str++ ;
    }
    while ( isdigit( *str ))
	v = 10.*v + ( *(str++) - '0' );
    if ( *str == '.' ) {
	str++ ;
	while ( isdigit( *str )) {
	    v = 10.*v + ( *(str++)-'0' );
	    dec ++ ;
	}
    }
    if ( *str == 'e' or *str == 'E' ) {
	str++ ;
	if ( *str == '+' or *str == '-' ) {
	    exp_sign = *str == '-' ;
	    str++ ;
	}
	while ( isdigit( *str ))
	    exp = 10*exp + (*(str++)-'0');
	if ( exp_sign )
	    exp = -exp ;
    }
    exp -= dec ;
    while ( exp > 0 ) {
	v *= 10.0 ;
	exp-- ;
    }
    while ( exp++ < 0 )
	v /= 10.0 ;
    if ( sign )
	v = -v ;
return( v );
}

/*****************************************************************************/
/*				math routines				     */
/*****************************************************************************/

/* random number generator - Replaced 7/29/86 by Greg Slocum w/algo from
   Knuth 3.3.4 Table 1 line 26 -- Spectral purity is execellent.
   Returns #'s is range 0 to 0xFFFFFFFF */

static unsigned int seed;		/* I assume that a long is 32 bits */

unsigned int rand() {
	seed = seed * 1664525 + 1664525;
	return(( unsigned int )( seed ));
}

void srand( val )
int val;
{
    seed = val;
}

getpid() {
    return(rand());
}

perror(s)
char *s;
{
    eprintf(s);
}


char *mktemp(str) char *str ; {
    static int which;
    register char *pt ;
    register unsigned int i;

    pt = str;
    str += strlen( str )-6 ;
    i=which/72;
    if ( i<=9 )
    	*(str++)= '0'+i;
    else if ( i<=35 )
    	*(str++)= 'a'-10+i;
    else
    	*(str++)= 'A'-36+i;
    i = which%72;
    if ( i<=9 )
    	*(str++)= '0'+i;
    else if ( i<=35 )
    	*(str++)= 'a'-10+i;
    else
    	*(str++)= 'A'-36+i;
    which++;
    i=getpid();
    while ( i!= 0 ) {
	if ((i&0xf)<=9 )
	    *(str++)= '0'+(i&0xf);
	else
	    *(str++)= 'a'-10+(i&0xf);
	i >>= 4;
    }
    while ( *str=='X' || *str == 'x' ) *(str++)= '0';
return( pt );
}

FILE *freopen(name,access,stream)
register char *name,*access;
register FILE *stream;
{
    register FILE *news;
    fclose(stream);
    news = fopen(name,access);
    if ((news != stream) && (news != NULL)) {
	bufcpy(stream,news,sizeof(struct iobuf));
	news->io_flags = 0;
	news = stream;
    }
    return(news);
}


FILE *freopa(name,access,stream)
register char *name,*access;
register FILE *stream;
{
    register FILE *news;
    fclose(stream);
    news = fopena(name,access);
    if ((news != stream) && (news != NULL)) {
	bufcpy(stream,news,sizeof(struct iobuf));
	news->io_flags = 0;
	news = stream;
    }
    return(news);
}


FILE *freopb(name,access,stream)
register char *name,*access;
register FILE *stream;
{
    register FILE *news;
    fclose(stream);
    news = fopenb(name,access);
    if ((news != stream) && (news != NULL)) {
	bufcpy(stream,news,sizeof(struct iobuf));
	news->io_flags = 0;
	news = stream;
    }
    return(news);
}

#include "types.h"
#include "stat.h"

isatty(x) int x; {
    if (x < 3)
return(TRUE);
return(FALSE);
}

int fstat(file,x)
FILE *file;
struct stat *x;
{
    x->st_uid=0;
    x->st_gid=0;
    x->st_nlink=1;
    x->st_ino= ++inode_no;
    x->st_mode = S_IFREG;
    if (inode_no > 32767) inode_no = 0;
    return(0);
}

int stat(s,x)
char *s;
struct stat *x;
{
    if (!access(s,4)) {
	x->st_uid=0;
	x->st_gid=0;
	x->st_ino= ++inode_no;
	x->st_nlink=1;
	x->st_mode = S_IFREG;
	if (inode_no > 32767) inode_no = 0;
return(0);
    }
    return(-1);
}
truncate() {
return(0);
}

setbuf(file,buf)
register FILE *file;
register char *buf;
{
    char *malloc();
    
    if (file->io_flags == 0)
return;
    
    if (file->io_flags & _IO_BUF)
	free(file->io_base);
    
    file->io_flags &= ~_IO_BUF;
    
    if (buf == NULL) {
	file->io_base = malloc(1);
	file->io_top = file->io_base+1;
	file->io_lid = file->io_base ;
	file->io_next = file->io_base ;
    } else {
	file->io_flags |= _IO_USRBUF;
	file->io_base = buf;
	file->io_top = file->io_base + BUFSIZ;
	file->io_lid = file->io_base;
	file->io_next = file->io_base;
    }
}

access(s,mode)
char *s;
int mode;
{
    int i;
    if ((i = open(s,0)) != -1) {
	close(i);
return(0);
    }
    
    return(-1);
}

char *getenv(s)
char *s;
{
    static char buff[80];
    register int x;
    char *strchr(),*malloc();
    
    if (environ == 0) {
	if ((environ = malloc(32768)) == 0)
return(NULL);
	asm("movd	r0,r1");
	asm("addrd	@28,r0");
	asm("SVC");
/*
	asm("movd	r0,tos");
	asm("movd	_environ,tos");
	asm("cxp	_realloc");
	asm("cmpd	tos,tos");
	asm("movd	r0,_environ");
*/
    }
    
    strcpy(buff,s);
    strcat(buff,"=");
    x = 0;
    while (environ[x]) {
	if (index(environ[x],buff) == 0) {
	    strcpy(buff,(strchr(environ[x],'=') + 1));
return(buff);
	}
	x++;
    }
return(NULL);
}
    
    
