#include <stdio.h>
    
#define MONO_TYPE 32
#define COLOR_TYPE 22
#define COLOR_320 4
#define COLOR_640 6
#define COMPAQ 1

#if PCDOS == 1 
#define ToGraph320 "\33[=4h"
#define ToGraph640 "\33[=6h"
#define ToText     "\33[=3h"
#else
#define ToGraph320 "\33a4"
#define ToGraph640 "\33a6"
#define ToText     "\33a3"
#endif

main() {
    
    clearcolor();
#if COMPAQ==0
    flashbox(MONO_TYPE); /* Do the mono flashes */
#endif
    flashbox(COLOR_TYPE); /* Do the color flashes */
    flashcircle(COLOR_320); /* Do low-res color circles */
    flashcircle(COLOR_640); /* Do high-res color circles */
    clearcolor();
#if COMPAQ==1
    printf("%s",ToText);
#endif
}
    
clearcolor(){
    UBYTE *vs,*v_init();
    
#if COMPAQ==0
    printf("%s",ToText);
#endif
    vs=v_init(3);
    v_update(vs);
    v_free(vs);
}
    

flashbox(type)
ULONG type;
{
    UBYTE *vs[10],*v_init();
    ULONG cur_vs,r1,c1,r2,c2,x,temp;
	
    vs[0]=v_init(type);
    vs[1]=v_init(type);
    vs[2]=v_init(type);
	
    v_box(vs[2],0,0,23,79);
	
    if (type == COLOR_TYPE)
	v_attrib(vs[2],14); /* Set color to yellow */

    v_printf(vs[2],1,20,"The Definicon DSI-32 Co-Processor board");
    v_bupdate(vs[2]);
    
    cur_vs=0;

	for (x=0;x<500;x++) {
	    v_copy(vs[2],vs[cur_vs]);
	    r1 = (rand() % 21)+2;
	    c1 = rand() % 79;
	    r2 = (rand() % 21)+2;
	    c2 = rand() % 79;
	    
	    if (type == COLOR_TYPE) {
		temp = rand() & 15;  /* Get color for character (box) */
		v_attrib(vs[cur_vs],temp);
		/* Set a random color for the box */
	    }

	    v_box(vs[cur_vs],MIN(r1,r2),MIN(c1,c2),MAX(r1,r2),MAX(c1,c2));
	    v_bupdate(vs[cur_vs]);
	    cur_vs = cur_vs ^ 1;  /* switch from vs[0] to vs[1] and back */
	}
    
    v_free(vs[0]);
    v_free(vs[1]);
    v_free(vs[2]);
}

flashcircle(type)
ULONG type;
{
    
    UBYTE *vs[10],*v_init();
    ULONG vsx,back,color,maxx,maxcol,colormask;
    ULONG r,c,r1,c1,x,rad;
    
    vs[0] = v_init(4);
    vs[1] = v_init(6);
    
    if (type == COLOR_320) {
	printf("%s",ToGraph320);
	back = 0;
	maxx = 256;
	maxcol = 319;
	colormask = 3;
    } else {
	printf("%s",ToGraph640);
	back = 9;
	maxx = 112;
	maxcol = 639;
	colormask = 1;
    }
    
    vsx = 0;
    for (x=0;x<maxx;x++) {
	if ((x % 16) == 0) {
	    if (colormask != 1)
		color = rand() & colormask;
	    else
		color = 1;
	    color = (color << 4) + back;
	    OUTPUT(0x3d9,color);
	    back++;
	}
	r = rand() % 199;
	c = rand() % maxcol;
	rad = rand() % 199;
	color = rand() & colormask;
	if (!color)
	    color++;
	v_circle(vs[0],r,c,rad,color);
	r = rand() % 199;
	c = rand() % maxcol;
	r1 = rand() % 199;
	c1 = rand() % maxcol;
	color = rand() & colormask;
	if (!color)
	    color++;
	v_line(vs[0],r,c,r1,c1,color);
	
	if ((x % 2) == 0)
	    v_update(vs[0]);
	if ((x % 10) == 0) {
	    v_cls(vs[0]);
	}
    }
}
