#include <stdio.h>
#include <ctype.h>
#include "duart.h"

#define STARTAT 8  /* please start at 2400 baud */
#define VISUAL 0   /* Turn this on to see each char as it is xmitted */

main() {
    
    printf("DSI-32 DUART Test program, version 1.0\n");

    init();
    
    loopback(TRUE); /* Set mode to internal loopback */
    
    testall(); /* Test all baud rates */
    
    printf("\nPlease place LOOPBACK connector on BOTH serial ports\n");
    printf("Press RETURN when done");
    getchar();
    
    loopback(FALSE); /* Set mode to external loopback */
    testall();
    printf("\nProgram complete\n");
}

testall() {
    int x,y;
    for (y=0; y<2; y++) {
	for (x=STARTAT; x<NUMBAUD; x++) {
	    printf("Currently testing %7d baud\n",baudrate[y][x]);
	    printf("Port 0...");
	    test(baudrate[y][x],y,0);
	    printf("Port 1...");
	    test(baudrate[y][x],y,1);
	    printf("\n");
	}
    }
}

    
int test(baud,mode,port)
int baud,mode,port;
{
    int x,t;
	    
    chbaud(baud,mode,port);

    for (x=0; x<256; x++) {
	out(x,port);
#if VISUAL
	printf("Sending %d\r",x);
#endif
	if ((t = inp(port)) != x) {
	    printf("Bad. Was %d, should be %d\n",t,x);
	    while (inp(port) != -1) 
		;
return(TRUE); 
	}
    }

#if VISUAL
    printf("\n");
#endif
		
    return(FALSE);
}

int chbaud(baud,mode,port)
int baud,mode,port;
{
    int x,csr;
    
    csr = -1;
    for (x=0; x<NUMBAUD; x++) {
	if (baud==baudrate[mode][x]) {
	    csr = x;
	    break;
	}
    }
    
    if (csr == -1)
return(TRUE);
	
    csr |= csr << 4; /* setup both rx and tx */
    
    if (port == 0) 
	DURT_1 = csr;
    else
	DURT_9 = csr;
	
    DURT_4 = (mode << 7) | 0x10; /* counter/timer mode */
    
    return(FALSE);
}

out(byte,port)
UBYTE byte;
int port;
{
    int x;
    
    if (port==0) {
	for (x=0; x<OTIMEOUT; x++)
	    if ((DURT_1) & 0x4)
		break;
	DURT_3 = byte;
    } else {
	for (x=0; x<OTIMEOUT; x++)
	    if ((DURT_9) & 0x4)
		break;
	DURT_B = byte;
    }
}

int inp(port)
int port;
{
    int x,byte;
    
    if (port == 0) {
	for (x=0; x<ITIMEOUT; x++)
	    if ((DURT_1) & 1)
		break;
	if (x == ITIMEOUT)
	    byte = -1;
	else
	    byte = DURT_3;
    } else {
	for (x=0; x<ITIMEOUT; x++)
	    if ((DURT_9) & 1)
		break;
	if (x == ITIMEOUT)
	    byte = -1;
	else
	    byte = DURT_B;
    }
    
    return(byte);
}

    
loopback(well)
int well;
{
    int mr2;
    
    mr2 = 0x07; /* Normal mode, one stop */
    
    if (well)   /* We do want to loopback */
	mr2 |= 0x80; /* set to local loopback */
    
    DURT_0 = mr2;
    DURT_8 = mr2; /* set up both channels */
}
	
init() {
    

    DURT_2 = 0x10; /* Byte pointer reset */
    
    DURT_0 = 0x13; /* set to 8 bits, no parity */
    DURT_0 = 0x07; /* Set to no loopback, 1 stop */
    
    DURT_A = 0x10; /* Byte pointer reset */
	
    DURT_8 = 0x13; /* set to 8 bits, no parity */
    DURT_8 = 0x07; /* Set to no loopback, 1 stop */
    
    DURT_1 = 0xbb; /* set to 9600 baud, rx and tx on A */
    DURT_9 = 0xbb; /* set to 9600 baud, rx and tx on B */
    
    DURT_D = 0;	   /* Set 8 bit output port */
    
    DURT_4 = 0x10;  /* set interrupt input off, count from RXa */
    DURT_5 = 0x0;   /* set all interrupts off */

    DURT_2 = 0x05;  /* enable cha rx and tx */
    DURT_A = 0x05;  /* enable chb rx and tx */
}

    
    
    
    
